/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.protocol.protocol1_13_2to1_14.packets;

import com.google.common.collect.ImmutableSet;
import com.viaversion.viabackwards.ViaBackwards;
import com.viaversion.viabackwards.api.rewriters.EnchantmentRewriter;
import com.viaversion.viabackwards.api.rewriters.ItemRewriter;
import com.viaversion.viabackwards.protocol.protocol1_13_2to1_14.Protocol1_13_2To1_14;
import com.viaversion.viabackwards.protocol.protocol1_13_2to1_14.storage.ChunkLightStorage;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.minecraft.ClientWorld;
import com.viaversion.viaversion.api.minecraft.Environment;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSection;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSectionLight;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSectionLightImpl;
import com.viaversion.viaversion.api.minecraft.chunks.DataPalette;
import com.viaversion.viaversion.api.minecraft.chunks.PaletteType;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.api.minecraft.entities.EntityTypes1_14;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.minecraft.metadata.Metadata;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.chunk.ChunkType1_13;
import com.viaversion.viaversion.api.type.types.chunk.ChunkType1_14;
import com.viaversion.viaversion.api.type.types.version.Types1_13;
import com.viaversion.viaversion.api.type.types.version.Types1_13_2;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ListTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.StringTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.ChatRewriter;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.ClientboundPackets1_13;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.ServerboundPackets1_13;
import com.viaversion.viaversion.protocols.protocol1_14to1_13_2.ClientboundPackets1_14;
import com.viaversion.viaversion.protocols.protocol1_14to1_13_2.Protocol1_14To1_13_2;
import com.viaversion.viaversion.rewriter.BlockRewriter;
import com.viaversion.viaversion.rewriter.RecipeRewriter;
import com.viaversion.viaversion.util.Key;
import java.util.ArrayList;
import java.util.Set;

public class BlockItemPackets1_14
extends ItemRewriter<ClientboundPackets1_14, ServerboundPackets1_13, Protocol1_13_2To1_14> {
    private EnchantmentRewriter enchantmentRewriter;

    public BlockItemPackets1_14(Protocol1_13_2To1_14 protocol) {
        super(protocol);
    }

    protected void registerPackets() {
        ((Protocol1_13_2To1_14)this.protocol).registerServerbound((ServerboundPacketType)ServerboundPackets1_13.EDIT_BOOK, wrapper -> this.handleItemToServer((Item)wrapper.passthrough(Type.ITEM1_13_2)));
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.OPEN_WINDOW, wrapper -> {
            JsonObject object;
            int windowId = (Integer)wrapper.read((Type)Type.VAR_INT);
            wrapper.write((Type)Type.UNSIGNED_BYTE, (Object)((short)windowId));
            int type = (Integer)wrapper.read((Type)Type.VAR_INT);
            String stringType = null;
            String containerTitle = null;
            int slotSize = 0;
            if (type < 6) {
                if (type == 2) {
                    containerTitle = "Barrel";
                }
                stringType = "minecraft:container";
                slotSize = (type + 1) * 9;
            } else {
                switch (type) {
                    case 11: {
                        stringType = "minecraft:crafting_table";
                        break;
                    }
                    case 9: 
                    case 13: 
                    case 14: 
                    case 20: {
                        if (type == 9) {
                            containerTitle = "Blast Furnace";
                        } else if (type == 20) {
                            containerTitle = "Smoker";
                        } else if (type == 14) {
                            containerTitle = "Grindstone";
                        }
                        stringType = "minecraft:furnace";
                        slotSize = 3;
                        break;
                    }
                    case 6: {
                        stringType = "minecraft:dropper";
                        slotSize = 9;
                        break;
                    }
                    case 12: {
                        stringType = "minecraft:enchanting_table";
                        break;
                    }
                    case 10: {
                        stringType = "minecraft:brewing_stand";
                        slotSize = 5;
                        break;
                    }
                    case 18: {
                        stringType = "minecraft:villager";
                        break;
                    }
                    case 8: {
                        stringType = "minecraft:beacon";
                        slotSize = 1;
                        break;
                    }
                    case 7: 
                    case 21: {
                        if (type == 21) {
                            containerTitle = "Cartography Table";
                        }
                        stringType = "minecraft:anvil";
                        break;
                    }
                    case 15: {
                        stringType = "minecraft:hopper";
                        slotSize = 5;
                        break;
                    }
                    case 19: {
                        stringType = "minecraft:shulker_box";
                        slotSize = 27;
                    }
                }
            }
            if (stringType == null) {
                ViaBackwards.getPlatform().getLogger().warning("Can't open inventory for 1.13 player! Type: " + type);
                wrapper.cancel();
                return;
            }
            wrapper.write(Type.STRING, (Object)stringType);
            JsonElement title = (JsonElement)wrapper.read(Type.COMPONENT);
            if (containerTitle != null && title.isJsonObject() && (object = title.getAsJsonObject()).has("translate") && (type != 2 || object.getAsJsonPrimitive("translate").getAsString().equals("container.barrel"))) {
                title = ChatRewriter.legacyTextToJson((String)containerTitle);
            }
            wrapper.write(Type.COMPONENT, (Object)title);
            wrapper.write((Type)Type.UNSIGNED_BYTE, (Object)((short)slotSize));
        });
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.OPEN_HORSE_WINDOW, (ClientboundPacketType)ClientboundPackets1_13.OPEN_WINDOW, wrapper -> {
            wrapper.passthrough((Type)Type.UNSIGNED_BYTE);
            wrapper.write(Type.STRING, (Object)"EntityHorse");
            JsonObject object = new JsonObject();
            object.addProperty("translate", "minecraft.horse");
            wrapper.write(Type.COMPONENT, (Object)object);
            wrapper.write((Type)Type.UNSIGNED_BYTE, (Object)((Integer)wrapper.read((Type)Type.VAR_INT)).shortValue());
            wrapper.passthrough((Type)Type.INT);
        });
        BlockRewriter blockRewriter = BlockRewriter.legacy((Protocol)this.protocol);
        this.registerSetCooldown((ClientboundPacketType)ClientboundPackets1_14.COOLDOWN);
        this.registerWindowItems((ClientboundPacketType)ClientboundPackets1_14.WINDOW_ITEMS, Type.ITEM1_13_2_SHORT_ARRAY);
        this.registerSetSlot((ClientboundPacketType)ClientboundPackets1_14.SET_SLOT, Type.ITEM1_13_2);
        this.registerAdvancements(ClientboundPackets1_14.ADVANCEMENTS, (Type<Item>)Type.ITEM1_13_2);
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.TRADE_LIST, (ClientboundPacketType)ClientboundPackets1_13.PLUGIN_MESSAGE, wrapper -> {
            wrapper.write(Type.STRING, (Object)"minecraft:trader_list");
            int windowId = (Integer)wrapper.read((Type)Type.VAR_INT);
            wrapper.write((Type)Type.INT, (Object)windowId);
            int size = ((Short)wrapper.passthrough((Type)Type.UNSIGNED_BYTE)).shortValue();
            for (int i = 0; i < size; ++i) {
                Item input = (Item)wrapper.read(Type.ITEM1_13_2);
                input = this.handleItemToClient(input);
                wrapper.write(Type.ITEM1_13_2, (Object)input);
                Item output = (Item)wrapper.read(Type.ITEM1_13_2);
                output = this.handleItemToClient(output);
                wrapper.write(Type.ITEM1_13_2, (Object)output);
                boolean secondItem = (Boolean)wrapper.passthrough((Type)Type.BOOLEAN);
                if (secondItem) {
                    Item second = (Item)wrapper.read(Type.ITEM1_13_2);
                    second = this.handleItemToClient(second);
                    wrapper.write(Type.ITEM1_13_2, (Object)second);
                }
                wrapper.passthrough((Type)Type.BOOLEAN);
                wrapper.passthrough((Type)Type.INT);
                wrapper.passthrough((Type)Type.INT);
                wrapper.read((Type)Type.INT);
                wrapper.read((Type)Type.INT);
                wrapper.read((Type)Type.FLOAT);
            }
            wrapper.read((Type)Type.VAR_INT);
            wrapper.read((Type)Type.VAR_INT);
            wrapper.read((Type)Type.BOOLEAN);
        });
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.OPEN_BOOK, (ClientboundPacketType)ClientboundPackets1_13.PLUGIN_MESSAGE, wrapper -> {
            wrapper.write(Type.STRING, (Object)"minecraft:book_open");
            wrapper.passthrough((Type)Type.VAR_INT);
        });
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.ENTITY_EQUIPMENT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.VAR_INT);
                this.map(Type.ITEM1_13_2);
                this.handler(BlockItemPackets1_14.this.itemToClientHandler(Type.ITEM1_13_2));
                this.handler(wrapper -> {
                    int entityId = (Integer)wrapper.get((Type)Type.VAR_INT, 0);
                    EntityType entityType = wrapper.user().getEntityTracker(Protocol1_13_2To1_14.class).entityType(entityId);
                    if (entityType == null) {
                        return;
                    }
                    if (entityType.isOrHasParent((EntityType)EntityTypes1_14.ABSTRACT_HORSE)) {
                        int armorType;
                        wrapper.setPacketType((PacketType)ClientboundPackets1_13.ENTITY_METADATA);
                        wrapper.resetReader();
                        wrapper.passthrough((Type)Type.VAR_INT);
                        wrapper.read((Type)Type.VAR_INT);
                        Item item = (Item)wrapper.read(Type.ITEM1_13_2);
                        int n = armorType = item == null || item.identifier() == 0 ? 0 : item.identifier() - 726;
                        if (armorType < 0 || armorType > 3) {
                            wrapper.cancel();
                            return;
                        }
                        ArrayList<Metadata> metadataList = new ArrayList<Metadata>();
                        metadataList.add(new Metadata(16, Types1_13_2.META_TYPES.varIntType, (Object)armorType));
                        wrapper.write(Types1_13.METADATA_LIST, metadataList);
                    }
                });
            }
        });
        RecipeRewriter recipeHandler = new RecipeRewriter(this.protocol);
        ImmutableSet removedTypes = ImmutableSet.of((Object)"crafting_special_suspiciousstew", (Object)"blasting", (Object)"smoking", (Object)"campfire_cooking", (Object)"stonecutting");
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.DECLARE_RECIPES, arg_0 -> BlockItemPackets1_14.lambda$registerPackets$5((Set)removedTypes, recipeHandler, arg_0));
        this.registerClickWindow((ServerboundPacketType)ServerboundPackets1_13.CLICK_WINDOW, Type.ITEM1_13_2);
        this.registerCreativeInvAction((ServerboundPacketType)ServerboundPackets1_13.CREATIVE_INVENTORY_ACTION, Type.ITEM1_13_2);
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.BLOCK_BREAK_ANIMATION, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map(Type.POSITION1_14, Type.POSITION1_8);
                this.map((Type)Type.BYTE);
            }
        });
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.BLOCK_ENTITY_DATA, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.POSITION1_14, Type.POSITION1_8);
            }
        });
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.BLOCK_ACTION, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.POSITION1_14, Type.POSITION1_8);
                this.map((Type)Type.UNSIGNED_BYTE);
                this.map((Type)Type.UNSIGNED_BYTE);
                this.map((Type)Type.VAR_INT);
                this.handler(wrapper -> {
                    int mappedId = ((Protocol1_13_2To1_14)BlockItemPackets1_14.this.protocol).getMappingData().getNewBlockId((Integer)wrapper.get((Type)Type.VAR_INT, 0));
                    if (mappedId == -1) {
                        wrapper.cancel();
                        return;
                    }
                    wrapper.set((Type)Type.VAR_INT, 0, (Object)mappedId);
                });
            }
        });
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.BLOCK_CHANGE, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.POSITION1_14, Type.POSITION1_8);
                this.map((Type)Type.VAR_INT);
                this.handler(wrapper -> {
                    int id = (Integer)wrapper.get((Type)Type.VAR_INT, 0);
                    wrapper.set((Type)Type.VAR_INT, 0, (Object)((Protocol1_13_2To1_14)BlockItemPackets1_14.this.protocol).getMappingData().getNewBlockStateId(id));
                });
            }
        });
        blockRewriter.registerMultiBlockChange((ClientboundPacketType)ClientboundPackets1_14.MULTI_BLOCK_CHANGE);
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.EXPLOSION, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.FLOAT);
                this.map((Type)Type.FLOAT);
                this.map((Type)Type.FLOAT);
                this.map((Type)Type.FLOAT);
                this.handler(wrapper -> {
                    for (int i = 0; i < 3; ++i) {
                        float coord = ((Float)wrapper.get((Type)Type.FLOAT, i)).floatValue();
                        if (!(coord < 0.0f)) continue;
                        coord = (float)Math.floor(coord);
                        wrapper.set((Type)Type.FLOAT, i, (Object)Float.valueOf(coord));
                    }
                });
            }
        });
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.CHUNK_DATA, wrapper -> {
            ClientWorld clientWorld = (ClientWorld)wrapper.user().get(ClientWorld.class);
            Chunk chunk = (Chunk)wrapper.read(ChunkType1_14.TYPE);
            wrapper.write((Type)ChunkType1_13.forEnvironment((Environment)clientWorld.getEnvironment()), (Object)chunk);
            ChunkLightStorage.ChunkLight chunkLight = ((ChunkLightStorage)wrapper.user().get(ChunkLightStorage.class)).getStoredLight(chunk.getX(), chunk.getZ());
            for (int i = 0; i < chunk.getSections().length; ++i) {
                ChunkSection section = chunk.getSections()[i];
                if (section == null) continue;
                ChunkSectionLightImpl sectionLight = new ChunkSectionLightImpl();
                section.setLight((ChunkSectionLight)sectionLight);
                if (chunkLight == null) {
                    sectionLight.setBlockLight(ChunkLightStorage.FULL_LIGHT);
                    if (clientWorld.getEnvironment() == Environment.NORMAL) {
                        sectionLight.setSkyLight(ChunkLightStorage.FULL_LIGHT);
                    }
                } else {
                    byte[] blockLight = chunkLight.blockLight()[i];
                    sectionLight.setBlockLight(blockLight != null ? blockLight : ChunkLightStorage.FULL_LIGHT);
                    if (clientWorld.getEnvironment() == Environment.NORMAL) {
                        byte[] skyLight = chunkLight.skyLight()[i];
                        sectionLight.setSkyLight(skyLight != null ? skyLight : ChunkLightStorage.FULL_LIGHT);
                    }
                }
                DataPalette palette = section.palette(PaletteType.BLOCKS);
                if (Via.getConfig().isNonFullBlockLightFix() && section.getNonAirBlocksCount() != 0 && sectionLight.hasBlockLight()) {
                    for (int x = 0; x < 16; ++x) {
                        for (int y = 0; y < 16; ++y) {
                            for (int z = 0; z < 16; ++z) {
                                int id = palette.idAt(x, y, z);
                                if (!Protocol1_14To1_13_2.MAPPINGS.getNonFullBlocks().contains(id)) continue;
                                sectionLight.getBlockLightNibbleArray().set(x, y, z, 0);
                            }
                        }
                    }
                }
                for (int j = 0; j < palette.size(); ++j) {
                    int mappedBlockStateId = ((Protocol1_13_2To1_14)this.protocol).getMappingData().getNewBlockStateId(palette.idByIndex(j));
                    palette.setIdByIndex(j, mappedBlockStateId);
                }
            }
        });
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.UNLOAD_CHUNK, wrapper -> {
            int x = (Integer)wrapper.passthrough((Type)Type.INT);
            int z = (Integer)wrapper.passthrough((Type)Type.INT);
            ((ChunkLightStorage)wrapper.user().get(ChunkLightStorage.class)).unloadChunk(x, z);
        });
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.EFFECT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.INT);
                this.map(Type.POSITION1_14, Type.POSITION1_8);
                this.map((Type)Type.INT);
                this.handler(wrapper -> {
                    int id = (Integer)wrapper.get((Type)Type.INT, 0);
                    int data = (Integer)wrapper.get((Type)Type.INT, 1);
                    if (id == 1010) {
                        wrapper.set((Type)Type.INT, 1, (Object)((Protocol1_13_2To1_14)BlockItemPackets1_14.this.protocol).getMappingData().getNewItemId(data));
                    } else if (id == 2001) {
                        wrapper.set((Type)Type.INT, 1, (Object)((Protocol1_13_2To1_14)BlockItemPackets1_14.this.protocol).getMappingData().getNewBlockStateId(data));
                    }
                });
            }
        });
        this.registerSpawnParticle((ClientboundPacketType)ClientboundPackets1_14.SPAWN_PARTICLE, Type.ITEM1_13_2, (Type)Type.FLOAT);
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.MAP_DATA, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BOOLEAN);
                this.read((Type)Type.BOOLEAN);
            }
        });
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.SPAWN_POSITION, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.POSITION1_14, Type.POSITION1_8);
            }
        });
    }

    protected void registerRewrites() {
        this.enchantmentRewriter = new EnchantmentRewriter(this, false);
        this.enchantmentRewriter.registerEnchantment("minecraft:multishot", "\u00a77Multishot");
        this.enchantmentRewriter.registerEnchantment("minecraft:quick_charge", "\u00a77Quick Charge");
        this.enchantmentRewriter.registerEnchantment("minecraft:piercing", "\u00a77Piercing");
    }

    @Override
    public Item handleItemToClient(Item item) {
        ListTag lore;
        CompoundTag display;
        if (item == null) {
            return null;
        }
        super.handleItemToClient(item);
        CompoundTag tag = item.tag();
        if (tag != null && (display = (CompoundTag)tag.get("display")) != null && (lore = (ListTag)display.get("Lore")) != null) {
            this.saveListTag(display, lore, "Lore");
            for (Tag loreEntry : lore) {
                StringTag loreEntryTag;
                String value;
                if (!(loreEntry instanceof StringTag) || (value = (loreEntryTag = (StringTag)loreEntry).getValue()) == null || value.isEmpty()) continue;
                loreEntryTag.setValue(ChatRewriter.jsonToLegacyText((String)value));
            }
        }
        this.enchantmentRewriter.handleToClient(item);
        return item;
    }

    @Override
    public Item handleItemToServer(Item item) {
        ListTag lore;
        CompoundTag display;
        if (item == null) {
            return null;
        }
        CompoundTag tag = item.tag();
        if (tag != null && (display = (CompoundTag)tag.get("display")) != null && (lore = (ListTag)display.get("Lore")) != null && !this.hasBackupTag(display, "Lore")) {
            for (Tag loreEntry : lore) {
                if (!(loreEntry instanceof StringTag)) continue;
                StringTag loreEntryTag = (StringTag)loreEntry;
                loreEntryTag.setValue(ChatRewriter.legacyTextToJsonString((String)loreEntryTag.getValue()));
            }
        }
        this.enchantmentRewriter.handleToServer(item);
        super.handleItemToServer(item);
        return item;
    }

    private static /* synthetic */ void lambda$registerPackets$5(Set removedTypes, RecipeRewriter recipeHandler, PacketWrapper wrapper) throws Exception {
        int size = (Integer)wrapper.passthrough((Type)Type.VAR_INT);
        int deleted = 0;
        for (int i = 0; i < size; ++i) {
            String type = (String)wrapper.read(Type.STRING);
            String id = (String)wrapper.read(Type.STRING);
            if (removedTypes.contains(type = Key.stripMinecraftNamespace((String)type))) {
                switch (type) {
                    case "blasting": 
                    case "smoking": 
                    case "campfire_cooking": {
                        wrapper.read(Type.STRING);
                        wrapper.read(Type.ITEM1_13_2_ARRAY);
                        wrapper.read(Type.ITEM1_13_2);
                        wrapper.read((Type)Type.FLOAT);
                        wrapper.read((Type)Type.VAR_INT);
                        break;
                    }
                    case "stonecutting": {
                        wrapper.read(Type.STRING);
                        wrapper.read(Type.ITEM1_13_2_ARRAY);
                        wrapper.read(Type.ITEM1_13_2);
                    }
                }
                ++deleted;
                continue;
            }
            wrapper.write(Type.STRING, (Object)id);
            wrapper.write(Type.STRING, (Object)type);
            recipeHandler.handleRecipeType(wrapper, type);
        }
        wrapper.set((Type)Type.VAR_INT, 0, (Object)(size - deleted));
    }
}

