/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.protocol.protocol1_18_2to1_19;

import com.google.common.primitives.Longs;
import com.viaversion.viabackwards.ViaBackwards;
import com.viaversion.viabackwards.api.BackwardsProtocol;
import com.viaversion.viabackwards.api.rewriters.SoundRewriter;
import com.viaversion.viabackwards.api.rewriters.TranslatableRewriter;
import com.viaversion.viabackwards.protocol.protocol1_18_2to1_19.data.BackwardsMappings;
import com.viaversion.viabackwards.protocol.protocol1_18_2to1_19.data.CommandRewriter1_19;
import com.viaversion.viabackwards.protocol.protocol1_18_2to1_19.packets.BlockItemPackets1_19;
import com.viaversion.viabackwards.protocol.protocol1_18_2to1_19.packets.EntityPackets1_19;
import com.viaversion.viabackwards.protocol.protocol1_18_2to1_19.storage.DimensionRegistryStorage;
import com.viaversion.viabackwards.protocol.protocol1_18_2to1_19.storage.NonceStorage;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.data.entity.EntityTracker;
import com.viaversion.viaversion.api.minecraft.RegistryType;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.api.minecraft.entities.EntityTypes1_19;
import com.viaversion.viaversion.api.minecraft.signature.SignableCommandArgumentsProvider;
import com.viaversion.viaversion.api.minecraft.signature.model.DecoratableMessage;
import com.viaversion.viaversion.api.minecraft.signature.model.MessageMetadata;
import com.viaversion.viaversion.api.minecraft.signature.storage.ChatSession1_19_0;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.data.entity.EntityTrackerBase;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.protocols.base.ClientboundLoginPackets;
import com.viaversion.viaversion.protocols.base.ServerboundLoginPackets;
import com.viaversion.viaversion.protocols.protocol1_17to1_16_4.ServerboundPackets1_17;
import com.viaversion.viaversion.protocols.protocol1_18to1_17_1.ClientboundPackets1_18;
import com.viaversion.viaversion.protocols.protocol1_19_1to1_19.ChatDecorationResult;
import com.viaversion.viaversion.protocols.protocol1_19_1to1_19.Protocol1_19_1To1_19;
import com.viaversion.viaversion.protocols.protocol1_19to1_18_2.ClientboundPackets1_19;
import com.viaversion.viaversion.protocols.protocol1_19to1_18_2.ServerboundPackets1_19;
import com.viaversion.viaversion.rewriter.ComponentRewriter;
import com.viaversion.viaversion.rewriter.StatisticsRewriter;
import com.viaversion.viaversion.rewriter.TagRewriter;
import com.viaversion.viaversion.util.Pair;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;

public final class Protocol1_18_2To1_19
extends BackwardsProtocol<ClientboundPackets1_19, ClientboundPackets1_18, ServerboundPackets1_19, ServerboundPackets1_17> {
    public static final BackwardsMappings MAPPINGS = new BackwardsMappings();
    private static final UUID ZERO_UUID = new UUID(0L, 0L);
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final EntityPackets1_19 entityRewriter = new EntityPackets1_19(this);
    private final BlockItemPackets1_19 blockItemPackets = new BlockItemPackets1_19(this);
    private final TranslatableRewriter<ClientboundPackets1_19> translatableRewriter = new TranslatableRewriter<ClientboundPackets1_19>(this, ComponentRewriter.ReadType.JSON);

    public Protocol1_18_2To1_19() {
        super(ClientboundPackets1_19.class, ClientboundPackets1_18.class, ServerboundPackets1_19.class, ServerboundPackets1_17.class);
    }

    @Override
    protected void registerPackets() {
        super.registerPackets();
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_19.ACTIONBAR);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_19.TITLE_TEXT);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_19.TITLE_SUBTITLE);
        this.translatableRewriter.registerBossBar((ClientboundPacketType)ClientboundPackets1_19.BOSSBAR);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_19.DISCONNECT);
        this.translatableRewriter.registerTabList((ClientboundPacketType)ClientboundPackets1_19.TAB_LIST);
        this.translatableRewriter.registerOpenWindow((ClientboundPacketType)ClientboundPackets1_19.OPEN_WINDOW);
        this.translatableRewriter.registerCombatKill((ClientboundPacketType)ClientboundPackets1_19.COMBAT_KILL);
        this.translatableRewriter.registerPing();
        final SoundRewriter<ClientboundPackets1_19> soundRewriter = new SoundRewriter<ClientboundPackets1_19>(this);
        soundRewriter.registerStopSound(ClientboundPackets1_19.STOP_SOUND);
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_19.SOUND, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.INT);
                this.map((Type)Type.INT);
                this.map((Type)Type.INT);
                this.map((Type)Type.FLOAT);
                this.map((Type)Type.FLOAT);
                this.read((Type)Type.LONG);
                this.handler(soundRewriter.getSoundHandler());
            }
        });
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_19.ENTITY_SOUND, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.FLOAT);
                this.map((Type)Type.FLOAT);
                this.read((Type)Type.LONG);
                this.handler(soundRewriter.getSoundHandler());
            }
        });
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_19.NAMED_SOUND, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.STRING);
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.INT);
                this.map((Type)Type.INT);
                this.map((Type)Type.INT);
                this.map((Type)Type.FLOAT);
                this.map((Type)Type.FLOAT);
                this.read((Type)Type.LONG);
                this.handler(soundRewriter.getNamedSoundHandler());
            }
        });
        TagRewriter tagRewriter = new TagRewriter((Protocol)this);
        tagRewriter.removeTags("minecraft:banner_pattern");
        tagRewriter.removeTags("minecraft:instrument");
        tagRewriter.removeTags("minecraft:cat_variant");
        tagRewriter.removeTags("minecraft:painting_variant");
        tagRewriter.addEmptyTag(RegistryType.BLOCK, "minecraft:polar_bears_spawnable_on_in_frozen_ocean");
        tagRewriter.renameTag(RegistryType.BLOCK, "minecraft:wool_carpets", "minecraft:carpets");
        tagRewriter.renameTag(RegistryType.ITEM, "minecraft:wool_carpets", "minecraft:carpets");
        tagRewriter.addEmptyTag(RegistryType.ITEM, "minecraft:occludes_vibration_signals");
        tagRewriter.registerGeneric((ClientboundPacketType)ClientboundPackets1_19.TAGS);
        new StatisticsRewriter((Protocol)this).register((ClientboundPacketType)ClientboundPackets1_19.STATISTICS);
        CommandRewriter1_19 commandRewriter = new CommandRewriter1_19(this);
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_19.DECLARE_COMMANDS, wrapper -> {
            int size = (Integer)wrapper.passthrough((Type)Type.VAR_INT);
            for (int i = 0; i < size; ++i) {
                int nodeType;
                byte flags = (Byte)wrapper.passthrough((Type)Type.BYTE);
                wrapper.passthrough(Type.VAR_INT_ARRAY_PRIMITIVE);
                if ((flags & 8) != 0) {
                    wrapper.passthrough((Type)Type.VAR_INT);
                }
                if ((nodeType = flags & 3) == 1 || nodeType == 2) {
                    wrapper.passthrough(Type.STRING);
                }
                if (nodeType != 2) continue;
                int argumentTypeId = (Integer)wrapper.read((Type)Type.VAR_INT);
                String argumentType = MAPPINGS.getArgumentTypeMappings().identifier(argumentTypeId);
                if (argumentType == null) {
                    ViaBackwards.getPlatform().getLogger().warning("Unknown command argument type id: " + argumentTypeId);
                    argumentType = "minecraft:no";
                }
                wrapper.write(Type.STRING, (Object)commandRewriter.handleArgumentType(argumentType));
                commandRewriter.handleArgument(wrapper, argumentType);
                if ((flags & 0x10) == 0) continue;
                wrapper.passthrough(Type.STRING);
            }
            wrapper.passthrough((Type)Type.VAR_INT);
        });
        this.cancelClientbound((ClientboundPacketType)ClientboundPackets1_19.SERVER_DATA);
        this.cancelClientbound((ClientboundPacketType)ClientboundPackets1_19.CHAT_PREVIEW);
        this.cancelClientbound((ClientboundPacketType)ClientboundPackets1_19.SET_DISPLAY_CHAT_PREVIEW);
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_19.PLAYER_CHAT, (ClientboundPacketType)ClientboundPackets1_18.CHAT_MESSAGE, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.handler(wrapper -> {
                    JsonElement signedContent = (JsonElement)wrapper.read(Type.COMPONENT);
                    JsonElement unsignedContent = (JsonElement)wrapper.read(Type.OPTIONAL_COMPONENT);
                    int chatTypeId = (Integer)wrapper.read((Type)Type.VAR_INT);
                    UUID sender = (UUID)wrapper.read(Type.UUID);
                    JsonElement senderName = (JsonElement)wrapper.read(Type.COMPONENT);
                    JsonElement teamName = (JsonElement)wrapper.read(Type.OPTIONAL_COMPONENT);
                    CompoundTag chatType = ((DimensionRegistryStorage)wrapper.user().get(DimensionRegistryStorage.class)).chatType(chatTypeId);
                    ChatDecorationResult decorationResult = Protocol1_19_1To1_19.decorateChatMessage((CompoundTag)chatType, (int)chatTypeId, (JsonElement)senderName, (JsonElement)teamName, (JsonElement)(unsignedContent != null ? unsignedContent : signedContent));
                    if (decorationResult == null) {
                        wrapper.cancel();
                        return;
                    }
                    Protocol1_18_2To1_19.this.translatableRewriter.processText(decorationResult.content());
                    wrapper.write(Type.COMPONENT, (Object)decorationResult.content());
                    wrapper.write((Type)Type.BYTE, (Object)(decorationResult.overlay() ? (byte)2 : (byte)1));
                    wrapper.write(Type.UUID, (Object)sender);
                });
                this.read((Type)Type.LONG);
                this.read((Type)Type.LONG);
                this.read(Type.BYTE_ARRAY_PRIMITIVE);
            }
        });
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_19.SYSTEM_CHAT, (ClientboundPacketType)ClientboundPackets1_18.CHAT_MESSAGE, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.handler(wrapper -> {
                    JsonElement content = (JsonElement)wrapper.passthrough(Type.COMPONENT);
                    Protocol1_18_2To1_19.this.translatableRewriter.processText(content);
                    int typeId = (Integer)wrapper.read((Type)Type.VAR_INT);
                    wrapper.write((Type)Type.BYTE, (Object)(typeId == 2 ? (byte)2 : (byte)0));
                });
                this.create(Type.UUID, ZERO_UUID);
            }
        });
        this.registerServerbound((ServerboundPacketType)ServerboundPackets1_17.CHAT_MESSAGE, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.STRING);
                this.handler(wrapper -> {
                    ChatSession1_19_0 chatSession = (ChatSession1_19_0)wrapper.user().get(ChatSession1_19_0.class);
                    UUID sender = wrapper.user().getProtocolInfo().getUuid();
                    Instant timestamp = Instant.now();
                    long salt = ThreadLocalRandom.current().nextLong();
                    wrapper.write((Type)Type.LONG, (Object)timestamp.toEpochMilli());
                    wrapper.write((Type)Type.LONG, (Object)(chatSession != null ? salt : 0L));
                    String message = (String)wrapper.get(Type.STRING, 0);
                    if (!message.isEmpty() && message.charAt(0) == '/') {
                        String command = message.substring(1);
                        wrapper.setPacketType((PacketType)ServerboundPackets1_19.CHAT_COMMAND);
                        wrapper.set(Type.STRING, 0, (Object)command);
                        SignableCommandArgumentsProvider argumentsProvider = (SignableCommandArgumentsProvider)Via.getManager().getProviders().get(SignableCommandArgumentsProvider.class);
                        if (chatSession != null && argumentsProvider != null) {
                            MessageMetadata metadata = new MessageMetadata(sender, timestamp, salt);
                            List arguments = argumentsProvider.getSignableArguments(command);
                            wrapper.write((Type)Type.VAR_INT, (Object)arguments.size());
                            for (Pair argument : arguments) {
                                byte[] signature = chatSession.signChatMessage(metadata, new DecoratableMessage((String)argument.value()));
                                wrapper.write(Type.STRING, (Object)((String)argument.key()));
                                wrapper.write(Type.BYTE_ARRAY_PRIMITIVE, (Object)signature);
                            }
                        } else {
                            wrapper.write((Type)Type.VAR_INT, (Object)0);
                        }
                    } else if (chatSession != null) {
                        MessageMetadata metadata = new MessageMetadata(sender, timestamp, salt);
                        DecoratableMessage decoratableMessage = new DecoratableMessage(message);
                        byte[] signature = chatSession.signChatMessage(metadata, decoratableMessage);
                        wrapper.write(Type.BYTE_ARRAY_PRIMITIVE, (Object)signature);
                    } else {
                        wrapper.write(Type.BYTE_ARRAY_PRIMITIVE, (Object)EMPTY_BYTES);
                    }
                    wrapper.write((Type)Type.BOOLEAN, (Object)false);
                });
            }
        });
        this.registerClientbound(State.LOGIN, ClientboundLoginPackets.GAME_PROFILE.getId(), ClientboundLoginPackets.GAME_PROFILE.getId(), (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.UUID);
                this.map(Type.STRING);
                this.handler(wrapper -> {
                    int properties = (Integer)wrapper.read((Type)Type.VAR_INT);
                    for (int i = 0; i < properties; ++i) {
                        wrapper.read(Type.STRING);
                        wrapper.read(Type.STRING);
                        if (!((Boolean)wrapper.read((Type)Type.BOOLEAN)).booleanValue()) continue;
                        wrapper.read(Type.STRING);
                    }
                });
            }
        });
        this.registerClientbound(State.LOGIN, ClientboundLoginPackets.HELLO.getId(), ClientboundLoginPackets.HELLO.getId(), (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.STRING);
                this.map(Type.BYTE_ARRAY_PRIMITIVE);
                this.handler(wrapper -> {
                    if (wrapper.user().has(ChatSession1_19_0.class)) {
                        wrapper.user().put((StorableObject)new NonceStorage((byte[])wrapper.passthrough(Type.BYTE_ARRAY_PRIMITIVE)));
                    }
                });
            }
        });
        this.registerServerbound(State.LOGIN, ServerboundLoginPackets.HELLO.getId(), ServerboundLoginPackets.HELLO.getId(), (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.STRING);
                this.handler(wrapper -> {
                    ChatSession1_19_0 chatSession = (ChatSession1_19_0)wrapper.user().get(ChatSession1_19_0.class);
                    wrapper.write(Type.OPTIONAL_PROFILE_KEY, (Object)(chatSession == null ? null : chatSession.getProfileKey()));
                });
            }
        });
        this.registerServerbound(State.LOGIN, ServerboundLoginPackets.ENCRYPTION_KEY.getId(), ServerboundLoginPackets.ENCRYPTION_KEY.getId(), (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.BYTE_ARRAY_PRIMITIVE);
                this.handler(wrapper -> {
                    ChatSession1_19_0 chatSession = (ChatSession1_19_0)wrapper.user().get(ChatSession1_19_0.class);
                    byte[] verifyToken = (byte[])wrapper.read(Type.BYTE_ARRAY_PRIMITIVE);
                    wrapper.write((Type)Type.BOOLEAN, (Object)(chatSession == null ? 1 : 0));
                    if (chatSession != null) {
                        long salt = ThreadLocalRandom.current().nextLong();
                        byte[] signature = chatSession.sign(signer -> {
                            signer.accept((Object)((NonceStorage)wrapper.user().remove(NonceStorage.class)).nonce());
                            signer.accept((Object)Longs.toByteArray((long)salt));
                        });
                        wrapper.write((Type)Type.LONG, (Object)salt);
                        wrapper.write(Type.BYTE_ARRAY_PRIMITIVE, (Object)signature);
                    } else {
                        wrapper.write(Type.BYTE_ARRAY_PRIMITIVE, (Object)verifyToken);
                    }
                });
            }
        });
    }

    public void init(UserConnection user) {
        user.put((StorableObject)new DimensionRegistryStorage());
        this.addEntityTracker(user, (EntityTracker)new EntityTrackerBase(user, (EntityType)EntityTypes1_19.PLAYER));
    }

    @Override
    public BackwardsMappings getMappingData() {
        return MAPPINGS;
    }

    @Override
    public TranslatableRewriter<ClientboundPackets1_19> getTranslatableRewriter() {
        return this.translatableRewriter;
    }

    public EntityPackets1_19 getEntityRewriter() {
        return this.entityRewriter;
    }

    public BlockItemPackets1_19 getItemRewriter() {
        return this.blockItemPackets;
    }
}

