/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.protocol.protocol1_20to1_20_2.rewriter;

import com.viaversion.viabackwards.api.rewriters.ItemRewriter;
import com.viaversion.viabackwards.protocol.protocol1_20to1_20_2.Protocol1_20To1_20_2;
import com.viaversion.viaversion.api.data.ParticleMappings;
import com.viaversion.viaversion.api.data.entity.EntityTracker;
import com.viaversion.viaversion.api.minecraft.blockentity.BlockEntity;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSection;
import com.viaversion.viaversion.api.minecraft.chunks.DataPalette;
import com.viaversion.viaversion.api.minecraft.chunks.PaletteType;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.minecraft.metadata.ChunkPosition;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.chunk.ChunkType1_18;
import com.viaversion.viaversion.api.type.types.chunk.ChunkType1_20_2;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.IntTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.StringTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import com.viaversion.viaversion.protocols.protocol1_19_4to1_19_3.ServerboundPackets1_19_4;
import com.viaversion.viaversion.protocols.protocol1_20_2to1_20.packet.ClientboundPackets1_20_2;
import com.viaversion.viaversion.protocols.protocol1_20_2to1_20.packet.ServerboundPackets1_20_2;
import com.viaversion.viaversion.protocols.protocol1_20_2to1_20.rewriter.RecipeRewriter1_20_2;
import com.viaversion.viaversion.protocols.protocol1_20_2to1_20.util.PotionEffects;
import com.viaversion.viaversion.rewriter.BlockRewriter;
import com.viaversion.viaversion.util.Key;
import com.viaversion.viaversion.util.MathUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class BlockItemPacketRewriter1_20_2
extends ItemRewriter<ClientboundPackets1_20_2, ServerboundPackets1_19_4, Protocol1_20To1_20_2> {
    public BlockItemPacketRewriter1_20_2(Protocol1_20To1_20_2 protocol) {
        super(protocol, (Type<Item>)Type.ITEM1_20_2, (Type<Item[]>)Type.ITEM1_20_2_ARRAY);
    }

    public void registerPackets() {
        BlockRewriter blockRewriter = BlockRewriter.for1_14((Protocol)this.protocol);
        blockRewriter.registerBlockAction((ClientboundPacketType)ClientboundPackets1_20_2.BLOCK_ACTION);
        blockRewriter.registerBlockChange((ClientboundPacketType)ClientboundPackets1_20_2.BLOCK_CHANGE);
        blockRewriter.registerVarLongMultiBlockChange1_20((ClientboundPacketType)ClientboundPackets1_20_2.MULTI_BLOCK_CHANGE);
        blockRewriter.registerEffect((ClientboundPacketType)ClientboundPackets1_20_2.EFFECT, 1010, 2001);
        ((Protocol1_20To1_20_2)this.protocol).cancelClientbound((ClientboundPacketType)ClientboundPackets1_20_2.CHUNK_BATCH_START);
        ((Protocol1_20To1_20_2)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_20_2.CHUNK_BATCH_FINISHED, null, wrapper -> {
            wrapper.cancel();
            PacketWrapper receivedPacket = wrapper.create((PacketType)ServerboundPackets1_20_2.CHUNK_BATCH_RECEIVED);
            receivedPacket.write((Type)Type.FLOAT, (Object)Float.valueOf(500.0f));
            receivedPacket.sendToServer(Protocol1_20To1_20_2.class);
        });
        ((Protocol1_20To1_20_2)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_20_2.UNLOAD_CHUNK, wrapper -> {
            ChunkPosition chunkPosition = (ChunkPosition)wrapper.read(Type.CHUNK_POSITION);
            wrapper.write((Type)Type.INT, (Object)chunkPosition.chunkX());
            wrapper.write((Type)Type.INT, (Object)chunkPosition.chunkZ());
        });
        ((Protocol1_20To1_20_2)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_20_2.MAP_DATA, wrapper -> {
            wrapper.passthrough((Type)Type.VAR_INT);
            wrapper.passthrough((Type)Type.BYTE);
            wrapper.passthrough((Type)Type.BOOLEAN);
            if (((Boolean)wrapper.passthrough((Type)Type.BOOLEAN)).booleanValue()) {
                int icons = (Integer)wrapper.passthrough((Type)Type.VAR_INT);
                for (int i = 0; i < icons; ++i) {
                    byte markerType = (Byte)wrapper.read((Type)Type.BYTE);
                    wrapper.write((Type)Type.BYTE, (Object)(markerType < 27 ? markerType : (byte)2));
                    wrapper.passthrough((Type)Type.BYTE);
                    wrapper.passthrough((Type)Type.BYTE);
                    wrapper.passthrough((Type)Type.BYTE);
                    wrapper.passthrough(Type.OPTIONAL_COMPONENT);
                }
            }
        });
        ((Protocol1_20To1_20_2)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_20_2.NBT_QUERY, wrapper -> {
            wrapper.passthrough((Type)Type.VAR_INT);
            wrapper.write(Type.NAMED_COMPOUND_TAG, (Object)((CompoundTag)wrapper.read(Type.COMPOUND_TAG)));
        });
        ((Protocol1_20To1_20_2)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_20_2.BLOCK_ENTITY_DATA, wrapper -> {
            wrapper.passthrough(Type.POSITION1_14);
            wrapper.passthrough((Type)Type.VAR_INT);
            wrapper.write(Type.NAMED_COMPOUND_TAG, (Object)this.handleBlockEntity((CompoundTag)wrapper.read(Type.COMPOUND_TAG)));
        });
        ((Protocol1_20To1_20_2)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_20_2.CHUNK_DATA, wrapper -> {
            EntityTracker tracker = ((Protocol1_20To1_20_2)this.protocol).getEntityRewriter().tracker(wrapper.user());
            ChunkType1_20_2 chunkType = new ChunkType1_20_2(tracker.currentWorldSectionHeight(), MathUtil.ceilLog2((int)((Protocol1_20To1_20_2)this.protocol).getMappingData().getBlockStateMappings().size()), MathUtil.ceilLog2((int)tracker.biomesSent()));
            Chunk chunk = (Chunk)wrapper.read((Type)chunkType);
            ChunkType1_18 newChunkType = new ChunkType1_18(tracker.currentWorldSectionHeight(), MathUtil.ceilLog2((int)((Protocol1_20To1_20_2)this.protocol).getMappingData().getBlockStateMappings().mappedSize()), MathUtil.ceilLog2((int)tracker.biomesSent()));
            wrapper.write((Type)newChunkType, (Object)chunk);
            for (ChunkSection section : chunk.getSections()) {
                DataPalette blockPalette = section.palette(PaletteType.BLOCKS);
                for (int i = 0; i < blockPalette.size(); ++i) {
                    int id = blockPalette.idByIndex(i);
                    blockPalette.setIdByIndex(i, ((Protocol1_20To1_20_2)this.protocol).getMappingData().getNewBlockStateId(id));
                }
            }
            for (BlockEntity blockEntity : chunk.blockEntities()) {
                this.handleBlockEntity(blockEntity.tag());
            }
        });
        ((Protocol1_20To1_20_2)this.protocol).registerServerbound((ServerboundPacketType)ServerboundPackets1_19_4.SET_BEACON_EFFECT, wrapper -> {
            if (((Boolean)wrapper.passthrough((Type)Type.BOOLEAN)).booleanValue()) {
                wrapper.write((Type)Type.VAR_INT, (Object)((Integer)wrapper.read((Type)Type.VAR_INT) - 1));
            }
            if (((Boolean)wrapper.passthrough((Type)Type.BOOLEAN)).booleanValue()) {
                wrapper.write((Type)Type.VAR_INT, (Object)((Integer)wrapper.read((Type)Type.VAR_INT) - 1));
            }
        });
        ((Protocol1_20To1_20_2)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_20_2.WINDOW_ITEMS, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.UNSIGNED_BYTE);
                this.map((Type)Type.VAR_INT);
                this.handler(wrapper -> {
                    Item[] items;
                    for (Item item : items = (Item[])wrapper.read(Type.ITEM1_20_2_ARRAY)) {
                        BlockItemPacketRewriter1_20_2.this.handleItemToClient(item);
                    }
                    wrapper.write(Type.ITEM1_13_2_ARRAY, (Object)items);
                    wrapper.write(Type.ITEM1_13_2, (Object)BlockItemPacketRewriter1_20_2.this.handleItemToClient((Item)wrapper.read(Type.ITEM1_20_2)));
                });
            }
        });
        ((Protocol1_20To1_20_2)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_20_2.SET_SLOT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.UNSIGNED_BYTE);
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.SHORT);
                this.handler(wrapper -> wrapper.write(Type.ITEM1_13_2, (Object)BlockItemPacketRewriter1_20_2.this.handleItemToClient((Item)wrapper.read(Type.ITEM1_20_2))));
            }
        });
        ((Protocol1_20To1_20_2)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_20_2.ADVANCEMENTS, wrapper -> {
            wrapper.passthrough((Type)Type.BOOLEAN);
            int size = (Integer)wrapper.passthrough((Type)Type.VAR_INT);
            for (int i = 0; i < size; ++i) {
                wrapper.passthrough(Type.STRING);
                if (((Boolean)wrapper.passthrough((Type)Type.BOOLEAN)).booleanValue()) {
                    wrapper.passthrough(Type.STRING);
                }
                if (((Boolean)wrapper.passthrough((Type)Type.BOOLEAN)).booleanValue()) {
                    wrapper.passthrough(Type.COMPONENT);
                    wrapper.passthrough(Type.COMPONENT);
                    wrapper.write(Type.ITEM1_13_2, (Object)this.handleItemToClient((Item)wrapper.read(Type.ITEM1_20_2)));
                    wrapper.passthrough((Type)Type.VAR_INT);
                    int flags = (Integer)wrapper.passthrough((Type)Type.INT);
                    if ((flags & 1) != 0) {
                        wrapper.passthrough(Type.STRING);
                    }
                    wrapper.passthrough((Type)Type.FLOAT);
                    wrapper.passthrough((Type)Type.FLOAT);
                }
                wrapper.write(Type.STRING_ARRAY, (Object)new String[0]);
                int requirements = (Integer)wrapper.passthrough((Type)Type.VAR_INT);
                for (int array = 0; array < requirements; ++array) {
                    wrapper.passthrough(Type.STRING_ARRAY);
                }
                wrapper.passthrough((Type)Type.BOOLEAN);
            }
        });
        ((Protocol1_20To1_20_2)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_20_2.ENTITY_EQUIPMENT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.handler(wrapper -> {
                    byte slot;
                    do {
                        slot = (Byte)wrapper.passthrough((Type)Type.BYTE);
                        wrapper.write(Type.ITEM1_13_2, (Object)BlockItemPacketRewriter1_20_2.this.handleItemToClient((Item)wrapper.read(Type.ITEM1_20_2)));
                    } while ((slot & 0xFFFFFF80) != 0);
                });
            }
        });
        ((Protocol1_20To1_20_2)this.protocol).registerServerbound((ServerboundPacketType)ServerboundPackets1_19_4.CLICK_WINDOW, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.UNSIGNED_BYTE);
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.SHORT);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.VAR_INT);
                this.handler(wrapper -> {
                    int length = (Integer)wrapper.passthrough((Type)Type.VAR_INT);
                    for (int i = 0; i < length; ++i) {
                        wrapper.passthrough((Type)Type.SHORT);
                        wrapper.write(Type.ITEM1_20_2, (Object)BlockItemPacketRewriter1_20_2.this.handleItemToServer((Item)wrapper.read(Type.ITEM1_13_2)));
                    }
                    wrapper.write(Type.ITEM1_20_2, (Object)BlockItemPacketRewriter1_20_2.this.handleItemToServer((Item)wrapper.read(Type.ITEM1_13_2)));
                });
            }
        });
        ((Protocol1_20To1_20_2)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_20_2.TRADE_LIST, wrapper -> {
            wrapper.passthrough((Type)Type.VAR_INT);
            int size = (Integer)wrapper.passthrough((Type)Type.VAR_INT);
            for (int i = 0; i < size; ++i) {
                wrapper.write(Type.ITEM1_13_2, (Object)this.handleItemToClient((Item)wrapper.read(Type.ITEM1_20_2)));
                wrapper.write(Type.ITEM1_13_2, (Object)this.handleItemToClient((Item)wrapper.read(Type.ITEM1_20_2)));
                wrapper.write(Type.ITEM1_13_2, (Object)this.handleItemToClient((Item)wrapper.read(Type.ITEM1_20_2)));
                wrapper.passthrough((Type)Type.BOOLEAN);
                wrapper.passthrough((Type)Type.INT);
                wrapper.passthrough((Type)Type.INT);
                wrapper.passthrough((Type)Type.INT);
                wrapper.passthrough((Type)Type.INT);
                wrapper.passthrough((Type)Type.FLOAT);
                wrapper.passthrough((Type)Type.INT);
            }
        });
        ((Protocol1_20To1_20_2)this.protocol).registerServerbound((ServerboundPacketType)ServerboundPackets1_19_4.CREATIVE_INVENTORY_ACTION, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.SHORT);
                this.handler(wrapper -> wrapper.write(Type.ITEM1_20_2, (Object)BlockItemPacketRewriter1_20_2.this.handleItemToServer((Item)wrapper.read(Type.ITEM1_13_2))));
            }
        });
        ((Protocol1_20To1_20_2)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_20_2.SPAWN_PARTICLE, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.BOOLEAN);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.FLOAT);
                this.map((Type)Type.FLOAT);
                this.map((Type)Type.FLOAT);
                this.map((Type)Type.FLOAT);
                this.map((Type)Type.INT);
                this.handler(wrapper -> {
                    int id = (Integer)wrapper.get((Type)Type.VAR_INT, 0);
                    ParticleMappings mappings = Protocol1_20To1_20_2.MAPPINGS.getParticleMappings();
                    if (mappings.isBlockParticle(id)) {
                        int data = (Integer)wrapper.read((Type)Type.VAR_INT);
                        wrapper.write((Type)Type.VAR_INT, (Object)((Protocol1_20To1_20_2)BlockItemPacketRewriter1_20_2.this.protocol).getMappingData().getNewBlockStateId(data));
                    } else if (mappings.isItemParticle(id)) {
                        wrapper.write(Type.ITEM1_13_2, (Object)BlockItemPacketRewriter1_20_2.this.handleItemToClient((Item)wrapper.read(Type.ITEM1_20_2)));
                    }
                });
            }
        });
        new RecipeRewriter1_20_2<ClientboundPackets1_20_2>(this.protocol){

            public void handleCraftingShapeless(PacketWrapper wrapper) throws Exception {
                wrapper.passthrough(Type.STRING);
                wrapper.passthrough((Type)Type.VAR_INT);
                this.handleIngredients(wrapper);
                Item result = (Item)wrapper.read(this.itemType());
                this.rewrite(result);
                wrapper.write(Type.ITEM1_13_2, (Object)result);
            }

            public void handleSmelting(PacketWrapper wrapper) throws Exception {
                wrapper.passthrough(Type.STRING);
                wrapper.passthrough((Type)Type.VAR_INT);
                this.handleIngredient(wrapper);
                Item result = (Item)wrapper.read(this.itemType());
                this.rewrite(result);
                wrapper.write(Type.ITEM1_13_2, (Object)result);
                wrapper.passthrough((Type)Type.FLOAT);
                wrapper.passthrough((Type)Type.VAR_INT);
            }

            public void handleCraftingShaped(PacketWrapper wrapper) throws Exception {
                int ingredients = (Integer)wrapper.passthrough((Type)Type.VAR_INT) * (Integer)wrapper.passthrough((Type)Type.VAR_INT);
                wrapper.passthrough(Type.STRING);
                wrapper.passthrough((Type)Type.VAR_INT);
                for (int i = 0; i < ingredients; ++i) {
                    this.handleIngredient(wrapper);
                }
                Item result = (Item)wrapper.read(this.itemType());
                this.rewrite(result);
                wrapper.write(Type.ITEM1_13_2, (Object)result);
                wrapper.passthrough((Type)Type.BOOLEAN);
            }

            public void handleStonecutting(PacketWrapper wrapper) throws Exception {
                wrapper.passthrough(Type.STRING);
                this.handleIngredient(wrapper);
                Item result = (Item)wrapper.read(this.itemType());
                this.rewrite(result);
                wrapper.write(Type.ITEM1_13_2, (Object)result);
            }

            public void handleSmithing(PacketWrapper wrapper) throws Exception {
                this.handleIngredient(wrapper);
                this.handleIngredient(wrapper);
                Item result = (Item)wrapper.read(this.itemType());
                this.rewrite(result);
                wrapper.write(Type.ITEM1_13_2, (Object)result);
            }

            public void handleSmithingTransform(PacketWrapper wrapper) throws Exception {
                this.handleIngredient(wrapper);
                this.handleIngredient(wrapper);
                this.handleIngredient(wrapper);
                Item result = (Item)wrapper.read(this.itemType());
                this.rewrite(result);
                wrapper.write(Type.ITEM1_13_2, (Object)result);
            }

            protected void handleIngredient(PacketWrapper wrapper) throws Exception {
                Item[] items = (Item[])wrapper.read(this.itemArrayType());
                wrapper.write(Type.ITEM1_13_2_ARRAY, (Object)items);
                for (Item item : items) {
                    this.rewrite(item);
                }
            }
        }.register((ClientboundPacketType)ClientboundPackets1_20_2.DECLARE_RECIPES);
    }

    @Override
    public @Nullable Item handleItemToClient(@Nullable Item item) {
        if (item == null) {
            return null;
        }
        if (item.tag() != null) {
            com.viaversion.viaversion.protocols.protocol1_20_2to1_20.rewriter.BlockItemPacketRewriter1_20_2.to1_20_1Effects((Item)item);
        }
        return super.handleItemToClient(item);
    }

    @Override
    public @Nullable Item handleItemToServer(@Nullable Item item) {
        if (item == null) {
            return null;
        }
        if (item.tag() != null) {
            com.viaversion.viaversion.protocols.protocol1_20_2to1_20.rewriter.BlockItemPacketRewriter1_20_2.to1_20_2Effects((Item)item);
        }
        return super.handleItemToServer(item);
    }

    private @Nullable CompoundTag handleBlockEntity(@Nullable CompoundTag tag) {
        StringTag secondaryEffect;
        if (tag == null) {
            return null;
        }
        StringTag primaryEffect = (StringTag)tag.remove("primary_effect");
        if (primaryEffect != null) {
            String effectKey = Key.stripMinecraftNamespace((String)primaryEffect.getValue());
            tag.put("Primary", (Tag)new IntTag(PotionEffects.keyToId((String)effectKey)));
        }
        if ((secondaryEffect = (StringTag)tag.remove("secondary_effect")) != null) {
            String effectKey = Key.stripMinecraftNamespace((String)secondaryEffect.getValue());
            tag.put("Secondary", (Tag)new IntTag(PotionEffects.keyToId((String)effectKey)));
        }
        return tag;
    }
}

