/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;
import org.maxgamer.quickshop.QuickShop;

public class ConfigurationFixer {
    private final QuickShop plugin;
    private final FileConfiguration builtInConfig;

    public void fix() {
        if (!this.plugin.getConfig().getBoolean("config-damaged", true)) {
            return;
        }
        this.plugin.getLogger().warning("Warning! QuickShop detected the config.yml has been damaged.");
        this.plugin.getLogger().warning("Backup - Creating backup for file config.yml...");
        try {
            Files.copy(new File(this.plugin.getDataFolder(), "config.yml").toPath(), new File(this.plugin.getDataFolder(), "config.yml." + System.currentTimeMillis()).toPath(), new CopyOption[0]);
        }
        catch (IOException ioException) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to create config.yml backup.", ioException);
        }
        this.plugin.getLogger().warning("Fix - Fixing the configuration, this may take a while...");
        for (String key : this.builtInConfig.getKeys(true)) {
            Object value = this.plugin.getConfig().get(key);
            Object buildInValue = this.builtInConfig.get(key);
            if (value != null && value.getClass().getTypeName().equals(Objects.requireNonNull(buildInValue).getClass().getTypeName())) continue;
            this.plugin.getLogger().warning("Fixing configuration use default value: " + key);
            this.plugin.getConfig().set(key, buildInValue);
        }
        this.plugin.getLogger().info("QuickShop fixed the damaged parts in configuration that we can found. We recommend you restart the server and make fix apply.");
        this.plugin.getConfig().set("config-damaged", (Object)false);
        this.plugin.saveConfig();
        this.plugin.reloadConfig();
    }

    public ConfigurationFixer(QuickShop plugin, FileConfiguration builtInConfig) {
        this.plugin = plugin;
        this.builtInConfig = builtInConfig;
    }
}

