/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.command.subcommand;

import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.command.CommandHandler;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;

public class SubCommand_CleanGhost
implements CommandHandler<CommandSender> {
    private final QuickShop plugin;

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        if (cmdArg.length < 1) {
            MsgUtil.sendDirectMessage(sender, ChatColor.YELLOW + "This command will purge all shops that: have corrupted data / are created in disallowed or unloaded worlds / trade with blacklisted items! Please make sure you have a backup of your shops data! Use /qs cleanghost to confirm the purge.");
            return;
        }
        if (!"confirm".equalsIgnoreCase(cmdArg[0])) {
            MsgUtil.sendDirectMessage(sender, ChatColor.YELLOW + "This command will purge all shops that: have corrupted data / are created in disallowed or unloaded worlds / trade with blacklisted items! Please make sure you have a backup of your shops data! Use /qs cleanghost to confirm the purge.");
            return;
        }
        MsgUtil.sendDirectMessage(sender, ChatColor.GREEN + "Starting to check for ghost shops (missing container blocks). All non-existing shops will be removed...");
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            MsgUtil.sendDirectMessage(sender, ChatColor.GREEN + "Starting async thread, please wait...");
            Util.backupDatabase();
            for (Shop shop : this.plugin.getShopLoader().getShopsInDatabase()) {
                MsgUtil.sendDirectMessage(sender, ChatColor.GRAY + "Checking the shop " + shop + " metadata and location block state...");
                if (shop == null) continue;
                if (shop.getItem().getType() == Material.AIR) {
                    MsgUtil.sendDirectMessage(sender, ChatColor.YELLOW + "Deleting shop " + shop + " because of corrupted item data.");
                    this.plugin.log("Deleting shop " + shop + " as requested by the /qs cleanghost command.");
                    Util.mainThreadRun(shop::delete);
                    continue;
                }
                if (shop.getLocation().getWorld() == null) {
                    MsgUtil.sendDirectMessage(sender, ChatColor.YELLOW + "Deleting shop " + shop + " because the its world is not loaded.");
                    Util.mainThreadRun(shop::delete);
                    this.plugin.log("Deleting shop " + shop + " as requested by the /qs cleanghost command.");
                    continue;
                }
                if (shop.getOwner() == null) {
                    MsgUtil.sendDirectMessage(sender, ChatColor.YELLOW + "Deleting shop " + shop + " because of corrupted owner data.");
                    Util.mainThreadRun(shop::delete);
                    this.plugin.log("Deleting shop " + shop + " as requested by the /qs cleanghost command.");
                    continue;
                }
                Util.mainThreadRun(() -> {
                    Util.debugLog("Posted to main server thread to continue accessing Bukkit API for shop " + shop);
                    if (!Util.canBeShop(shop.getLocation().getBlock())) {
                        MsgUtil.sendDirectMessage(sender, ChatColor.YELLOW + "Deleting shop " + shop + " because it is no longer on the target location or it is not allowed to create shops in this location.");
                        shop.delete();
                    }
                });
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
            MsgUtil.sendDirectMessage(sender, ChatColor.GREEN + "All shops have been checked!");
        });
    }

    public SubCommand_CleanGhost(QuickShop plugin) {
        this.plugin = plugin;
    }
}

