/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.command.subcommand;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.util.BlockIterator;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.command.CommandHandler;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;

public class SubCommand_Debug
implements CommandHandler<CommandSender> {
    private final QuickShop plugin;
    private final List<String> tabCompleteList = Collections.unmodifiableList(Arrays.asList("debug", "dev", "devmode", "handlerlist", "jvm", "signs"));

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        if (cmdArg.length < 1) {
            this.switchDebug(sender);
            return;
        }
        block8 : switch (cmdArg[0]) {
            case "debug": 
            case "dev": 
            case "devmode": {
                this.switchDebug(sender);
                break;
            }
            case "handlerlist": {
                if (cmdArg.length < 2) {
                    MsgUtil.sendDirectMessage(sender, "You must enter an event class");
                    break;
                }
                this.printHandlerList(sender, cmdArg[1]);
                break;
            }
            case "jvm": {
                RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
                List<String> arguments = runtimeMxBean.getInputArguments();
                MsgUtil.sendDirectMessage(sender, ChatColor.GOLD + "Arguments: " + ChatColor.AQUA + Util.list2String(arguments));
                MsgUtil.sendDirectMessage(sender, ChatColor.GOLD + "Name: " + ChatColor.AQUA + runtimeMxBean.getName());
                MsgUtil.sendDirectMessage(sender, ChatColor.GOLD + "VM Name: " + ChatColor.AQUA + runtimeMxBean.getVmName());
                MsgUtil.sendDirectMessage(sender, ChatColor.GOLD + "Uptime: " + ChatColor.AQUA + runtimeMxBean.getUptime());
                MsgUtil.sendDirectMessage(sender, ChatColor.GOLD + "JVM Ver: " + ChatColor.AQUA + runtimeMxBean.getVmVersion());
                Map<String, String> sys = runtimeMxBean.getSystemProperties();
                ArrayList<String> sysData = new ArrayList<String>();
                sys.keySet().forEach(key -> sysData.add(key + "=" + (String)sys.get(key)));
                MsgUtil.sendDirectMessage(sender, ChatColor.GOLD + "Sys Pro: " + ChatColor.AQUA + Util.list2String(sysData));
                break;
            }
            case "signs": {
                BlockIterator bIt = new BlockIterator((LivingEntity)sender, 10);
                if (!bIt.hasNext()) {
                    MsgUtil.sendMessage(sender, "not-looking-at-shop", new String[0]);
                    return;
                }
                while (bIt.hasNext()) {
                    Block b = bIt.next();
                    Shop shop = this.plugin.getShopManager().getShop(b.getLocation());
                    if (shop == null) continue;
                    shop.getSigns().forEach(sign -> MsgUtil.sendDirectMessage(sender, ChatColor.GREEN + "Sign located at: " + sign.getLocation()));
                    break block8;
                }
                break;
            }
            default: {
                MsgUtil.sendDirectMessage(sender, "Error! No correct arguments were entered!.");
            }
        }
    }

    @Override
    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        return this.tabCompleteList;
    }

    public void switchDebug(@NotNull CommandSender sender) {
        boolean debug = this.plugin.getConfig().getBoolean("dev-mode");
        if (debug) {
            this.plugin.getConfig().set("dev-mode", (Object)false);
            this.plugin.saveConfig();
            this.plugin.reload();
            MsgUtil.sendMessage(sender, "command.now-nolonger-debuging", new String[0]);
            return;
        }
        this.plugin.getConfig().set("dev-mode", (Object)true);
        this.plugin.saveConfig();
        this.plugin.reload();
        MsgUtil.sendMessage(sender, "command.now-debuging", new String[0]);
    }

    public void printHandlerList(@NotNull CommandSender sender, String event) {
        try {
            Class<?> clazz = Class.forName(event);
            Method method = clazz.getMethod("getHandlerList", new Class[0]);
            Object[] obj = new Object[]{};
            HandlerList list = (HandlerList)method.invoke(null, obj);
            for (RegisteredListener listener1 : list.getRegisteredListeners()) {
                MsgUtil.sendDirectMessage(sender, ChatColor.AQUA + listener1.getPlugin().getName() + ChatColor.YELLOW + " # " + ChatColor.GREEN + listener1.getListener().getClass().getCanonicalName());
            }
        }
        catch (Exception th) {
            MsgUtil.sendDirectMessage(sender, "ERR " + th.getMessage());
            this.plugin.getLogger().log(Level.WARNING, "An error has occurred while getting the HandlerList", th);
        }
    }

    public SubCommand_Debug(QuickShop plugin) {
        this.plugin = plugin;
    }
}

