/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.command.subcommand;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.command.CommandContainer;
import org.maxgamer.quickshop.command.CommandHandler;
import org.maxgamer.quickshop.util.MsgUtil;

public class SubCommand_Help
implements CommandHandler<CommandSender> {
    private final QuickShop plugin;

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        this.sendHelp(sender, commandLabel);
    }

    private void sendHelp(@NotNull CommandSender s, @NotNull String commandLabel) {
        MsgUtil.sendMessage(s, "command.description.title", new String[0]);
        block0: for (CommandContainer container : this.plugin.getCommandManager().getCmds()) {
            List<String> requirePermissions = container.getPermissions();
            if (container.isHidden() || requirePermissions == null || requirePermissions.isEmpty()) continue;
            for (String requirePermission : requirePermissions) {
                if (requirePermission == null || QuickShop.getPermissionManager().hasPermission(s, requirePermission)) continue;
                continue block0;
            }
            String commandDesc = MsgUtil.getMessage("command.description." + container.getPrefix(), s, new String[0]);
            if (container.getDescription() != null && (commandDesc = container.getDescription()) == null) {
                commandDesc = "Error: Subcommand " + container.getPrefix() + " # " + container.getClass().getCanonicalName() + " doesn't register the correct help description.";
            }
            if (!container.isDisabled()) {
                MsgUtil.sendDirectMessage(s, ChatColor.GREEN + "/" + commandLabel + " " + container.getPrefix() + ChatColor.YELLOW + " - " + commandDesc);
                continue;
            }
            if (!QuickShop.getPermissionManager().hasPermission(s, "quickshop.showdisabled")) continue;
            MsgUtil.sendDirectMessage(s, ChatColor.RED + "/" + commandLabel + " " + container.getPrefix() + ChatColor.GRAY + " - " + MsgUtil.getMessage("command.disabled", s, ChatColor.GRAY + container.getDisableText(s)));
        }
    }

    public SubCommand_Help(QuickShop plugin) {
        this.plugin = plugin;
    }
}

