/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.command.subcommand;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.BlockIterator;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.command.CommandHandler;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;

public class SubCommand_Item
implements CommandHandler<Player> {
    private final QuickShop plugin;

    @Override
    public void onCommand(@NotNull Player sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        BlockIterator bIt = new BlockIterator((LivingEntity)sender, 10);
        if (!bIt.hasNext()) {
            MsgUtil.sendMessage((CommandSender)sender, "not-looking-at-shop", new String[0]);
            return;
        }
        while (bIt.hasNext()) {
            Block b = bIt.next();
            Shop shop = this.plugin.getShopManager().getShop(b.getLocation());
            if (shop == null) continue;
            if (!shop.getModerator().isModerator(sender.getUniqueId()) && !QuickShop.getPermissionManager().hasPermission((CommandSender)sender, "quickshop.other.item")) {
                MsgUtil.sendMessage((CommandSender)sender, "not-managed-shop", new String[0]);
                return;
            }
            ItemStack itemStack = sender.getInventory().getItemInMainHand().clone();
            if (itemStack.getType() == Material.AIR) {
                MsgUtil.sendMessage((CommandSender)sender, "command.no-trade-item", new String[0]);
                return;
            }
            if (Util.isBlacklisted(itemStack) && !QuickShop.getPermissionManager().hasPermission((CommandSender)sender, "quickshop.bypass." + itemStack.getType().name())) {
                MsgUtil.sendMessage((CommandSender)sender, "blacklisted-item", new String[0]);
                return;
            }
            if (!this.plugin.isAllowStack() && !QuickShop.getPermissionManager().hasPermission((CommandSender)sender, "quickshop.create.stacks")) {
                itemStack.setAmount(1);
            }
            shop.setItem(itemStack);
            this.plugin.getQuickChat().send((CommandSender)sender, this.plugin.getQuickChat().getItemHologramChat(shop, shop.getItem(), sender, MsgUtil.getMessage("command.trade-item-now", (CommandSender)sender, Integer.toString(shop.getItem().getAmount()), Util.getItemStackName(shop.getItem()))));
            return;
        }
        MsgUtil.sendMessage((CommandSender)sender, "not-looking-at-shop", new String[0]);
    }

    public SubCommand_Item(QuickShop plugin) {
        this.plugin = plugin;
    }
}

