/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.command.subcommand;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.BlockIterator;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.command.CommandHandler;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;

public class SubCommand_Staff
implements CommandHandler<Player> {
    private final QuickShop plugin;
    private final List<String> tabCompleteList = Collections.unmodifiableList(Arrays.asList("add", "del", "list", "clear"));

    @Override
    public void onCommand(@NotNull Player sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        BlockIterator bIt = new BlockIterator((LivingEntity)sender, 10);
        if (!bIt.hasNext()) {
            MsgUtil.sendMessage((CommandSender)sender, "not-looking-at-shop", new String[0]);
            return;
        }
        while (bIt.hasNext()) {
            Block b = bIt.next();
            Shop shop = this.plugin.getShopManager().getShop(b.getLocation());
            if (shop == null || !shop.getModerator().isModerator(sender.getUniqueId())) continue;
            switch (cmdArg.length) {
                case 1: {
                    switch (cmdArg[0]) {
                        case "clear": {
                            shop.clearStaffs();
                            MsgUtil.sendMessage((CommandSender)sender, "shop-staff-cleared", new String[0]);
                            return;
                        }
                        case "list": {
                            List<UUID> staffs = shop.getStaffs();
                            if (staffs.isEmpty()) {
                                MsgUtil.sendDirectMessage((CommandSender)sender, ChatColor.GREEN + MsgUtil.getMessage("tableformat.left_begin", (CommandSender)sender, new String[0]) + "Empty");
                                return;
                            }
                            for (UUID uuid : staffs) {
                                MsgUtil.sendDirectMessage((CommandSender)sender, ChatColor.GREEN + MsgUtil.getMessage("tableformat.left_begin", (CommandSender)sender, new String[0]) + Bukkit.getOfflinePlayer((UUID)uuid).getName());
                            }
                            return;
                        }
                    }
                    MsgUtil.sendMessage((CommandSender)sender, "command.wrong-args", new String[0]);
                    return;
                }
                case 2: {
                    OfflinePlayer offlinePlayer = this.plugin.getServer().getOfflinePlayer(cmdArg[1]);
                    String offlinePlayerName = offlinePlayer.getName();
                    if (offlinePlayerName == null) {
                        offlinePlayerName = "null";
                    }
                    switch (cmdArg[0]) {
                        case "add": {
                            shop.addStaff(offlinePlayer.getUniqueId());
                            MsgUtil.sendMessage((CommandSender)sender, "shop-staff-added", offlinePlayerName);
                            return;
                        }
                        case "del": {
                            shop.delStaff(offlinePlayer.getUniqueId());
                            MsgUtil.sendMessage((CommandSender)sender, "shop-staff-deleted", offlinePlayerName);
                            return;
                        }
                    }
                    MsgUtil.sendMessage((CommandSender)sender, "command.wrong-args", new String[0]);
                    return;
                }
            }
            MsgUtil.sendMessage((CommandSender)sender, "command.wrong-args", new String[0]);
            return;
        }
        MsgUtil.sendMessage((CommandSender)sender, "not-looking-at-shop", new String[0]);
    }

    @Override
    @NotNull
    public List<String> onTabComplete(@NotNull Player sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        String prefix;
        if (cmdArg.length == 1) {
            return this.tabCompleteList;
        }
        if (cmdArg.length == 2 && ("add".equals(prefix = cmdArg[0].toLowerCase()) || "del".equals(cmdArg[0]))) {
            return Util.getPlayerList();
        }
        return Collections.emptyList();
    }

    public SubCommand_Staff(QuickShop plugin) {
        this.plugin = plugin;
    }
}

