/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.command.subcommand;

import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.BlockIterator;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.command.CommandHandler;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.util.MsgUtil;

public class SubCommand_Unlimited
implements CommandHandler<Player> {
    private final QuickShop plugin;

    @Override
    public void onCommand(@NotNull Player sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        BlockIterator bIt = new BlockIterator((LivingEntity)sender, 10);
        if (!bIt.hasNext()) {
            MsgUtil.sendMessage((CommandSender)sender, "not-looking-at-shop", new String[0]);
            return;
        }
        while (bIt.hasNext()) {
            Block b = bIt.next();
            Shop shop = this.plugin.getShopManager().getShop(b.getLocation());
            if (shop == null) continue;
            shop.setUnlimited(!shop.isUnlimited());
            shop.update();
            if (shop.isUnlimited()) {
                MsgUtil.sendMessage((CommandSender)sender, "command.toggle-unlimited.unlimited", new String[0]);
                if (this.plugin.getConfig().getBoolean("unlimited-shop-owner-change")) {
                    this.plugin.getShopManager().migrateOwnerToUnlimitedShopOwner(shop);
                    MsgUtil.sendMessage((CommandSender)sender, "unlimited-shop-owner-changed", this.plugin.getShopManager().getCacheUnlimitedShopAccount().getName());
                }
                return;
            }
            MsgUtil.sendMessage((CommandSender)sender, "command.toggle-unlimited.limited", new String[0]);
            if (this.plugin.getConfig().getBoolean("unlimited-shop-owner-change")) {
                MsgUtil.sendMessage((CommandSender)sender, "unlimited-shop-owner-keeped", new String[0]);
            }
            return;
        }
        MsgUtil.sendMessage((CommandSender)sender, "not-looking-at-shop", new String[0]);
    }

    public SubCommand_Unlimited(QuickShop plugin) {
        this.plugin = plugin;
    }
}

