/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.command.subcommand;

import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.BootError;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.command.CommandHandler;
import org.maxgamer.quickshop.util.MsgUtil;

public class SubCommand_Update
implements CommandHandler<CommandSender> {
    private final QuickShop plugin;

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            MsgUtil.sendDirectMessage(sender, ChatColor.YELLOW + "Checking for updates...");
            if (this.plugin.getUpdateWatcher() == null) {
                MsgUtil.sendDirectMessage(sender, ChatColor.RED + "It seems like the Updater has been disabled.");
                return;
            }
            if (this.plugin.getUpdateWatcher().getUpdater().isLatest(this.plugin.getUpdateWatcher().getUpdater().getCurrentRunning())) {
                MsgUtil.sendDirectMessage(sender, ChatColor.GREEN + "You're running the latest version!.");
                return;
            }
            MsgUtil.sendDirectMessage(sender, ChatColor.YELLOW + "Downloading update! This may take a while...");
            try {
                this.plugin.getUpdateWatcher().getUpdater().install(this.plugin.getUpdateWatcher().getUpdater().update(this.plugin.getUpdateWatcher().getUpdater().getCurrentRunning()));
            }
            catch (Exception e) {
                MsgUtil.sendDirectMessage(sender, ChatColor.RED + "Update failed! Please check your console for more information.");
                this.plugin.getSentryErrorReporter().ignoreThrow();
                this.plugin.getLogger().log(Level.WARNING, "Failed to update QuickShop because of the following error:", e);
                return;
            }
            MsgUtil.sendDirectMessage(sender, ChatColor.GREEN + "Successful! Please restart your server to apply the updated version!");
            MsgUtil.sendDirectMessage(sender, ChatColor.YELLOW + "Before you restarting the server, QuickShop won't working again.");
            this.plugin.setupBootError(new BootError(this.plugin.getLogger(), "Reboot required after update the plugin."));
        });
    }

    public SubCommand_Update(QuickShop plugin) {
        this.plugin = plugin;
    }
}

