/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.database;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.database.DatabaseConnection;

public abstract class AbstractDatabaseCore {
    private final ReentrantLock lock = new ReentrantLock(true);
    private final Condition conditionLock = this.lock.newCondition();

    void waitForConnection() {
        this.lock.lock();
        try {
            this.conditionLock.await();
        }
        catch (InterruptedException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Exception when waiting new database connection", e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
    }

    void signalForNewConnection() {
        this.lock.lock();
        try {
            this.conditionLock.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    abstract void close();

    @NotNull
    synchronized DatabaseConnection getConnection() {
        DatabaseConnection databaseConnection = this.getConnection0();
        databaseConnection.markUsing();
        return databaseConnection;
    }

    protected abstract DatabaseConnection getConnection0();

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract Plugin getPlugin();
}

