/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.database.AbstractDatabaseCore;
import org.maxgamer.quickshop.database.DatabaseConnection;
import org.maxgamer.quickshop.database.DatabaseTask;
import org.maxgamer.quickshop.util.Timer;
import org.maxgamer.quickshop.util.Util;
import org.maxgamer.quickshop.util.WarningSender;

public class DatabaseManager {
    private final Queue<DatabaseTask> sqlQueue = new LinkedBlockingQueue<DatabaseTask>();
    @NotNull
    private final AbstractDatabaseCore database;
    @NotNull
    private final QuickShop plugin;
    @NotNull
    private final WarningSender warningSender;
    private final boolean useQueue;
    @Nullable
    private BukkitTask task;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseManager(@NotNull QuickShop plugin, @NotNull AbstractDatabaseCore dbCore) throws ConnectionException {
        this.plugin = plugin;
        this.warningSender = new WarningSender(plugin, 600000L);
        DatabaseConnection connection = dbCore.getConnection();
        try {
            if (!connection.isValid()) {
                throw new ConnectionException("The database does not appear to be valid!");
            }
        }
        finally {
            connection.release();
        }
        this.database = dbCore;
        this.useQueue = plugin.getConfig().getBoolean("database.queue");
        if (this.useQueue) {
            try {
                this.task = plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)plugin, () -> {
                    if (!this.task.isCancelled()) {
                        plugin.getDatabaseManager().runTask();
                    }
                }, 1L, plugin.getConfig().getLong("database.queue-commit-interval") * 20L);
            }
            catch (IllegalPluginAccessException e) {
                Util.debugLog("Plugin is disabled but trying create database task, move to Main Thread...");
                plugin.getDatabaseManager().runTask();
            }
        }
    }

    boolean hasTable(@NotNull String table) throws SQLException {
        DatabaseConnection connection = this.database.getConnection();
        ResultSet rs = connection.get().getMetaData().getTables(null, null, "%", null);
        boolean match = false;
        while (rs.next()) {
            if (!table.equalsIgnoreCase(rs.getString("TABLE_NAME"))) continue;
            match = true;
            break;
        }
        rs.close();
        connection.release();
        return match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasColumn(@NotNull String table, @NotNull String column) throws SQLException {
        if (!this.hasTable(table)) {
            return false;
        }
        DatabaseConnection connection = this.database.getConnection();
        String query = "SELECT * FROM " + table + " LIMIT 1";
        boolean match = false;
        try (PreparedStatement ps = connection.get().prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            ResultSetMetaData metaData = rs.getMetaData();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                if (!metaData.getColumnLabel(i).equals(column)) continue;
                match = true;
                break;
            }
        }
        catch (SQLException e) {
            boolean bl = match;
            return bl;
        }
        finally {
            connection.release();
        }
        return match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void runTask() {
        Queue<DatabaseTask> queue = this.sqlQueue;
        synchronized (queue) {
            if (this.sqlQueue.isEmpty()) {
                return;
            }
            DatabaseConnection dbconnection = this.database.getConnection();
            try (Connection connection = dbconnection.get();){
                long tookTime;
                Timer ctimer;
                block20: {
                    connection.setAutoCommit(false);
                    ctimer = new Timer(true);
                    while (true) {
                        if (!dbconnection.isValid()) {
                            this.warningSender.sendWarn("Database connection may lost, we are trying reconnecting, if this message appear too many times, you should check your database file(sqlite) and internet connection(mysql).");
                            return;
                        }
                        Timer timer = new Timer(true);
                        DatabaseTask task = this.sqlQueue.poll();
                        if (task == null) {
                            if (!connection.getAutoCommit()) {
                                break;
                            }
                            break block20;
                        }
                        task.run(connection);
                        long tookTime2 = timer.stopAndGetTimePassed();
                        if (tookTime2 <= 300L) continue;
                        this.warningSender.sendWarn("Database performance warning: It took too long time (" + tookTime2 + "ms) to execute the task, it may cause the network connection with MySQL server or just MySQL server too slow, change to a better MySQL server or switch to a local SQLite database!");
                    }
                    connection.commit();
                    connection.setAutoCommit(true);
                }
                if ((tookTime = ctimer.stopAndGetTimePassed()) <= 5500L) return;
                this.warningSender.sendWarn("Database performance warning: It took too long time (" + tookTime + "ms) to execute the task, it may cause the network connection with MySQL server or just MySQL server too slow, change to a better MySQL server or switch to a local SQLite database!");
            }
            catch (SQLException sqle) {
                this.plugin.getSentryErrorReporter().ignoreThrow();
                this.plugin.getLogger().log(Level.WARNING, "Database connection may lost, we are trying reconnecting, if this message appear too many times, you should check your database file(sqlite) and internet connection(mysql).", sqle);
            }
            finally {
                dbconnection.release();
            }
            return;
        }
    }

    public void runInstantTask(DatabaseTask task) {
        DatabaseConnection connection = this.database.getConnection();
        task.run(connection.get());
        connection.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDelayTask(DatabaseTask task) {
        if (this.useQueue) {
            Queue<DatabaseTask> queue = this.sqlQueue;
            synchronized (queue) {
                this.sqlQueue.offer(task);
            }
        } else {
            this.runInstantTask(task);
        }
    }

    public synchronized void unInit() {
        if (this.task != null && !this.task.isCancelled()) {
            this.task.cancel();
        }
        this.plugin.getLogger().info("Please wait for the data to flush its data...");
        this.runTask();
        this.database.close();
    }

    @NotNull
    public AbstractDatabaseCore getDatabase() {
        return this.database;
    }

    public static final class ConnectionException
    extends Exception {
        private static final long serialVersionUID = 8348749992936357317L;

        private ConnectionException(String msg) {
            super(msg);
        }
    }
}

