/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.database;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.database.AbstractDatabaseCore;
import org.maxgamer.quickshop.database.DatabaseConnection;

public class MySQLCore
extends AbstractDatabaseCore {
    private static final int MAX_CONNECTIONS = 8;
    private final List<DatabaseConnection> POOL = new ArrayList<DatabaseConnection>();
    @NotNull
    private final Properties info;
    @NotNull
    private final String url;
    @NotNull
    private final QuickShop plugin;

    public MySQLCore(@NotNull QuickShop plugin, @NotNull String host, @NotNull String user, @NotNull String pass, @NotNull String database, @NotNull String port, boolean useSSL) {
        this.plugin = plugin;
        this.info = new Properties();
        this.info.setProperty("autoReconnect", "true");
        this.info.setProperty("user", user);
        this.info.setProperty("password", pass);
        this.info.setProperty("useUnicode", "true");
        this.info.setProperty("characterEncoding", "utf8");
        this.info.setProperty("useSSL", String.valueOf(useSSL));
        this.url = "jdbc:mysql://" + host + ":" + port + "/" + database;
        for (int i = 0; i < 8; ++i) {
            this.POOL.add(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void close() {
        for (DatabaseConnection databaseConnection : this.POOL) {
            if (databaseConnection == null || !databaseConnection.isValid()) continue;
            if (!databaseConnection.isUsing()) {
                databaseConnection.close();
                continue;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
            continue;
            finally {
                this.close();
            }
        }
    }

    @Override
    protected synchronized DatabaseConnection getConnection0() {
        for (int i = 0; i < 8; ++i) {
            DatabaseConnection connection = this.POOL.get(i);
            if (connection == null) {
                return this.genConnection(i);
            }
            if (connection.isUsing()) continue;
            if (connection.isValid()) {
                return connection;
            }
            connection.close();
            return this.genConnection(i);
        }
        this.waitForConnection();
        return this.getConnection0();
    }

    private synchronized DatabaseConnection genConnection(int index) {
        try {
            DatabaseConnection connection = new DatabaseConnection(this, DriverManager.getConnection(this.url, this.info));
            this.POOL.set(index, connection);
            return connection;
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to create a new connection", e);
        }
    }

    @Override
    @NotNull
    public String getName() {
        return "BuiltIn-MySQL";
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }
}

