/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.economy;

import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EconomyCore {
    public boolean deposit(@NotNull UUID var1, double var2, @NotNull World var4, @Nullable String var5);

    public boolean deposit(@NotNull OfflinePlayer var1, double var2, @NotNull World var4, @Nullable String var5);

    public String format(double var1, @NotNull World var3, @Nullable String var4);

    public double getBalance(@NotNull UUID var1, @NotNull World var2, @Nullable String var3);

    public double getBalance(@NotNull OfflinePlayer var1, @NotNull World var2, @Nullable String var3);

    default public boolean transfer(@NotNull UUID from, @NotNull UUID to, double amount, @NotNull World world, @Nullable String currency) {
        if (!this.isValid()) {
            return false;
        }
        if (this.getBalance(from, world, currency) >= amount) {
            if (this.withdraw(from, amount, world, currency)) {
                if (this.deposit(to, amount, world, currency)) {
                    this.deposit(from, amount, world, currency);
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean withdraw(@NotNull UUID var1, double var2, @NotNull World var4, @Nullable String var5);

    public boolean withdraw(@NotNull OfflinePlayer var1, double var2, @NotNull World var4, @Nullable String var5);

    public boolean hasCurrency(@NotNull World var1, @NotNull String var2);

    public boolean supportCurrency();

    public boolean isValid();

    @NotNull
    public String getName();

    @NotNull
    public Plugin getPlugin();
}

