/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.economy;

import java.util.UUID;
import me.xanium.gemseconomy.api.GemsEconomyAPI;
import me.xanium.gemseconomy.currency.Currency;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.economy.EconomyCore;
import org.maxgamer.quickshop.util.Util;

public class Economy_GemsEconomy
implements EconomyCore {
    private final QuickShop plugin;
    private final boolean allowLoan;
    private GemsEconomyAPI api;

    public Economy_GemsEconomy(@NotNull QuickShop plugin) {
        this.plugin = plugin;
        this.allowLoan = plugin.getConfig().getBoolean("shop.allow-economy-loan");
        this.setupEconomy();
    }

    private void setupEconomy() {
        this.api = new GemsEconomyAPI();
    }

    @Nullable
    private Currency getCurrency(@NotNull World world, @Nullable String currency) {
        if (!this.isValid()) {
            return null;
        }
        if (currency == null) {
            return null;
        }
        return this.api.getCurrency(currency);
    }

    @Override
    public boolean deposit(@NotNull UUID name, double amount, @NotNull World world, @Nullable String currency) {
        if (!this.isValid()) {
            return false;
        }
        this.api.deposit(name, amount, this.getCurrency(world, currency));
        return true;
    }

    @Override
    public boolean deposit(@NotNull OfflinePlayer trader, double amount, @NotNull World world, @Nullable String currency) {
        return this.deposit(trader.getUniqueId(), amount, world, currency);
    }

    @Override
    public String format(double balance, @NotNull World world, @Nullable String currency) {
        if (!this.isValid()) {
            return "Error";
        }
        return this.formatInternal(balance, world, currency);
    }

    private String formatInternal(double balance, @NotNull World world, @Nullable String currency) {
        if (!this.isValid()) {
            return "Error";
        }
        return Util.format(balance, true, world, currency);
    }

    @Override
    public double getBalance(@NotNull UUID name, @NotNull World world, @Nullable String currency) {
        if (!this.isValid()) {
            return 0.0;
        }
        return this.api.getBalance(name, this.getCurrency(world, currency));
    }

    @Override
    public double getBalance(@NotNull OfflinePlayer player, @NotNull World world, @Nullable String currency) {
        return this.getBalance(player.getUniqueId(), world, currency);
    }

    @Override
    public boolean withdraw(@NotNull UUID name, double amount, @NotNull World world, @Nullable String currency) {
        if (!this.isValid()) {
            return false;
        }
        if (!this.allowLoan && this.getBalance(name, world, currency) < amount) {
            return false;
        }
        this.api.withdraw(name, amount, this.getCurrency(world, currency));
        return true;
    }

    @Override
    public boolean withdraw(@NotNull OfflinePlayer trader, double amount, @NotNull World world, @Nullable String currency) {
        return this.withdraw(trader.getUniqueId(), amount, world, currency);
    }

    @Override
    public boolean hasCurrency(@NotNull World world, @NotNull String currency) {
        return this.getCurrency(world, currency) != null;
    }

    @Override
    public boolean supportCurrency() {
        return true;
    }

    @Override
    public boolean isValid() {
        return this.api != null;
    }

    @Override
    @NotNull
    public String getName() {
        return "BuiltIn-GemsEconomy";
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    public GemsEconomyAPI getApi() {
        return this.api;
    }

    public void setApi(GemsEconomyAPI api) {
        this.api = api;
    }
}

