/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.eventmanager;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.AuthorNagException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.eventmanager.ListenerContainer;
import org.maxgamer.quickshop.eventmanager.QuickEventManager;
import org.maxgamer.quickshop.util.Util;

public class QSEventManager
implements QuickEventManager,
Listener {
    private final QuickShop plugin;
    private final List<ListenerContainer> ignoredListener = new ArrayList<ListenerContainer>();

    public QSEventManager(QuickShop plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void serverReloaded(ServerLoadEvent event) {
        this.rescan();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void pluginDisable(PluginDisableEvent event) {
        this.rescan();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void pluginEnable(PluginEnableEvent event) {
        this.rescan();
    }

    private synchronized void rescan() {
        this.ignoredListener.clear();
        this.plugin.getConfig().getStringList("shop.protection-checking-listener-blacklist").forEach(input -> {
            if (StringUtils.isEmpty((String)input)) {
                return;
            }
            try {
                Class<?> clazz = Class.forName(input);
                this.ignoredListener.add(new ListenerContainer(clazz, (String)input));
                Util.debugLog("Successfully added blacklist: [CLAZZ] " + clazz.getName());
            }
            catch (Exception ignored) {
                this.ignoredListener.add(new ListenerContainer(null, (String)input));
                Util.debugLog("Successfully added blacklist: [DYNAMIC] " + input);
            }
        });
    }

    @Override
    public void callEvent(Event event) {
        if (event.isAsynchronous()) {
            if (Thread.holdsLock(this.plugin.getServer().getPluginManager())) {
                throw new IllegalStateException(event.getEventName() + " cannot be triggered asynchronously from inside synchronized code.");
            }
            if (Bukkit.getServer().isPrimaryThread()) {
                throw new IllegalStateException(event.getEventName() + " cannot be triggered asynchronously from primary server thread.");
            }
        } else if (!Bukkit.getServer().isPrimaryThread()) {
            throw new IllegalStateException(event.getEventName() + " cannot be triggered asynchronously from another thread.");
        }
        this.fireEvent(event);
    }

    private void fireEvent(Event event) {
        RegisteredListener[] listeners;
        HandlerList handlers = event.getHandlers();
        for (RegisteredListener registration : listeners = handlers.getRegisteredListeners()) {
            if (!registration.getPlugin().isEnabled()) continue;
            Class<?> regClass = registration.getListener().getClass();
            boolean skip = false;
            for (ListenerContainer container : this.ignoredListener) {
                if (!container.matches(regClass, registration.getPlugin())) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            try {
                registration.callEvent(event);
            }
            catch (AuthorNagException ex) {
                Plugin plugin = registration.getPlugin();
                if (!plugin.isNaggable()) continue;
                plugin.setNaggable(false);
                plugin.getServer().getLogger().log(Level.SEVERE, String.format("Nag author(s): '%s' of '%s' about the following: %s", plugin.getDescription().getAuthors(), plugin.getDescription().getFullName(), ex.getMessage()));
            }
            catch (Throwable ex) {
                this.plugin.getServer().getLogger().log(Level.SEVERE, "Could not pass event " + event.getEventName() + " to " + registration.getPlugin().getDescription().getFullName(), ex);
            }
        }
    }
}

