/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.file.newest.json.json.JsonConfiguration;
import org.maxgamer.quickshop.file.newest.json.util.SerializationHelper;
import org.maxgamer.quickshop.util.JsonUtil;

public class HumanReadableJsonConfiguration
extends JsonConfiguration {
    private static final Logger logger = Logger.getLogger(HumanReadableJsonConfiguration.class.getName());

    public static HumanReadableJsonConfiguration loadConfiguration(@NotNull File file) {
        HumanReadableJsonConfiguration configuration = new HumanReadableJsonConfiguration();
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            configuration.load(file);
        }
        catch (IOException | InvalidConfigurationException var4) {
            logger.log(Level.SEVERE, "Cannot load json file " + file, var4);
        }
        return configuration;
    }

    public static HumanReadableJsonConfiguration loadConfiguration(@NotNull InputStreamReader inputStreamReader) {
        HumanReadableJsonConfiguration configuration = new HumanReadableJsonConfiguration();
        try {
            configuration.load(inputStreamReader);
        }
        catch (IOException | InvalidConfigurationException exception) {
            logger.log(Level.SEVERE, "Cannot load original language file", exception);
        }
        return configuration;
    }

    @Override
    @NotNull
    public String saveToString() {
        return JsonUtil.getHumanReadableGson().toJson(SerializationHelper.serialize(this.getValues(false)));
    }
}

