/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.integration.lands;

import java.util.Map;
import java.util.UUID;
import me.angeschossen.lands.api.events.LandUntrustPlayerEvent;
import me.angeschossen.lands.api.events.PlayerLeaveLandEvent;
import me.angeschossen.lands.api.land.Land;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.integration.IntegrationStage;
import org.maxgamer.quickshop.integration.QSIntegratedPlugin;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.shop.ShopChunk;
import org.maxgamer.quickshop.util.Util;

@IntegrationStage
public class LandsIntegration
extends QSIntegratedPlugin
implements Listener {
    private final boolean ignoreDisabledWorlds;
    private final boolean whitelist;
    private final me.angeschossen.lands.api.integration.LandsIntegration landsIntegration;
    private final boolean deleteWhenLosePermission;

    public LandsIntegration(QuickShop plugin) {
        super(plugin);
        this.landsIntegration = new me.angeschossen.lands.api.integration.LandsIntegration((Plugin)plugin);
        this.ignoreDisabledWorlds = plugin.getConfig().getBoolean("integration.lands.ignore-disabled-worlds");
        this.whitelist = plugin.getConfig().getBoolean("integration.lands.whitelist-mode");
        this.deleteWhenLosePermission = plugin.getConfig().getBoolean("integration.lands.delete-on-lose-permission");
    }

    @Override
    @NotNull
    public String getName() {
        return "Lands";
    }

    @Override
    public boolean canCreateShopHere(@NotNull Player player, @NotNull Location location) {
        if (this.landsIntegration.getLandWorld(location.getWorld()) == null) {
            return this.ignoreDisabledWorlds;
        }
        Land land = this.landsIntegration.getLand(location);
        if (land != null) {
            return land.getOwnerUID().equals(player.getUniqueId()) || land.isTrusted(player.getUniqueId());
        }
        return !this.whitelist;
    }

    @Override
    public boolean canTradeShopHere(@NotNull Player player, @NotNull Location location) {
        if (this.landsIntegration.getLandWorld(location.getWorld()) == null) {
            return this.ignoreDisabledWorlds;
        }
        return true;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onLandsPermissionChanges(LandUntrustPlayerEvent event) {
        if (!this.deleteWhenLosePermission) {
            return;
        }
        this.deleteShopInLand(event.getLand(), event.getTarget());
    }

    private void deleteShopInLand(Land land, UUID target) {
        for (Map.Entry<String, Map<ShopChunk, Map<Location, Shop>>> entry : this.plugin.getShopManager().getShops().entrySet()) {
            World world = this.plugin.getServer().getWorld(entry.getKey());
            if (world == null) continue;
            for (Map.Entry<ShopChunk, Map<Location, Shop>> chunkedShopEntry : entry.getValue().entrySet()) {
                ShopChunk shopChunk = chunkedShopEntry.getKey();
                if (!land.hasChunk(world, shopChunk.getX(), shopChunk.getZ())) continue;
                Map<Location, Shop> shops = chunkedShopEntry.getValue();
                for (Shop shop : shops.values()) {
                    if (!target.equals(shop.getOwner())) continue;
                    this.plugin.log("[UNTRUSTED DELETE] Shop " + shop + " has been deleted due the owner no-longer have permission in land " + land.getName());
                    Util.mainThreadRun(shop::delete);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onLandsMember(PlayerLeaveLandEvent event) {
        if (!this.deleteWhenLosePermission) {
            return;
        }
        this.deleteShopInLand(event.getLand(), event.getLandPlayer().getUID());
    }

    @Override
    public void load() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void unload() {
        HandlerList.unregisterAll((Listener)this);
    }
}

