/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.integration.plotsquared;

import com.google.common.eventbus.Subscribe;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlayerPlotTrustedEvent;
import com.plotsquared.core.events.PlotDeleteEvent;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.types.BooleanFlag;
import com.sk89q.worldedit.regions.CuboidRegion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.integration.IntegrateStage;
import org.maxgamer.quickshop.integration.IntegrationStage;
import org.maxgamer.quickshop.integration.QSIntegratedPlugin;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.util.Util;

@IntegrationStage(loadStage=IntegrateStage.onEnableAfter)
public class PlotSquaredIntegrationV6
extends QSIntegratedPlugin {
    private final boolean whiteList;
    private final boolean deleteUntrusted;
    private QuickshopCreateFlag createFlag;
    private QuickshopTradeFlag tradeFlag;

    public PlotSquaredIntegrationV6(QuickShop plugin) {
        super(plugin);
        this.whiteList = plugin.getConfig().getBoolean("integration.plotsquared.whitelist-mode");
        this.deleteUntrusted = plugin.getConfig().getBoolean("integration.plotsquared.delete-when-user-untrusted");
    }

    @Override
    @NotNull
    public String getName() {
        return "PlotSquared";
    }

    @Override
    public boolean canCreateShopHere(@NotNull Player player, @NotNull org.bukkit.Location location) {
        Location pLocation = Location.at((String)location.getWorld().getName(), (int)location.getBlockX(), (int)location.getBlockY(), (int)location.getBlockZ());
        Plot plot = pLocation.getPlot();
        if (plot == null) {
            return !this.whiteList;
        }
        return (Boolean)plot.getFlag((PlotFlag)this.createFlag);
    }

    @Override
    public boolean canTradeShopHere(@NotNull Player player, @NotNull org.bukkit.Location location) {
        Location pLocation = Location.at((String)location.getWorld().getName(), (int)location.getBlockX(), (int)location.getBlockY(), (int)location.getBlockZ());
        Plot plot = pLocation.getPlot();
        if (plot == null) {
            return !this.whiteList;
        }
        return (Boolean)plot.getFlag((PlotFlag)this.tradeFlag);
    }

    @Override
    public void load() {
        this.createFlag = new QuickshopCreateFlag();
        this.tradeFlag = new QuickshopTradeFlag();
        GlobalFlagContainer.getInstance().addAll(Arrays.asList(new PlotFlag[]{this.createFlag, this.tradeFlag}));
        this.plugin.getLogger().info(ChatColor.GREEN + this.getName() + " flags register successfully.");
        Util.debugLog("Success register " + this.getName() + " flags.");
        PlotSquared.get().getEventDispatcher().registerListener((Object)this);
    }

    @Override
    public void unload() {
        PlotSquared.get().getEventDispatcher().unregisterListener((Object)this);
    }

    private List<Shop> getShops(Plot plot) {
        ArrayList<Shop> shopsList = new ArrayList<Shop>();
        for (CuboidRegion region : plot.getRegions()) {
            for (int x = region.getMinimumPoint().getX() >> 4; x <= region.getMaximumPoint().getX() >> 4; ++x) {
                for (int z = region.getMinimumPoint().getZ() >> 4; z <= region.getMaximumPoint().getZ() >> 4; ++z) {
                    Map<org.bukkit.Location, Shop> shops = this.plugin.getShopManager().getShops(plot.getWorldName(), x, z);
                    if (shops == null) continue;
                    shopsList.addAll(shops.values());
                }
            }
        }
        return shopsList;
    }

    @Subscribe
    public void onPlotDelete(PlotDeleteEvent event) {
        this.getShops(event.getPlot()).forEach(Shop::delete);
    }

    @Subscribe
    public void onPlotPlayerUntrusted(PlayerPlotTrustedEvent event) {
        if (!this.deleteUntrusted) {
            return;
        }
        if (event.wasAdded()) {
            return;
        }
        this.getShops(event.getPlot()).stream().filter(shop -> shop.getOwner().equals(event.getPlayer())).forEach(Shop::delete);
    }

    static class QuickshopCreateFlag
    extends BooleanFlag<QuickshopCreateFlag> {
        protected QuickshopCreateFlag(boolean value, Caption description) {
            super(value, description);
        }

        public QuickshopCreateFlag() {
            super(true, (Caption)TranslatableCaption.of((String)"quickshop-create"));
        }

        protected QuickshopCreateFlag flagOf(@NotNull Boolean aBoolean) {
            return new QuickshopCreateFlag(aBoolean, (Caption)TranslatableCaption.of((String)"quickshop-create"));
        }
    }

    static class QuickshopTradeFlag
    extends BooleanFlag<QuickshopTradeFlag> {
        protected QuickshopTradeFlag(boolean value, Caption description) {
            super(value, description);
        }

        public QuickshopTradeFlag() {
            super(true, (Caption)TranslatableCaption.of((String)"quickshop-trade"));
        }

        protected QuickshopTradeFlag flagOf(@NotNull Boolean aBoolean) {
            return new QuickshopTradeFlag(aBoolean, (Caption)TranslatableCaption.of((String)"quickshop-trade"));
        }
    }
}

