/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.integration.towny;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.event.PlotClearEvent;
import com.palmergames.bukkit.towny.event.TownRemoveResidentEvent;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.utils.ShopPlotUtil;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.integration.IntegrateStage;
import org.maxgamer.quickshop.integration.IntegrationStage;
import org.maxgamer.quickshop.integration.QSIntegratedPlugin;
import org.maxgamer.quickshop.integration.towny.TownyFlags;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.shop.ShopChunk;
import org.maxgamer.quickshop.util.Util;

@IntegrationStage(loadStage=IntegrateStage.onEnableAfter)
public class TownyIntegration
extends QSIntegratedPlugin
implements Listener {
    private final List<TownyFlags> createFlags;
    private final List<TownyFlags> tradeFlags;
    private final boolean ignoreDisabledWorlds;
    private final boolean deleteShopOnLeave;
    private final boolean deleteShopOnPlotClear;
    private boolean isNewVersion;

    public TownyIntegration(QuickShop plugin) {
        super(plugin);
        this.createFlags = TownyFlags.deserialize(plugin.getConfig().getStringList("integration.towny.create"));
        this.tradeFlags = TownyFlags.deserialize(plugin.getConfig().getStringList("integration.towny.trade"));
        this.ignoreDisabledWorlds = plugin.getConfig().getBoolean("integration.towny.ignore-disabled-worlds");
        this.deleteShopOnLeave = plugin.getConfig().getBoolean("integration.towny.delete-shop-on-resident-leave");
        this.deleteShopOnPlotClear = plugin.getConfig().getBoolean("integration.towny.delete-shop-on-plot-clear");
        try {
            Town.class.getDeclaredMethod("getHomeblockWorld", new Class[0]);
            this.isNewVersion = true;
        }
        catch (NoSuchMethodException exception) {
            this.isNewVersion = false;
        }
    }

    @Override
    @NotNull
    public String getName() {
        return "Towny";
    }

    public void deleteShops(UUID owner, Town town) {
        if (!this.deleteShopOnLeave) {
            return;
        }
        if (owner == null) {
            return;
        }
        String worldName = this.isNewVersion ? town.getHomeblockWorld().getName() : town.getWorld().getName();
        for (Map.Entry<String, Map<ShopChunk, Map<Location, Shop>>> entry : this.plugin.getShopManager().getShops().entrySet()) {
            World world;
            if (!worldName.equals(entry.getKey()) || (world = Bukkit.getWorld((String)entry.getKey())) == null) continue;
            for (Map.Entry<ShopChunk, Map<Location, Shop>> chunkedShopEntry : entry.getValue().entrySet()) {
                Map<Location, Shop> shopMap = chunkedShopEntry.getValue();
                for (Shop shop : shopMap.values()) {
                    if (!shop.getOwner().equals(owner)) continue;
                    try {
                        if (WorldCoord.parseWorldCoord((Location)shop.getLocation()).getTownBlock().getTown() != town) continue;
                        shop.delete();
                    }
                    catch (NotRegisteredException notRegisteredException) {}
                }
            }
        }
    }

    public void purgeShops(TownBlock townBlock) {
        if (!this.deleteShopOnPlotClear) {
            return;
        }
        String worldName = townBlock.getWorld().getName();
        for (Map.Entry<String, Map<ShopChunk, Map<Location, Shop>>> entry : this.plugin.getShopManager().getShops().entrySet()) {
            World world;
            if (!worldName.equals(entry.getKey()) || (world = Bukkit.getWorld((String)entry.getKey())) == null) continue;
            for (Map.Entry<ShopChunk, Map<Location, Shop>> chunkedShopEntry : entry.getValue().entrySet()) {
                Map<Location, Shop> shopMap = chunkedShopEntry.getValue();
                for (Shop shop : shopMap.values()) {
                    try {
                        if (WorldCoord.parseWorldCoord((Location)shop.getLocation()).getTownBlock() != townBlock) continue;
                        shop.delete();
                    }
                    catch (NotRegisteredException notRegisteredException) {}
                }
            }
        }
    }

    @EventHandler
    public void onPlayerLeave(TownRemoveResidentEvent event) {
        if (Bukkit.isPrimaryThread()) {
            this.deleteShops(TownyAPI.getInstance().getPlayerUUID(event.getResident()), event.getTown());
        } else {
            Util.mainThreadRun(() -> this.deleteShops(TownyAPI.getInstance().getPlayerUUID(event.getResident()), event.getTown()));
        }
    }

    @EventHandler
    public void onPlotClear(PlotClearEvent event) {
        if (Bukkit.isPrimaryThread()) {
            this.purgeShops(event.getTownBlock());
        } else {
            Util.mainThreadRun(() -> this.purgeShops(event.getTownBlock()));
        }
    }

    @Override
    public boolean canCreateShopHere(@NotNull Player player, @NotNull Location location) {
        return this.checkFlags(player, location, this.createFlags);
    }

    private boolean checkFlags(@NotNull Player player, @NotNull Location location, List<TownyFlags> flags) {
        if (this.ignoreDisabledWorlds && !TownyAPI.getInstance().isTownyWorld(location.getWorld())) {
            Util.debugLog("This world disabled Towny.");
            return true;
        }
        for (TownyFlags flag : flags) {
            switch (flag) {
                case OWN: {
                    if (ShopPlotUtil.doesPlayerOwnShopPlot((Player)player, (Location)location)) break;
                    return false;
                }
                case MODIFY: {
                    if (ShopPlotUtil.doesPlayerHaveAbilityToEditShopPlot((Player)player, (Location)location)) break;
                    return false;
                }
                case SHOPTYPE: {
                    if (ShopPlotUtil.isShopPlot((Location)location)) break;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean canTradeShopHere(@NotNull Player player, @NotNull Location location) {
        return this.checkFlags(player, location, this.tradeFlags);
    }

    @Override
    public void load() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void unload() {
        HandlerList.unregisterAll((Listener)this);
    }
}

