/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.listener;

import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.Cache;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.listener.ProtectionListenerBase;
import org.maxgamer.quickshop.shade.io.papermc.lib.PaperLib;
import org.maxgamer.quickshop.shop.Info;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.shop.ShopAction;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;

public class BlockListener
extends ProtectionListenerBase {
    private final boolean update_sign_when_inventory_moving = super.getPlugin().getConfig().getBoolean("shop.update-sign-when-inventory-moving", true);

    public BlockListener(@NotNull QuickShop plugin, @Nullable Cache cache) {
        super(plugin, cache);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBreak(BlockBreakEvent e) {
        Block b = e.getBlock();
        Player p = e.getPlayer();
        if (Util.canBeShop(b)) {
            Shop shop = this.getShopPlayer(b.getLocation(), false);
            if (shop == null) {
                return;
            }
            if (p.getGameMode() == GameMode.CREATIVE && !p.getUniqueId().equals(shop.getOwner())) {
                if (p.getInventory().getItemInMainHand().getType() == Material.GOLDEN_AXE) {
                    if (this.getPlugin().getConfig().getBoolean("shop.disable-super-tool")) {
                        e.setCancelled(true);
                        MsgUtil.sendMessage((CommandSender)p, "supertool-is-disabled", new String[0]);
                        return;
                    }
                    MsgUtil.sendMessage((CommandSender)p, "break-shop-use-supertool", new String[0]);
                    return;
                }
                e.setCancelled(true);
                MsgUtil.sendMessage((CommandSender)p, "no-creative-break", MsgUtil.getItemi18n(Material.GOLDEN_AXE.name()));
                return;
            }
            Info action = super.getPlugin().getShopManager().getActions().get(p.getUniqueId());
            if (action != null) {
                action.setAction(ShopAction.CANCELLED);
            }
            this.plugin.log("Deleting shop " + shop + " request by block break.");
            shop.delete();
            MsgUtil.sendMessage((CommandSender)p, "success-removed-shop", new String[0]);
        } else if (Util.isWallSign(b.getType())) {
            Sign sign;
            BlockState state = PaperLib.getBlockState(b, false).getState();
            if (state instanceof Sign && ((sign = (Sign)state).getLine(0).equals(super.getPlugin().getConfig().getString("lockette.private")) || sign.getLine(0).equals(super.getPlugin().getConfig().getString("lockette.more_users")))) {
                return;
            }
            Shop shop = this.getShopNextTo(b.getLocation());
            if (shop == null) {
                return;
            }
            if (p.getGameMode() == GameMode.CREATIVE && !p.getUniqueId().equals(shop.getOwner())) {
                if (p.getInventory().getItemInMainHand().getType() == Material.GOLDEN_AXE) {
                    if (this.getPlugin().getConfig().getBoolean("shop.disable-super-tool")) {
                        e.setCancelled(true);
                        MsgUtil.sendMessage((CommandSender)p, "supertool-is-disabled", new String[0]);
                        return;
                    }
                    MsgUtil.sendMessage((CommandSender)p, "break-shop-use-supertool", new String[0]);
                    this.plugin.log("Deleting shop " + shop + " request by block break (super tool).");
                    shop.delete();
                    return;
                }
                e.setCancelled(true);
                MsgUtil.sendMessage((CommandSender)p, "no-creative-break", MsgUtil.getItemi18n(Material.GOLDEN_AXE.name()));
                return;
            }
            if (this.getPlugin().getConfig().getBoolean("shop.allow-owner-break-shop-sign") && p.getUniqueId().equals(shop.getOwner())) {
                return;
            }
            Util.debugLog("Cannot break the sign.");
            e.setCancelled(true);
        }
    }

    @Nullable
    private Shop getShopNextTo(@NotNull Location loc) {
        Block b = Util.getAttached(loc.getBlock());
        if (b == null) {
            return null;
        }
        return this.getShopPlayer(b.getLocation(), false);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onInventoryMove(InventoryMoveItemEvent event) {
        if (!this.update_sign_when_inventory_moving) {
            return;
        }
        Inventory inventory = event.getDestination();
        Location location = inventory.getLocation();
        if (location == null) {
            return;
        }
        Shop shop = this.getShopRedstone(location, true);
        if (shop != null) {
            super.getPlugin().getSignUpdateWatcher().scheduleSignUpdate(shop);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onSignUpdate(SignChangeEvent event) {
        Block posShopBlock = Util.getAttached(event.getBlock());
        if (posShopBlock == null) {
            return;
        }
        Shop shop = this.plugin.getShopManager().getShopIncludeAttached(posShopBlock.getLocation());
        if (shop == null) {
            return;
        }
        Player player = event.getPlayer();
        if (!shop.getModerator().isModerator(player.getUniqueId())) {
            MsgUtil.sendMessage((CommandSender)player, "not-managed-shop", new String[0]);
            event.setCancelled(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlace(BlockPlaceEvent e) {
        Material type = e.getBlock().getType();
        Block placingBlock = e.getBlock();
        Player player = e.getPlayer();
        if (type != Material.CHEST) {
            return;
        }
        Block chest = null;
        if (player.isSneaking()) {
            Block blockAgainst = e.getBlockAgainst();
            if (blockAgainst.getType() != Material.CHEST || placingBlock.getFace(blockAgainst) == BlockFace.UP || placingBlock.getFace(blockAgainst) == BlockFace.DOWN || Util.isDoubleChest(blockAgainst.getBlockData())) return;
            chest = e.getBlockAgainst();
        } else {
            BlockFace placingChestFacing = ((Directional)placingBlock.getBlockData()).getFacing();
            for (BlockFace face : Util.getVerticalFacing()) {
                if (face.equals((Object)placingChestFacing) || face.equals((Object)placingChestFacing.getOppositeFace())) continue;
                Block nearByBlock = placingBlock.getRelative(face);
                BlockData nearByBlockData = nearByBlock.getBlockData();
                if (nearByBlock.getType() != Material.CHEST || Util.isDoubleChest(nearByBlockData) || placingChestFacing != ((Directional)nearByBlockData).getFacing()) continue;
                if (chest == null) {
                    chest = nearByBlock;
                    continue;
                }
                if (placingBlock.getFace(nearByBlock) != Util.getRightSide(placingChestFacing)) continue;
                chest = nearByBlock;
            }
        }
        if (chest == null) {
            return;
        }
        Shop shop = this.getShopPlayer(chest.getLocation(), false);
        if (shop == null) return;
        if (!QuickShop.getPermissionManager().hasPermission((CommandSender)player, "quickshop.create.double")) {
            e.setCancelled(true);
            MsgUtil.sendMessage((CommandSender)player, "no-double-chests", new String[0]);
            return;
        } else {
            if (shop.getModerator().isModerator(player.getUniqueId())) return;
            e.setCancelled(true);
            MsgUtil.sendMessage((CommandSender)player, "not-managed-shop", new String[0]);
        }
    }
}

