/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.listener;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Furnace;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.BrewingStandFuelEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.Cache;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.listener.ProtectionListenerBase;
import org.maxgamer.quickshop.shade.io.papermc.lib.PaperLib;
import org.maxgamer.quickshop.shop.DisplayItem;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;

public class EnhanceDisplayProtectionListener
extends ProtectionListenerBase
implements Listener {
    public EnhanceDisplayProtectionListener(QuickShop plugin, Cache cache) {
        super(plugin, cache);
    }

    private void sendAlert(@NotNull String msg) {
        if (!this.plugin.getConfig().getBoolean("send-display-item-protection-alert")) {
            return;
        }
        MsgUtil.sendGlobalAlert(msg);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void block(BlockFromToEvent event) {
        Block targetBlock = event.getToBlock();
        Block shopBlock = targetBlock.getRelative(BlockFace.DOWN);
        Shop shop = this.getShopNature(shopBlock.getLocation(), true);
        if (shop == null) {
            return;
        }
        event.setCancelled(true);
        if (shop.getDisplay() != null) {
            shop.getDisplay().remove();
        }
        this.sendAlert("[DisplayGuard] Liuqid " + targetBlock.getLocation() + " trying flow to top of shop, QuickShop already cancel it.");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void block(BlockPistonExtendEvent event) {
        Block block = event.getBlock().getRelative(event.getDirection()).getRelative(BlockFace.DOWN);
        Shop shop = this.getShopRedstone(block.getLocation(), true);
        if (shop != null) {
            event.setCancelled(true);
            this.sendAlert("[DisplayGuard] Piston  " + event.getBlock().getLocation() + " trying push somethings on the shop top, QuickShop already cancel it.");
            if (shop.getDisplay() != null) {
                shop.getDisplay().remove();
            }
            return;
        }
        for (Block oBlock : event.getBlocks()) {
            Block otherBlock = oBlock.getRelative(event.getDirection()).getRelative(BlockFace.DOWN);
            if (!Util.canBeShop(otherBlock) || (shop = this.getShopNature(otherBlock.getLocation(), true)) == null) continue;
            event.setCancelled(true);
            this.sendAlert("[DisplayGuard] Piston  " + event.getBlock().getLocation() + " trying push somethings on the shop top, QuickShop already cancel it.");
            if (shop.getDisplay() != null) {
                shop.getDisplay().remove();
            }
            return;
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void block(BlockPistonRetractEvent event) {
        Block block = event.getBlock().getRelative(event.getDirection()).getRelative(BlockFace.DOWN);
        Shop shop = this.getShopNature(block.getLocation(), true);
        if (shop != null) {
            event.setCancelled(true);
            this.sendAlert("[DisplayGuard] Piston  " + event.getBlock().getLocation() + " trying pull somethings on the shop top, QuickShop already cancel it.");
            if (shop.getDisplay() != null) {
                shop.getDisplay().remove();
            }
            return;
        }
        for (Block oBlock : event.getBlocks()) {
            Block otherBlock = oBlock.getRelative(event.getDirection()).getRelative(BlockFace.DOWN);
            if (!Util.canBeShop(otherBlock) || (shop = this.getShopNature(otherBlock.getLocation(), true)) == null) continue;
            event.setCancelled(true);
            this.sendAlert("[DisplayGuard] Piston  " + event.getBlock().getLocation() + " trying push somethings on the shop top, QuickShop already cancel it.");
            if (shop.getDisplay() != null) {
                shop.getDisplay().remove();
            }
            return;
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void block(BrewingStandFuelEvent event) {
        ItemStack itemStack = event.getFuel();
        if (DisplayItem.checkIsGuardItemStack(itemStack)) {
            event.setCancelled(true);
            this.sendAlert("[DisplayGuard] Block  " + event.getBlock().getLocation() + " trying fuel the BrewingStand with DisplayItem.");
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void block(FurnaceBurnEvent event) {
        ItemStack itemStack = event.getFuel();
        if (DisplayItem.checkIsGuardItemStack(itemStack)) {
            event.setCancelled(true);
            Block furnace = event.getBlock();
            BlockState state = PaperLib.getBlockState(event.getBlock(), false).getState();
            if (state instanceof Furnace) {
                Furnace furnace1 = (Furnace)furnace.getState();
                this.sendAlert("[DisplayGuard] Block  " + event.getBlock().getLocation() + " trying burn with DisplayItem.");
                Util.inventoryCheck((Inventory)furnace1.getInventory());
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void block(FurnaceSmeltEvent event) {
        ItemStack itemStack = event.getSource();
        BlockState furnace = PaperLib.getBlockState(event.getBlock(), false).getState();
        if (DisplayItem.checkIsGuardItemStack(itemStack)) {
            event.setCancelled(true);
            if (furnace instanceof Furnace) {
                Furnace furnace1 = (Furnace)furnace;
                this.sendAlert("[DisplayGuard] Block  " + event.getBlock().getLocation() + " trying smelt with DisplayItem.");
                Util.inventoryCheck((Inventory)furnace1.getInventory());
            }
            return;
        }
        itemStack = event.getResult();
        if (DisplayItem.checkIsGuardItemStack(itemStack)) {
            event.setCancelled(true);
            if (furnace instanceof Furnace) {
                Furnace furnace1 = (Furnace)furnace;
                this.sendAlert("[DisplayGuard] Block  " + event.getBlock().getLocation() + " trying smelt with DisplayItem.");
                Util.inventoryCheck((Inventory)furnace1.getInventory());
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void entity(EntityPickupItemEvent e) {
        ItemStack stack = e.getItem().getItemStack();
        if (!DisplayItem.checkIsGuardItemStack(stack)) {
            return;
        }
        e.setCancelled(true);
        e.getItem().remove();
        this.sendAlert("[DisplayGuard] Entity " + e.getEntity().getName() + " # " + e.getEntity().getLocation() + " pickedup the displayItem, QuickShop already removed it.");
        LivingEntity entity = e.getEntity();
        if (entity instanceof InventoryHolder) {
            Util.inventoryCheck(((InventoryHolder)entity).getInventory());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void inventory(InventoryClickEvent event) {
        if (!DisplayItem.checkIsGuardItemStack(event.getCurrentItem())) {
            return;
        }
        if (event.getClickedInventory() == null) {
            return;
        }
        if (event.getClickedInventory().getLocation() == null) {
            return;
        }
        event.setCancelled(true);
        this.sendAlert("[DisplayGuard] Inventory " + event.getClickedInventory().getHolder() + " at" + event.getClickedInventory().getLocation() + " was clicked the displayItem, QuickShop already removed it.");
        event.getCurrentItem().setType(Material.AIR);
        event.setResult(Event.Result.DENY);
        Util.inventoryCheck(event.getInventory());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void inventory(InventoryDragEvent event) {
        ItemStack itemStack = event.getCursor();
        if (DisplayItem.checkIsGuardItemStack(itemStack)) {
            event.setCancelled(true);
            Util.inventoryCheck(event.getInventory());
            this.sendAlert("[DisplayGuard] Player  " + event.getWhoClicked().getName() + " trying use DisplayItem crafting.");
            return;
        }
        itemStack = event.getOldCursor();
        if (DisplayItem.checkIsGuardItemStack(itemStack)) {
            event.setCancelled(true);
            Util.inventoryCheck(event.getInventory());
            this.sendAlert("[DisplayGuard] Player  " + event.getWhoClicked().getName() + " trying use DisplayItem crafting.");
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void inventory(InventoryCreativeEvent event) {
        ItemStack itemStack = event.getCursor();
        if (DisplayItem.checkIsGuardItemStack(itemStack)) {
            event.setCancelled(true);
            Util.inventoryCheck(event.getInventory());
            this.sendAlert("[DisplayGuard] Player  " + event.getWhoClicked().getName() + " trying use DisplayItem crafting.");
            return;
        }
        itemStack = event.getCurrentItem();
        if (DisplayItem.checkIsGuardItemStack(itemStack)) {
            event.setCancelled(true);
            Util.inventoryCheck(event.getInventory());
            this.sendAlert("[DisplayGuard] Player  " + event.getWhoClicked().getName() + " trying use DisplayItem crafting.");
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void item(PlayerItemHeldEvent e) {
        ItemStack stack = e.getPlayer().getInventory().getItemInMainHand();
        ItemStack stackOffHand = e.getPlayer().getInventory().getItemInOffHand();
        if (DisplayItem.checkIsGuardItemStack(stack)) {
            e.getPlayer().getInventory().setItemInMainHand(new ItemStack(Material.AIR, 0));
            this.sendAlert("[DisplayGuard] Player " + e.getPlayer().getName() + " helded the displayItem, QuickShop already cancelled and removed it.");
            e.setCancelled(true);
            Util.inventoryCheck((Inventory)e.getPlayer().getInventory());
        }
        if (DisplayItem.checkIsGuardItemStack(stackOffHand)) {
            e.getPlayer().getInventory().setItemInOffHand(new ItemStack(Material.AIR, 0));
            this.sendAlert("[DisplayGuard] Player " + e.getPlayer().getName() + " helded the displayItem, QuickShop already cancelled and removed it.");
            e.setCancelled(true);
            Util.inventoryCheck((Inventory)e.getPlayer().getInventory());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void player(CraftItemEvent event) {
        ItemStack itemStack = event.getCurrentItem();
        if (DisplayItem.checkIsGuardItemStack(itemStack)) {
            event.setCancelled(true);
            Util.inventoryCheck((Inventory)event.getInventory());
            this.sendAlert("[DisplayGuard] Player  " + event.getWhoClicked().getName() + " trying use DisplayItem crafting.");
            return;
        }
        itemStack = event.getCursor();
        if (DisplayItem.checkIsGuardItemStack(itemStack)) {
            event.setCancelled(true);
            Util.inventoryCheck((Inventory)event.getInventory());
            this.sendAlert("[DisplayGuard] Player  " + event.getWhoClicked().getName() + " trying use DisplayItem crafting.");
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void player(PlayerBucketEmptyEvent event) {
        Block waterBlock = event.getBlockClicked().getRelative(event.getBlockFace());
        Shop shop = this.getShopPlayer(waterBlock.getRelative(BlockFace.DOWN).getLocation(), true);
        if (shop == null) {
            return;
        }
        event.setCancelled(true);
        this.sendAlert("[DisplayGuard] Player  " + event.getPlayer().getName() + " trying use water to move somethings on the shop top, QuickShop already remove it.");
    }
}

