/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.listener;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.Cache;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.listener.ProtectionListenerBase;
import org.maxgamer.quickshop.shade.io.papermc.lib.PaperLib;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;

public class LockListener
extends ProtectionListenerBase {
    public LockListener(@NotNull QuickShop plugin, @Nullable Cache cache) {
        super(plugin, cache);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBreak(BlockBreakEvent e) {
        Sign sign;
        Block b = e.getBlock();
        BlockState state = PaperLib.getBlockState(b, false).getState();
        if (state instanceof Sign && ((sign = (Sign)state).getLine(0).equals(super.getPlugin().getConfig().getString("lockette.private")) || sign.getLine(0).equals(super.getPlugin().getConfig().getString("lockette.more_users")))) {
            Util.debugLog("Skipped a dead-lock shop sign.(Lockette or other sign-lock plugin)");
            return;
        }
        Player p = e.getPlayer();
        if (Util.canBeShop(b)) {
            Shop shop = this.getShopPlayer(b.getLocation(), true);
            if (shop == null) {
                return;
            }
            if (!shop.getOwner().equals(p.getUniqueId()) && !QuickShop.getPermissionManager().hasPermission((CommandSender)p, "quickshop.other.destroy")) {
                e.setCancelled(true);
                MsgUtil.sendMessage((CommandSender)p, "no-permission", new String[0]);
            }
        } else if (Util.isWallSign(b.getType())) {
            Sign sign2;
            if (b instanceof Sign && ((sign2 = (Sign)b).getLine(0).equals(super.getPlugin().getConfig().getString("lockette.private")) || sign2.getLine(0).equals(super.getPlugin().getConfig().getString("lockette.more_users")))) {
                return;
            }
            if ((b = Util.getAttached(b)) == null) {
                return;
            }
            Shop shop = this.getShopPlayer(b.getLocation(), false);
            if (shop == null) {
                return;
            }
            if (!shop.getOwner().equals(p.getUniqueId()) && !QuickShop.getPermissionManager().hasPermission((CommandSender)p, "quickshop.other.destroy")) {
                e.setCancelled(true);
                MsgUtil.sendMessage((CommandSender)p, "no-permission", new String[0]);
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onSignPlace(BlockPlaceEvent event) {
        Block placedBlock = event.getBlock();
        if (!(placedBlock.getState() instanceof Sign)) {
            return;
        }
        Block posShopBlock = Util.getAttached(placedBlock);
        if (posShopBlock == null) {
            return;
        }
        Shop shop = this.plugin.getShopManager().getShopIncludeAttached(posShopBlock.getLocation());
        if (shop == null) {
            return;
        }
        Player player = event.getPlayer();
        if (!shop.getModerator().isOwner(player.getUniqueId())) {
            MsgUtil.sendMessage((CommandSender)player, "that-is-locked", new String[0]);
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onClick(PlayerInteractEvent e) {
        Block b = e.getClickedBlock();
        if (b == null) {
            return;
        }
        if (!Util.canBeShop(b)) {
            return;
        }
        Player p = e.getPlayer();
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Shop shop = this.getShopPlayer(b.getLocation(), true);
        if (shop == null) {
            return;
        }
        if (!shop.getModerator().isModerator(p.getUniqueId())) {
            if (QuickShop.getPermissionManager().hasPermission((CommandSender)p, "quickshop.other.open")) {
                MsgUtil.sendMessage((CommandSender)p, "bypassing-lock", new String[0]);
                return;
            }
            MsgUtil.sendMessage((CommandSender)p, "that-is-locked", new String[0]);
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlace(BlockPlaceEvent e) {
        Block b = e.getBlock();
        if (b.getType() != Material.HOPPER) {
            return;
        }
        Player p = e.getPlayer();
        if (!Util.isOtherShopWithinHopperReach(b, p)) {
            return;
        }
        if (QuickShop.getPermissionManager().hasPermission((CommandSender)p, "quickshop.other.open")) {
            MsgUtil.sendMessage((CommandSender)p, "bypassing-lock", new String[0]);
            return;
        }
        MsgUtil.sendMessage((CommandSender)p, "that-is-locked", new String[0]);
        e.setCancelled(true);
    }
}

