/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.listener;

import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.Cache;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.listener.QSListener;
import org.maxgamer.quickshop.shop.Shop;

public class ProtectionListenerBase
extends QSListener {
    private final Cache cache;

    public ProtectionListenerBase(@NotNull QuickShop plugin, @Nullable Cache cache) {
        super(plugin);
        this.cache = cache;
    }

    public QuickShop getPlugin() {
        return this.plugin;
    }

    @Nullable
    public Shop getShopRedstone(@NotNull Location location, boolean includeAttached) {
        if (this.cache != null) {
            return this.cache.getCaching(location, includeAttached);
        }
        if (includeAttached) {
            return this.plugin.getShopManager().getShopIncludeAttached(location);
        }
        return this.plugin.getShopManager().getShop(location);
    }

    @Nullable
    public Shop getShopPlayer(@NotNull Location location, boolean includeAttached) {
        return includeAttached ? this.plugin.getShopManager().getShopIncludeAttached(location, false) : this.plugin.getShopManager().getShop(location);
    }

    @Nullable
    public Shop getShopNature(@NotNull Location location, boolean includeAttached) {
        return includeAttached ? this.plugin.getShopManager().getShopIncludeAttached(location, false) : this.plugin.getShopManager().getShop(location);
    }

    public Cache getCache() {
        return this.cache;
    }
}

