/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.shade.com.rollbar.api.payload.data;

import java.util.HashMap;
import org.maxgamer.quickshop.shade.com.rollbar.api.json.JsonSerializable;

public enum Level implements Comparable<Level>,
JsonSerializable
{
    CRITICAL("critical", 50),
    ERROR("error", 40),
    WARNING("warning", 30),
    INFO("info", 20),
    DEBUG("debug", 10);

    private final String jsonName;
    private final int level;
    private static final HashMap<String, Level> nameIndex;

    private Level(String jsonName, int level) {
        this.jsonName = jsonName;
        this.level = level;
    }

    public static Level lookupByName(String name) {
        return name != null ? nameIndex.get(name.toLowerCase()) : null;
    }

    public int level() {
        return this.level;
    }

    @Override
    public String asJson() {
        return this.jsonName;
    }

    static {
        nameIndex = new HashMap(2 * Level.values().length);
        for (Level level : Level.values()) {
            nameIndex.put(level.jsonName, level);
        }
    }
}

