/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.shade.com.rollbar.api.payload.data;

import java.util.HashMap;
import java.util.Map;
import org.maxgamer.quickshop.shade.com.rollbar.api.json.JsonSerializable;

public class Notifier
implements JsonSerializable {
    private static final long serialVersionUID = -2605608164795462842L;
    private final String name;
    private final String version;

    private Notifier(Builder builder) {
        this.name = builder.name;
        this.version = builder.version;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notifier notifier = (Notifier)o;
        if (this.name != null ? !this.name.equals(notifier.name) : notifier.name != null) {
            return false;
        }
        return this.version != null ? this.version.equals(notifier.version) : notifier.version == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Notifier{name='" + this.name + '\'' + ", version='" + this.version + '\'' + '}';
    }

    @Override
    public Map<String, Object> asJson() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (this.name != null) {
            values.put("name", this.name);
        }
        if (this.version != null) {
            values.put("version", this.version);
        }
        return values;
    }

    public static final class Builder {
        private String name;
        private String version;

        public Builder() {
        }

        public Builder(Notifier notifier) {
            this.name = notifier.name;
            this.version = notifier.version;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Notifier build() {
            return new Notifier(this);
        }
    }
}

