/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.shade.com.rollbar.notifier.sender.json;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.maxgamer.quickshop.shade.com.rollbar.api.json.JsonSerializable;
import org.maxgamer.quickshop.shade.com.rollbar.api.payload.Payload;
import org.maxgamer.quickshop.shade.com.rollbar.notifier.sender.json.JsonSerializer;
import org.maxgamer.quickshop.shade.com.rollbar.notifier.sender.result.Result;

public class JsonSerializerImpl
implements JsonSerializer {
    private static final Pattern CODE_PATTERN = Pattern.compile("\"err\"\\s*:\\s*(\\d)");
    private static final Pattern MESSAGE_PATTERN = Pattern.compile("\"message\"\\s*:\\s*\"([^\"]*)\"");
    private static final Pattern UUID_PATTERN = Pattern.compile("\"uuid\"\\s*:\\s*\"([^\"]*)\"");
    private static final String[] REPLACEMENT_CHARS = new String[128];
    private final boolean prettyPrint;

    public JsonSerializerImpl() {
        this(false);
    }

    public JsonSerializerImpl(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    @Override
    public String toJson(Payload payload) {
        if (payload.json != null) {
            return payload.json;
        }
        StringBuilder builder = new StringBuilder();
        this.serializeValue(builder, payload, 0);
        return builder.toString();
    }

    @Override
    public Result resultFrom(String response) {
        int code;
        Matcher codeMatcher = CODE_PATTERN.matcher(response);
        if (!codeMatcher.find()) {
            return new Result.Builder().code(1).body(response).build();
        }
        String codeStr = codeMatcher.group(1);
        try {
            code = Integer.parseInt(codeStr);
        }
        catch (Exception e) {
            code = -1;
        }
        Pattern p = code == 0 ? UUID_PATTERN : MESSAGE_PATTERN;
        Matcher m = p.matcher(response);
        m.find();
        String body = m.group(1);
        return new Result.Builder().code(code).body(body).build();
    }

    private void serializeObject(Map<String, Object> content, StringBuilder builder, int level) {
        builder.append('{');
        String comma = "";
        for (Map.Entry<String, Object> entry : content.entrySet()) {
            builder.append(comma);
            comma = ",";
            if (this.prettyPrint) {
                builder.append("\n");
                JsonSerializerImpl.indent(builder, level);
            }
            JsonSerializerImpl.serializeString(builder, entry.getKey());
            builder.append(':');
            if (this.prettyPrint) {
                builder.append(" ");
            }
            this.serializeValue(builder, entry.getValue(), level + 1);
        }
        if (this.prettyPrint) {
            builder.append("\n");
        }
        builder.append('}');
    }

    private void serializeValue(StringBuilder builder, Object value, int level) {
        if (value == null) {
            JsonSerializerImpl.serializeNull(builder);
        } else if (value instanceof Boolean) {
            JsonSerializerImpl.serializeBoolean(builder, (Boolean)value);
        } else if (value instanceof Number) {
            JsonSerializerImpl.serializeNumber(builder, (Number)value);
        } else if (value instanceof String) {
            JsonSerializerImpl.serializeString(builder, (String)value);
        } else if (value instanceof JsonSerializable) {
            this.serializeValue(builder, ((JsonSerializable)value).asJson(), level);
        } else if (value instanceof Map) {
            Map<String, Object> obj = JsonSerializerImpl.asMap((Map)value);
            this.serializeObject(obj, builder, level);
        } else if (value instanceof Collection) {
            this.serializeArray(builder, ((Collection)value).toArray(), level);
        } else if (value instanceof Object[]) {
            this.serializeArray(builder, (Object[])value, level);
        } else if (value instanceof Throwable) {
            JsonSerializerImpl.serializeThrowable(builder, (Throwable)value);
        } else {
            JsonSerializerImpl.serializeDefault(builder, value);
        }
    }

    private static void serializeThrowable(StringBuilder builder, Throwable value) {
        StringWriter writer = new StringWriter();
        value.printStackTrace(new PrintWriter(writer));
        JsonSerializerImpl.serializeString(builder, value.toString());
    }

    private static void serializeDefault(StringBuilder builder, Object value) {
        JsonSerializerImpl.serializeString(builder, value == null ? "" : value.toString());
    }

    private static void serializeNumber(StringBuilder builder, Number value) {
        builder.append(value);
    }

    private static void serializeBoolean(StringBuilder builder, Boolean value) {
        builder.append(value != false ? "true" : "false");
    }

    private static void serializeNull(StringBuilder builder) {
        builder.append("null");
    }

    private void serializeArray(StringBuilder builder, Object[] array, int level) {
        builder.append('[');
        String comma = "";
        for (Object obj : array) {
            builder.append(comma);
            comma = ",";
            if (this.prettyPrint) {
                builder.append("\n");
                JsonSerializerImpl.indent(builder, level);
            }
            this.serializeValue(builder, obj, level + 1);
        }
        builder.append(']');
    }

    private static Map<String, Object> asMap(Map value) {
        try {
            Map obj = value;
            return obj;
        }
        catch (ClassCastException e) {
            LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
            Iterator iterator = value.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry thisOne = o = iterator.next();
                Object key = thisOne.getKey();
                Object val = thisOne.getValue();
                obj.put(key.toString(), val);
            }
            return obj;
        }
    }

    private static void serializeString(StringBuilder builder, String str) {
        builder.append('\"');
        int last = 0;
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            String replacement;
            char c = str.charAt(i);
            if (c < '\u0080') {
                replacement = REPLACEMENT_CHARS[c];
                if (replacement == null) {
                    continue;
                }
            } else if (c == '\u2028') {
                replacement = "\\u2028";
            } else {
                if (c != '\u2029') continue;
                replacement = "\\u2029";
            }
            if (last < i) {
                builder.append(str, last, i);
            }
            builder.append(replacement);
            last = i + 1;
        }
        if (last < length) {
            builder.append(str, last, length);
        }
        builder.append('\"');
    }

    private static void indent(StringBuilder builder, int i) {
        for (int x = 0; x <= i; ++x) {
            builder.append("  ");
        }
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            JsonSerializerImpl.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i);
        }
        JsonSerializerImpl.REPLACEMENT_CHARS[34] = "\\\"";
        JsonSerializerImpl.REPLACEMENT_CHARS[92] = "\\\\";
        JsonSerializerImpl.REPLACEMENT_CHARS[9] = "\\t";
        JsonSerializerImpl.REPLACEMENT_CHARS[8] = "\\b";
        JsonSerializerImpl.REPLACEMENT_CHARS[10] = "\\n";
        JsonSerializerImpl.REPLACEMENT_CHARS[13] = "\\r";
        JsonSerializerImpl.REPLACEMENT_CHARS[12] = "\\f";
    }
}

