/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.shop;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.util.JsonUtil;

public class ShopModerator
implements Cloneable {
    @NonNull
    private UUID owner;
    @NonNull
    private List<UUID> staffs;

    private ShopModerator(@NotNull ShopModerator shopModerator) {
        this.owner = shopModerator.owner;
        this.staffs = shopModerator.staffs;
    }

    public ShopModerator(@NotNull UUID owner) {
        this.owner = owner;
        this.staffs = new ArrayList<UUID>();
    }

    public ShopModerator(@NotNull UUID owner, @NotNull List<UUID> staffs) {
        this.owner = owner;
        this.staffs = staffs;
    }

    public static ShopModerator deserialize(@NotNull String serilized) throws JsonSyntaxException {
        Gson gson = JsonUtil.getGson();
        return (ShopModerator)gson.fromJson(serilized, ShopModerator.class);
    }

    public static String serialize(@NotNull ShopModerator shopModerator) {
        Gson gson = JsonUtil.getGson();
        return gson.toJson((Object)shopModerator);
    }

    public boolean addStaff(@NotNull UUID player) {
        if (this.staffs.contains(player)) {
            return false;
        }
        this.staffs.add(player);
        return true;
    }

    public void clearStaffs() {
        this.staffs.clear();
    }

    @NotNull
    public ShopModerator clone() {
        return new ShopModerator(this.owner, this.staffs);
    }

    @NotNull
    public String toString() {
        return ShopModerator.serialize(this);
    }

    public boolean delStaff(@NotNull UUID player) {
        return this.staffs.remove(player);
    }

    public boolean isModerator(@NotNull UUID player) {
        return this.isOwner(player) || this.isStaff(player);
    }

    public boolean isOwner(@NotNull UUID player) {
        return player.equals(this.owner);
    }

    public boolean isStaff(@NotNull UUID player) {
        return this.staffs.contains(player);
    }

    @NotNull
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(@NotNull UUID player) {
        this.owner = player;
    }

    @NotNull
    public List<UUID> getStaffs() {
        return this.staffs;
    }

    public void setStaffs(@NotNull List<UUID> players) {
        this.staffs = players;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShopModerator)) {
            return false;
        }
        ShopModerator other = (ShopModerator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$owner = this.getOwner();
        UUID other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
            return false;
        }
        List<UUID> this$staffs = this.getStaffs();
        List<UUID> other$staffs = other.getStaffs();
        return !(this$staffs == null ? other$staffs != null : !((Object)this$staffs).equals(other$staffs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShopModerator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : ((Object)$owner).hashCode());
        List<UUID> $staffs = this.getStaffs();
        result = result * 59 + ($staffs == null ? 43 : ((Object)$staffs).hashCode());
        return result;
    }
}

