/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.shop;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.injector.server.TemporaryPlayer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.event.ShopDisplayItemSpawnEvent;
import org.maxgamer.quickshop.shop.ContainerShop;
import org.maxgamer.quickshop.shop.DisplayItem;
import org.maxgamer.quickshop.shop.DisplayType;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.shop.ShopChunk;
import org.maxgamer.quickshop.util.AsyncPacketSender;
import org.maxgamer.quickshop.util.GameVersion;
import org.maxgamer.quickshop.util.Util;

public class VirtualDisplayItem
extends DisplayItem {
    private static final ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static final GameVersion version = plugin.getGameVersion();
    private final int entityID = counter.decrementAndGet();
    private final Set<UUID> packetSenders = new ConcurrentSkipListSet<UUID>();
    private volatile AsyncPacketSender.AsyncSendingTask asyncPacketSenderTask = null;
    private volatile boolean isDisplay;
    private volatile boolean initialized = false;
    private PacketContainer fakeItemSpawnPacket;
    private PacketContainer fakeItemMetaPacket;
    private PacketContainer fakeItemVelocityPacket;
    private PacketContainer fakeItemDestroyPacket;
    private PacketAdapter packetAdapter;
    private volatile ShopChunk chunkLocation;

    public VirtualDisplayItem(@NotNull Shop shop) throws RuntimeException {
        super(shop);
    }

    private void initFakeDropItemPacket() {
        this.fakeItemSpawnPacket = PacketFactory.createFakeItemSpawnPacket(this.entityID, this.getDisplayLocation());
        this.fakeItemMetaPacket = PacketFactory.createFakeItemMetaPacket(this.entityID, this.getOriginalItemStack().clone());
        this.fakeItemVelocityPacket = PacketFactory.createFakeItemVelocityPacket(this.entityID);
        this.fakeItemDestroyPacket = PacketFactory.createFakeItemDestroyPacket(this.entityID);
        this.initialized = true;
    }

    @Override
    public boolean checkDisplayIsMoved() {
        return false;
    }

    @Override
    public boolean checkDisplayNeedRegen() {
        return false;
    }

    @Override
    public boolean checkIsShopEntity(@NotNull Entity entity) {
        return false;
    }

    @Override
    public void fixDisplayMoved() {
    }

    @Override
    public void fixDisplayNeedRegen() {
    }

    @Override
    public void remove() {
        this.sendPacketToAll(this.fakeItemDestroyPacket);
        this.unload();
        this.isDisplay = false;
    }

    private void sendPacketToAll(@NotNull PacketContainer packet) {
        Iterator<UUID> iterator = this.packetSenders.iterator();
        while (iterator.hasNext()) {
            Player nextPlayer = plugin.getServer().getPlayer(iterator.next());
            if (nextPlayer == null) {
                iterator.remove();
                continue;
            }
            this.sendPacket(nextPlayer, packet);
        }
    }

    private void sendPacket(@NotNull Player player, @NotNull PacketContainer packet) {
        try {
            protocolManager.sendServerPacket(player, packet);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("An error occurred when sending a packet", e);
        }
    }

    @Override
    public boolean removeDupe() {
        return false;
    }

    @Override
    public void respawn() {
        Util.ensureThread(false);
        this.remove();
        this.spawn();
    }

    public void sendFakeItemToAll() {
        this.sendPacketToAll(this.fakeItemSpawnPacket);
        this.sendPacketToAll(this.fakeItemMetaPacket);
        this.sendPacketToAll(this.fakeItemVelocityPacket);
    }

    @Override
    public void safeGuard(@Nullable Entity entity) {
    }

    @Override
    public void spawn() {
        Util.ensureThread(false);
        if (this.shop.isLeftShop()) {
            return;
        }
        if (!this.initialized) {
            this.initFakeDropItemPacket();
        }
        if (this.shop.isDeleted() || !this.shop.isLoaded()) {
            return;
        }
        ShopDisplayItemSpawnEvent shopDisplayItemSpawnEvent = new ShopDisplayItemSpawnEvent(this.shop, this.originalItemStack, DisplayType.VIRTUALITEM);
        plugin.getServer().getPluginManager().callEvent((Event)shopDisplayItemSpawnEvent);
        if (shopDisplayItemSpawnEvent.isCancelled()) {
            Util.debugLog("Canceled the displayItem spawning because a plugin setCancelled the spawning event, usually this is a QuickShop Add on");
            return;
        }
        this.load();
        this.sendFakeItemToAll();
        this.isDisplay = true;
    }

    private void load() {
        Util.ensureThread(false);
        if (Util.isLoaded(this.shop.getLocation())) {
            Collection entityCollection = this.shop.getLocation().getWorld().getNearbyEntities(this.shop.getLocation(), (double)(plugin.getServer().getViewDistance() * 16), (double)this.shop.getLocation().getWorld().getMaxHeight(), (double)(plugin.getServer().getViewDistance() * 16));
            for (Entity entity : entityCollection) {
                if (!(entity instanceof Player)) continue;
                this.packetSenders.add(entity.getUniqueId());
            }
        }
        if (this.asyncPacketSenderTask != null) {
            this.asyncPacketSenderTask.stop();
            this.asyncPacketSenderTask = null;
        }
        this.asyncPacketSenderTask = AsyncPacketSender.create();
        this.asyncPacketSenderTask.start(plugin);
        if (this.packetAdapter == null) {
            this.packetAdapter = new PacketAdapter((Plugin)plugin, ListenerPriority.HIGH, new PacketType[]{PacketType.Play.Server.MAP_CHUNK}){

                public void onPacketSending(@NotNull PacketEvent event) {
                    boolean isFull;
                    Boolean boxedIsFull = (Boolean)event.getPacket().getBooleans().readSafely(0);
                    boolean bl = isFull = boxedIsFull == null || boxedIsFull != false;
                    if (!VirtualDisplayItem.this.shop.isLoaded() || !VirtualDisplayItem.this.isDisplay || !isFull || VirtualDisplayItem.this.shop.isLeftShop()) {
                        return;
                    }
                    Player player = event.getPlayer();
                    if (player instanceof TemporaryPlayer) {
                        return;
                    }
                    if (player == null || !player.isOnline()) {
                        return;
                    }
                    StructureModifier integerStructureModifier = event.getPacket().getIntegers();
                    int x = (Integer)integerStructureModifier.read(0);
                    int z = (Integer)integerStructureModifier.read(1);
                    VirtualDisplayItem.this.asyncPacketSenderTask.offer(() -> {
                        if (VirtualDisplayItem.this.chunkLocation == null) {
                            Chunk chunk;
                            World world = VirtualDisplayItem.this.shop.getLocation().getWorld();
                            try {
                                chunk = (Chunk)this.plugin.getServer().getScheduler().callSyncMethod(this.plugin, () -> VirtualDisplayItem.this.shop.getLocation().getChunk()).get();
                            }
                            catch (InterruptedException | ExecutionException e) {
                                throw new RuntimeException("An error occurred when getting chunk from the world", e);
                            }
                            VirtualDisplayItem.this.chunkLocation = new ShopChunk(world.getName(), chunk.getX(), chunk.getZ());
                        }
                        if (VirtualDisplayItem.this.chunkLocation.isSame(player.getWorld().getName(), x, z)) {
                            VirtualDisplayItem.this.packetSenders.add(player.getUniqueId());
                            VirtualDisplayItem.this.sendFakeItem(player);
                        }
                    });
                }
            };
        }
        protocolManager.addPacketListener((PacketListener)this.packetAdapter);
    }

    private void unload() {
        this.packetSenders.clear();
        if (this.packetAdapter != null) {
            protocolManager.removePacketListener((PacketListener)this.packetAdapter);
            this.packetAdapter = null;
        }
        if (this.asyncPacketSenderTask != null) {
            this.asyncPacketSenderTask.stop();
            this.asyncPacketSenderTask = null;
        }
    }

    public void sendFakeItem(@NotNull Player player) {
        this.sendPacket(player, this.fakeItemSpawnPacket);
        this.sendPacket(player, this.fakeItemMetaPacket);
        this.sendPacket(player, this.fakeItemVelocityPacket);
    }

    @Override
    @Nullable
    public Entity getDisplay() {
        return null;
    }

    @Override
    public boolean isSpawned() {
        Shop aShop;
        if (this.shop.isLeftShop() && (aShop = this.shop.getAttachedShop()) instanceof ContainerShop) {
            return Objects.requireNonNull(((ContainerShop)aShop).getDisplayItem()).isSpawned();
        }
        return this.isDisplay;
    }

    public static class PacketFactory {
        public static Throwable testFakeItem() {
            try {
                PacketFactory.createFakeItemSpawnPacket(0, new Location((World)DisplayItem.plugin.getServer().getWorlds().get(0), 0.0, 0.0, 0.0));
                PacketFactory.createFakeItemMetaPacket(0, new ItemStack(Material.values()[0]));
                PacketFactory.createFakeItemVelocityPacket(0);
                PacketFactory.createFakeItemDestroyPacket(0);
                return null;
            }
            catch (Throwable throwable) {
                return throwable;
            }
        }

        private static PacketContainer createFakeItemSpawnPacket(int entityID, Location displayLocation) {
            PacketContainer fakeItemPacket = protocolManager.createPacket(PacketType.Play.Server.SPAWN_ENTITY);
            fakeItemPacket.getIntegers().write(0, (Object)entityID).write(1, (Object)0).write(2, (Object)0).write(3, (Object)0).write(4, (Object)0).write(5, (Object)0);
            switch (version) {
                case v1_13_R1: 
                case v1_13_R2: {
                    fakeItemPacket.getIntegers().write(6, (Object)2).write(7, (Object)1);
                    break;
                }
                default: {
                    fakeItemPacket.getEntityTypeModifier().write(0, (Object)EntityType.DROPPED_ITEM);
                    fakeItemPacket.getIntegers().write(6, (Object)1);
                }
            }
            fakeItemPacket.getUUIDs().write(0, (Object)UUID.randomUUID());
            fakeItemPacket.getDoubles().write(0, (Object)displayLocation.getX()).write(1, (Object)displayLocation.getY()).write(2, (Object)displayLocation.getZ());
            return fakeItemPacket;
        }

        private static PacketContainer createFakeItemMetaPacket(int entityID, ItemStack itemStack) {
            PacketContainer fakeItemMetaPacket = protocolManager.createPacket(PacketType.Play.Server.ENTITY_METADATA);
            fakeItemMetaPacket.getIntegers().write(0, (Object)entityID);
            WrappedDataWatcher wpw = new WrappedDataWatcher();
            if (DisplayItem.plugin.getConfig().getBoolean("shop.display-item-use-name")) {
                String itemName = QuickShop.isTesting() ? itemStack.getType().name() : Util.getItemStackName(itemStack);
                wpw.setObject(2, WrappedDataWatcher.Registry.getChatComponentSerializer((boolean)true), Optional.of(WrappedChatComponent.fromText((String)itemName).getHandle()));
                wpw.setObject(new WrappedDataWatcher.WrappedDataWatcherObject(3, WrappedDataWatcher.Registry.get(Boolean.class)), (Object)true);
            }
            if (GameVersion.v1_17_R1.ordinal() > version.ordinal()) {
                if (version == GameVersion.v1_13_R1 || version == GameVersion.v1_13_R2) {
                    wpw.setObject(6, WrappedDataWatcher.Registry.getItemStackSerializer((boolean)false), (Object)itemStack);
                } else {
                    wpw.setObject(7, WrappedDataWatcher.Registry.getItemStackSerializer((boolean)false), (Object)itemStack);
                }
            } else {
                wpw.setObject(8, WrappedDataWatcher.Registry.getItemStackSerializer((boolean)false), (Object)itemStack);
            }
            fakeItemMetaPacket.getWatchableCollectionModifier().write(0, (Object)wpw.getWatchableObjects());
            return fakeItemMetaPacket;
        }

        private static PacketContainer createFakeItemVelocityPacket(int entityID) {
            PacketContainer fakeItemVelocityPacket = protocolManager.createPacket(PacketType.Play.Server.ENTITY_VELOCITY);
            fakeItemVelocityPacket.getIntegers().write(0, (Object)entityID).write(1, (Object)0).write(2, (Object)0).write(3, (Object)0);
            return fakeItemVelocityPacket;
        }

        private static PacketContainer createFakeItemDestroyPacket(int entityID) {
            PacketContainer fakeItemDestroyPacket = protocolManager.createPacket(PacketType.Play.Server.ENTITY_DESTROY);
            if (GameVersion.v1_17_R1.ordinal() > version.ordinal()) {
                fakeItemDestroyPacket.getIntegerArrays().write(0, (Object)new int[]{entityID});
            } else {
                MinecraftVersion minecraftVersion = protocolManager.getMinecraftVersion();
                if (minecraftVersion.getMajor() == 1 && minecraftVersion.getMinor() == 17 && minecraftVersion.getBuild() == 0) {
                    fakeItemDestroyPacket.getIntegers().write(0, (Object)entityID);
                } else {
                    try {
                        fakeItemDestroyPacket.getIntLists().write(0, Collections.singletonList(entityID));
                    }
                    catch (NoSuchMethodError e) {
                        throw new RuntimeException("Unable to initialize packet, ProtocolLib update needed", e);
                    }
                }
            }
            return fakeItemDestroyPacket;
        }
    }
}

