/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.DecimalFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import lombok.NonNull;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.EnderChest;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Chest;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.database.MySQLCore;
import org.maxgamer.quickshop.shade.io.papermc.lib.PaperLib;
import org.maxgamer.quickshop.shop.DisplayItem;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.util.InteractUtil;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.RomanNumber;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class Util {
    private static final EnumSet<Material> blacklist = EnumSet.noneOf(Material.class);
    private static final EnumMap<Material, Map.Entry<Double, Double>> restrictedPrices = new EnumMap(Material.class);
    private static final EnumMap<Material, Integer> customStackSize = new EnumMap(Material.class);
    private static final EnumSet<Material> shoppables = EnumSet.noneOf(Material.class);
    private static final List<BlockFace> verticalFacing = Collections.unmodifiableList(Arrays.asList(BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST));
    private static final List<String> debugLogs = new ArrayList<String>();
    private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final Map<String, String> currency2Symbol = new HashMap<String, String>();
    private static int bypassedCustomStackSize = -1;
    private static Yaml yaml = null;
    private static boolean devMode = false;
    private static QuickShop plugin;
    private static Object serverInstance;
    private static Field tpsField;
    private static List<String> worldBlacklist;
    private static boolean disableDebugLogger;
    @Nullable
    private static DyeColor dyeColor;
    private static boolean currencySymbolOnRight;
    private static String alternateCurrencySymbol;
    private static boolean disableVaultFormat;
    private static boolean useDecimalFormat;
    @Nullable
    private static Class<?> cachedNMSClass;

    @NotNull
    public static String array2String(@NotNull String[] strArray) {
        StringJoiner joiner = new StringJoiner(", ");
        for (String str : strArray) {
            joiner.add(str);
        }
        return joiner.toString();
    }

    @NotNull
    public static String boolean2Status(boolean bool) {
        if (bool) {
            return "Enabled";
        }
        return "Disabled";
    }

    public static boolean backupDatabase() {
        if (plugin.getDatabaseManager().getDatabase() instanceof MySQLCore) {
            return true;
        }
        File dataFolder = plugin.getDataFolder();
        File sqlfile = new File(dataFolder, "shops.db");
        if (!sqlfile.exists()) {
            plugin.getLogger().warning("Failed to backup! (File not found)");
            return false;
        }
        String uuid = UUID.randomUUID().toString().replaceAll("_", "");
        File bksqlfile = new File(dataFolder, "/shops_backup_" + uuid + ".db");
        try {
            Files.copy(sqlfile.toPath(), bksqlfile.toPath(), new CopyOption[0]);
        }
        catch (Exception e1) {
            plugin.getLogger().log(Level.WARNING, "Failed to backup the database", e1);
            return false;
        }
        return true;
    }

    public static boolean canBeShop(@NotNull Block b) {
        if (Util.isBlacklistWorld(b.getWorld())) {
            return false;
        }
        if (!Util.isShoppables(b.getType())) {
            return false;
        }
        BlockState bs = PaperLib.getBlockState(b, false).getState();
        if (bs instanceof EnderChest) {
            return plugin.getOpenInvPlugin() != null;
        }
        return bs instanceof InventoryHolder;
    }

    public static boolean isShoppables(@NotNull Material material) {
        return shoppables.contains(material);
    }

    public static boolean isBlacklistWorld(@NotNull World world) {
        return worldBlacklist.contains(world.getName());
    }

    public static int countItems(@Nullable Inventory inv, @NotNull ItemStack item) {
        if (inv == null) {
            return 0;
        }
        int items = 0;
        for (ItemStack iStack : inv.getStorageContents()) {
            if (iStack == null || iStack.getType() == Material.AIR || !plugin.getItemMatcher().matches(item, iStack)) continue;
            items += iStack.getAmount();
        }
        return items / item.getAmount();
    }

    public static int countSpace(@Nullable Inventory inv, @NotNull ItemStack item) {
        ItemStack[] contents;
        if (inv == null) {
            return 0;
        }
        int space = 0;
        int itemMaxStackSize = Util.getItemMaxStackSize(item.getType());
        for (ItemStack iStack : contents = inv.getStorageContents()) {
            if (iStack == null || iStack.getType() == Material.AIR) {
                space += itemMaxStackSize;
                continue;
            }
            if (!plugin.getItemMatcher().matches(item, iStack)) continue;
            space += iStack.getAmount() >= itemMaxStackSize ? 0 : itemMaxStackSize - iStack.getAmount();
        }
        return space / item.getAmount();
    }

    public static int getItemMaxStackSize(@NotNull Material material) {
        return customStackSize.getOrDefault(material, bypassedCustomStackSize == -1 ? material.getMaxStackSize() : bypassedCustomStackSize);
    }

    @Nullable
    public static ItemStack deserialize(@NotNull String config) throws InvalidConfigurationException {
        if (yaml == null) {
            DumperOptions yamlOptions = new DumperOptions();
            yamlOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            yamlOptions.setIndent(2);
            yaml = new Yaml(yamlOptions);
        }
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        Map root = (Map)yaml.load(config);
        Map item = (Map)root.get("item");
        int itemDataVersion = Integer.parseInt(String.valueOf(item.getOrDefault("v", "0")));
        try {
            if (itemDataVersion > Bukkit.getUnsafe().getDataVersion()) {
                Util.debugLog("WARNING: DataVersion not matched with ItemStack: " + config);
                if (plugin.getConfig().getBoolean("shop.force-load-downgrade-items.enable")) {
                    Util.debugLog("QuickShop is trying force loading " + config);
                    if (plugin.getConfig().getInt("shop.force-load-downgrade-items.method") == 0) {
                        item.put("v", Bukkit.getUnsafe().getDataVersion() - 1);
                    } else {
                        item.put("v", Bukkit.getUnsafe().getDataVersion());
                    }
                    root.put("item", item);
                    config = yaml.dump((Object)root);
                    Util.debugLog("Updated, we will try load as hacked ItemStack: " + config);
                } else {
                    plugin.getLogger().warning("Cannot load ItemStack " + config + " because it saved from higher Minecraft server version, the action will fail and you will receive a exception, PLELASE DON'T REPORT TO QUICKSHOP!");
                    plugin.getLogger().warning("You can try force load this ItemStack by our hacked ItemStack read util(shop.force-load-downgrade-items), but beware, the data may damaged if you load on this lower Minecraft server version, Please backup your world and database before enable!");
                }
            }
            yamlConfiguration.loadFromString(config);
            return yamlConfiguration.getItemStack("item");
        }
        catch (Exception e) {
            throw new InvalidConfigurationException("Exception in deserialize item", (Throwable)e);
        }
    }

    @NotNull
    public static List<String> getDebugLogs() {
        lock.readLock().lock();
        ArrayList<String> strings = new ArrayList<String>(debugLogs);
        lock.readLock().unlock();
        return strings;
    }

    public static void debugLog(String ... logs) {
        if (disableDebugLogger) {
            return;
        }
        lock.writeLock().lock();
        if (debugLogs.size() >= 2000) {
            debugLogs.clear();
        }
        if (!devMode) {
            for (String log : logs) {
                debugLogs.add("[DEBUG] " + log);
            }
            lock.writeLock().unlock();
            return;
        }
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
        String className = stackTraceElement.getClassName();
        String methodName = stackTraceElement.getMethodName();
        int codeLine = stackTraceElement.getLineNumber();
        for (String log : logs) {
            debugLogs.add("[DEBUG] [" + className + "] [" + methodName + "] (" + codeLine + ") " + log);
            QuickShop.getInstance().getLogger().info("[DEBUG] [" + className + "] [" + methodName + "] (" + codeLine + ") " + log);
        }
        lock.writeLock().unlock();
    }

    @NotNull
    public static String format(double n, @Nullable Shop shop) {
        if (shop == null) {
            return "Error: Shop null";
        }
        return Util.format(n, disableVaultFormat, shop.getLocation().getWorld(), shop);
    }

    @NotNull
    public static String format(double n, boolean internalFormat, @NotNull World world, @Nullable Shop shop) {
        if (shop != null) {
            return Util.format(n, internalFormat, world, shop.getCurrency());
        }
        return Util.format(n, internalFormat, world, (Shop)null);
    }

    @NotNull
    public static String format(double n, boolean internalFormat, @NotNull World world, @Nullable String currency) {
        if (internalFormat) {
            return Util.getInternalFormat(n, currency);
        }
        if (plugin == null) {
            Util.debugLog("Called format before Plugin booted up, forcing fixing.");
            plugin = QuickShop.getInstance();
        }
        if (plugin.getEconomy() == null) {
            Util.debugLog("Called format before Economy booted up, using built-in formatter.");
            return Util.getInternalFormat(n, currency);
        }
        try {
            String formatted = plugin.getEconomy().format(n, world, currency);
            if (StringUtils.isEmpty((String)formatted)) {
                Util.debugLog("Use alternate-currency-symbol to formatting, Cause economy plugin returned null");
                return Util.getInternalFormat(n, currency);
            }
            return formatted;
        }
        catch (NumberFormatException e) {
            Util.debugLog("format", e.getMessage());
            Util.debugLog("format", "Use alternate-currency-symbol to formatting, Cause NumberFormatException");
            return Util.getInternalFormat(n, currency);
        }
    }

    private static String getInternalFormat(double amount, @Nullable String currency) {
        if (StringUtils.isEmpty((String)currency)) {
            Util.debugLog("Format: Currency is null");
            String formatted = useDecimalFormat ? MsgUtil.decimalFormat(amount) : Double.toString(amount);
            return currencySymbolOnRight ? formatted + alternateCurrencySymbol : alternateCurrencySymbol + formatted;
        }
        Util.debugLog("Format: Currency is: [" + currency + "]");
        String formatted = useDecimalFormat ? MsgUtil.decimalFormat(amount) : Double.toString(amount);
        String symbol = currency2Symbol.getOrDefault(currency, currency);
        return currencySymbolOnRight ? formatted + symbol : symbol + formatted;
    }

    @NotNull
    public static BlockFace getRightSide(@NonNull BlockFace blockFace) {
        if (blockFace == null) {
            throw new NullPointerException("blockFace is marked non-null but is null");
        }
        switch (blockFace) {
            case EAST: {
                return BlockFace.SOUTH;
            }
            case NORTH: {
                return BlockFace.EAST;
            }
            case SOUTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.NORTH;
            }
        }
        return blockFace;
    }

    @NotNull
    public static List<BlockFace> getVerticalFacing() {
        return verticalFacing;
    }

    @Nullable
    public static Block getAttached(@NotNull Block b) {
        BlockData blockData = b.getBlockData();
        if (blockData instanceof Directional) {
            Directional directional = (Directional)blockData;
            return b.getRelative(directional.getFacing().getOppositeFace());
        }
        return null;
    }

    @NotNull
    public static String getClassPrefix(@NotNull Class<?> c) {
        String callClassName = Thread.currentThread().getStackTrace()[2].getClassName();
        String customClassName = c.getSimpleName();
        return "[" + callClassName + "-" + customClassName + "] ";
    }

    public static boolean useEnchantmentForEnchantedBook() {
        return plugin.getConfig().getBoolean("shop.use-enchantment-for-enchanted-book");
    }

    @NotNull
    public static String getItemStackName(@NotNull ItemStack itemStack) {
        ItemMeta meta;
        if (Util.useEnchantmentForEnchantedBook() && itemStack.getType() == Material.ENCHANTED_BOOK && (meta = itemStack.getItemMeta()) instanceof EnchantmentStorageMeta && ((EnchantmentStorageMeta)meta).hasStoredEnchants()) {
            return Util.getFirstEnchantmentName((EnchantmentStorageMeta)meta);
        }
        if (itemStack.hasItemMeta() && Objects.requireNonNull(itemStack.getItemMeta()).hasDisplayName() && !QuickShop.getInstance().getConfig().getBoolean("shop.force-use-item-original-name")) {
            return itemStack.getItemMeta().getDisplayName();
        }
        return MsgUtil.getItemi18n(itemStack.getType().name());
    }

    @NotNull
    public static String getFirstEnchantmentName(@NotNull EnchantmentStorageMeta meta) {
        if (!meta.hasStoredEnchants()) {
            throw new IllegalArgumentException("Item does not have an enchantment!");
        }
        Map.Entry entry = meta.getStoredEnchants().entrySet().iterator().next();
        String name = MsgUtil.getEnchi18n((Enchantment)entry.getKey());
        if ((Integer)entry.getValue() == 1 && ((Enchantment)entry.getKey()).getMaxLevel() == 1) {
            return name;
        }
        return name + " " + RomanNumber.toRoman((Integer)entry.getValue());
    }

    @Nullable
    public static String getLocalizedName(@NotNull ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        if (!itemMeta.hasLocalizedName()) {
            return null;
        }
        return itemMeta.getLocalizedName();
    }

    @Nullable
    public static Map.Entry<Double, Double> getPriceRestriction(@NotNull Material material) {
        return restrictedPrices.get(material);
    }

    public static boolean isDoubleChest(@Nullable BlockData blockData) {
        if (!(blockData instanceof Chest)) {
            return false;
        }
        Chest chestBlockData = (Chest)blockData;
        return chestBlockData.getType() != Chest.Type.SINGLE;
    }

    public static int getShopsInWorld(@NotNull String worldName) {
        int cost = 0;
        Iterator<Shop> iterator = plugin.getShopManager().getShopIterator();
        while (iterator.hasNext()) {
            Shop shop = iterator.next();
            if (!Objects.requireNonNull(shop.getLocation().getWorld()).getName().equals(worldName)) continue;
            ++cost;
        }
        return cost;
    }

    @NotNull
    public static String getToolPercentage(@NotNull ItemStack item) {
        if (!(item.getItemMeta() instanceof Damageable)) {
            Util.debugLog(item.getType().name() + " not Damageable.");
            return "Error: NaN";
        }
        double dura = ((Damageable)item.getItemMeta()).getDamage();
        double max = item.getType().getMaxDurability();
        DecimalFormat formatter = new DecimalFormat("0");
        return formatter.format((1.0 - dura / max) * 100.0);
    }

    @Deprecated
    @NotNull
    public static BlockFace getYawFace(float yaw) {
        if (yaw > 315.0f && yaw <= 45.0f) {
            return BlockFace.NORTH;
        }
        if (yaw > 45.0f && yaw <= 135.0f) {
            return BlockFace.EAST;
        }
        if (yaw > 135.0f && yaw <= 225.0f) {
            return BlockFace.SOUTH;
        }
        return BlockFace.WEST;
    }

    public static void initialize() {
        Material mat;
        blacklist.clear();
        shoppables.clear();
        restrictedPrices.clear();
        worldBlacklist.clear();
        customStackSize.clear();
        currency2Symbol.clear();
        plugin = QuickShop.getInstance();
        devMode = plugin.getConfig().getBoolean("dev-mode");
        for (Object s : plugin.getConfig().getStringList("shop-blocks")) {
            Material mat2 = Material.matchMaterial((String)((String)s).toUpperCase());
            if (mat2 == null) {
                mat2 = Material.matchMaterial((String)s);
            }
            if (mat2 == null) {
                plugin.getLogger().warning("Invalid shop-block: " + s);
                continue;
            }
            shoppables.add(mat2);
        }
        List configBlacklist = plugin.getConfig().getStringList("blacklist");
        for (String s : configBlacklist) {
            Material mat3 = Material.getMaterial((String)s.toUpperCase());
            if (mat3 == null) {
                mat3 = Material.matchMaterial((String)s);
            }
            if (mat3 == null) {
                plugin.getLogger().warning(s + " is not a valid material.  Check your spelling or ID");
                continue;
            }
            blacklist.add(mat3);
        }
        for (String s : plugin.getConfig().getStringList("shop.price-restriction")) {
            String[] sp = s.split(";");
            if (sp.length != 3) continue;
            try {
                mat = Material.matchMaterial((String)sp[0]);
                if (mat == null) {
                    plugin.getLogger().warning("Material " + sp[0] + " in config.yml can't match with a valid Materials, check your config.yml!");
                    continue;
                }
                restrictedPrices.put(mat, new AbstractMap.SimpleEntry<Double, Double>(Double.valueOf(sp[1]), Double.valueOf(sp[2])));
            }
            catch (Exception e) {
                plugin.getLogger().warning("Invalid price restricted material: " + s);
            }
        }
        for (String material : plugin.getConfig().getStringList("custom-item-stacksize")) {
            String[] data = material.split(":");
            if (data.length != 2) continue;
            if ("*".equalsIgnoreCase(data[0])) {
                bypassedCustomStackSize = Integer.parseInt(data[1]);
            }
            if ((mat = Material.matchMaterial((String)data[0])) == null || mat == Material.AIR) {
                plugin.getLogger().warning(material + " not a valid material type in custom-item-stacksize section.");
                continue;
            }
            customStackSize.put(mat, Integer.parseInt(data[1]));
        }
        worldBlacklist = plugin.getConfig().getStringList("shop.blacklist-world");
        disableDebugLogger = plugin.getConfig().getBoolean("debug.disable-debuglogger", false);
        try {
            dyeColor = DyeColor.valueOf((String)plugin.getConfig().getString("shop.sign-dye-color"));
        }
        catch (Exception s) {
            // empty catch block
        }
        currencySymbolOnRight = plugin.getConfig().getBoolean("shop.currency-symbol-on-right", false);
        alternateCurrencySymbol = plugin.getConfig().getString("shop.alternate-currency-symbol", "$");
        disableVaultFormat = plugin.getConfig().getBoolean("shop.disable-vault-format", false);
        useDecimalFormat = plugin.getConfig().getBoolean("use-decimal-format", false);
        List symbols = plugin.getConfig().getStringList("shop.alternate-currency-symbol-list");
        symbols.forEach(entry -> {
            String[] splits = entry.split(";", 2);
            if (splits.length < 2) {
                plugin.getLogger().warning("Invalid entry in alternate-currency-symbol-list: " + entry);
            }
            currency2Symbol.put(splits[0], splits[1]);
        });
        InteractUtil.init((ConfigurationSection)plugin.getConfig());
    }

    public static byte[] inputStream2ByteArray(@NotNull String filePath) {
        byte[] byArray;
        FileInputStream in = new FileInputStream(filePath);
        try {
            byArray = Util.toByteArray(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        ((InputStream)in).close();
        return byArray;
    }

    private static byte[] toByteArray(@NotNull InputStream in) throws IOException {
        int n;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((n = in.read(buffer)) != -1) {
            out.write(buffer, 0, n);
        }
        return out.toByteArray();
    }

    public static byte[] inputStream2ByteArray(@NotNull InputStream inputStream) {
        try {
            byte[] data = Util.toByteArray(inputStream);
            inputStream.close();
            return data;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void inventoryCheck(@Nullable Inventory inv) {
        if (inv == null) {
            return;
        }
        if (inv.getHolder() == null) {
            Util.debugLog("Skipped plugin gui inventory check.");
            return;
        }
        try {
            for (int i = 0; i < inv.getSize(); ++i) {
                ItemStack itemStack = inv.getItem(i);
                if (itemStack == null || !DisplayItem.checkIsGuardItemStack(itemStack)) continue;
                Location location = inv.getLocation();
                if (location == null) {
                    return;
                }
                inv.setItem(i, new ItemStack(Material.AIR));
                Util.debugLog("Found shop display item in an inventory, Removing...");
                MsgUtil.sendGlobalAlert("[InventoryCheck] Found displayItem in inventory at " + location + ", Item is " + itemStack.getType().name());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isBlacklisted(@NotNull ItemStack stack) {
        if (blacklist.contains(stack.getType())) {
            return true;
        }
        if (!stack.hasItemMeta()) {
            return false;
        }
        if (!Objects.requireNonNull(stack.getItemMeta()).hasLore()) {
            return false;
        }
        for (String lore : Objects.requireNonNull(stack.getItemMeta().getLore())) {
            List blacklistLores = plugin.getConfig().getStringList("shop.blacklist-lores");
            for (String blacklistLore : blacklistLores) {
                if (!lore.contains(blacklistLore)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isClassAvailable(@NotNull String qualifiedName) {
        try {
            Class.forName(qualifiedName);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isMethodAvailable(@NotNull String className, String method, Class<?> ... args) {
        try {
            Class<?> clazz = Class.forName(className);
            try {
                clazz.getDeclaredMethod(method, args);
            }
            catch (NoSuchMethodException e) {
                clazz.getMethod(method, args);
            }
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean isDisplayAllowBlock(@NotNull Material mat) {
        return mat.isTransparent();
    }

    public static boolean isAir(@NotNull Material mat) {
        if (mat == Material.AIR) {
            return true;
        }
        try {
            if (mat == Material.CAVE_AIR) {
                return true;
            }
            if (mat == Material.VOID_AIR) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isWallSign(@Nullable Material material) {
        if (material == null) {
            return false;
        }
        try {
            return Tag.WALL_SIGNS.isTagged((Keyed)material);
        }
        catch (NoSuchFieldError e) {
            return "WALL_SIGN".equals(material.name());
        }
    }

    public static boolean isWorldLoaded(Location loc) {
        return Util.getNMSVersion().contains("1_13") && loc.getWorld() != null || loc.isWorldLoaded();
    }

    public static boolean isLoaded(@NotNull Location loc) {
        if (!Util.isWorldLoaded(loc)) {
            return false;
        }
        int x = (int)Math.floor((double)loc.getBlockX() / 16.0);
        int z = (int)Math.floor((double)loc.getBlockZ() / 16.0);
        return loc.getWorld().isChunkLoaded(x, z);
    }

    public static boolean isOtherShopWithinHopperReach(@NotNull Block b, @NotNull Player p) {
        Block bshop = Util.getAttached(b);
        if (bshop == null) {
            return false;
        }
        Shop shop = plugin.getShopManager().getShopIncludeAttached(bshop.getLocation());
        if (shop == null) {
            shop = plugin.getShopManager().getShopIncludeAttached(bshop.getLocation().clone().add(0.0, 1.0, 0.0));
        }
        return shop != null && !shop.getModerator().isModerator(p.getUniqueId());
    }

    public static Block getSecondHalf(@NotNull Block block) {
        BlockData blockData = block.getBlockData();
        if (!(blockData instanceof Chest)) {
            return null;
        }
        Chest chest = (Chest)blockData;
        if (!Util.isDoubleChest((BlockData)chest)) {
            return null;
        }
        BlockFace towardsLeft = Util.getRightSide(chest.getFacing());
        BlockFace actuallyBlockFace = chest.getType() == Chest.Type.LEFT ? towardsLeft : towardsLeft.getOppositeFace();
        return block.getRelative(actuallyBlockFace);
    }

    private static boolean equalsBlockStateLocation(@NotNull Location b1, @NotNull Location b2) {
        return b1.getBlockX() == b2.getBlockX() && b1.getBlockY() == b2.getBlockY() && b1.getBlockZ() == b2.getBlockZ();
    }

    public static boolean isTool(@NotNull Material mat) {
        return mat.getMaxDurability() != 0;
    }

    public static boolean isUUID(@NotNull String string) {
        int length = string.length();
        if (length != 36 && length != 32) {
            return false;
        }
        String[] components = string.split("-");
        return components.length == 5;
    }

    @NotNull
    public static String list2String(@NotNull List<String> strList) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strList.size(); ++i) {
            builder.append(strList.get(i));
            if (i + 1 == strList.size()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    @NotNull
    public static Location lookAt(@NotNull Location loc, @NotNull Location lookat) {
        loc = loc.clone();
        double dx = lookat.getX() - loc.getX();
        double dy = lookat.getY() - loc.getY();
        double dz = lookat.getZ() - loc.getZ();
        if (dx != 0.0) {
            if (dx < 0.0) {
                loc.setYaw(4.712389f);
            } else {
                loc.setYaw(1.5707964f);
            }
            loc.setYaw(loc.getYaw() - (float)Math.atan(dz / dx));
        } else if (dz < 0.0) {
            loc.setYaw((float)Math.PI);
        }
        double dxz = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dz, 2.0));
        float pitch = (float)(-Math.atan(dy / dxz));
        loc.setYaw(-loc.getYaw() * 180.0f / (float)Math.PI + 360.0f);
        loc.setPitch(pitch * 180.0f / (float)Math.PI);
        return loc;
    }

    @Deprecated
    public static boolean listMatches(@NotNull List<?> list1, @NotNull List<?> list2) {
        return list2.containsAll(list1);
    }

    public static void parseColours(@NotNull YamlConfiguration config) {
        Set keys = config.getKeys(true);
        for (String key : keys) {
            String filtered = config.getString(key);
            if (filtered == null || filtered.startsWith("MemorySection")) continue;
            filtered = Util.parseColours(filtered);
            config.set(key, (Object)filtered);
        }
    }

    @NotNull
    public static String parseColours(@Nullable String text) {
        if (StringUtils.isEmpty((String)text)) {
            return "";
        }
        text = ChatColor.translateAlternateColorCodes((char)'&', (String)text);
        return text;
    }

    @NotNull
    public static List<String> parseColours(@NotNull List<String> list) {
        ArrayList<String> newList = new ArrayList<String>();
        for (String s : list) {
            newList.add(Util.parseColours(s));
        }
        return newList;
    }

    @NotNull
    public static String prettifyText(@NotNull String ugly) {
        String[] nameParts = ugly.split("_");
        if (nameParts.length == 1) {
            return Util.firstUppercase(ugly);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nameParts.length; ++i) {
            if (!nameParts[i].isEmpty()) {
                sb.append(Character.toUpperCase(nameParts[i].charAt(0))).append(nameParts[i].substring(1).toLowerCase());
            }
            if (i + 1 == nameParts.length) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    @NotNull
    public static String firstUppercase(@NotNull String string) {
        if (string.length() > 1) {
            return Character.toUpperCase(string.charAt(0)) + string.substring(1).toLowerCase();
        }
        return string.toUpperCase();
    }

    @NotNull
    public static String readToString(@NotNull String fileName) {
        File file = new File(fileName);
        return Util.readToString(file);
    }

    @NotNull
    public static String readToString(@NotNull File file) {
        byte[] filecontent = new byte[(int)file.length()];
        try (FileInputStream in = new FileInputStream(file);){
            in.read(filecontent);
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.WARNING, "Failed to read file: " + file, e);
        }
        return new String(filecontent, StandardCharsets.UTF_8);
    }

    @NotNull
    public static String serialize(@NotNull ItemStack iStack) {
        YamlConfiguration cfg = new YamlConfiguration();
        cfg.set("item", (Object)iStack);
        return cfg.saveToString();
    }

    @NotNull
    public static String getClassPrefix() {
        String className = Thread.currentThread().getStackTrace()[2].getClassName();
        try {
            Class<?> c = Class.forName(className);
            className = c.getSimpleName();
            if (!c.getSimpleName().isEmpty()) {
                className = c.getSimpleName();
            }
        }
        catch (ClassNotFoundException c) {
            // empty catch block
        }
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        return "[" + className + "-" + methodName + "] ";
    }

    @NotNull
    public static String getNMSVersion() {
        String name = Bukkit.getServer().getClass().getPackage().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    @NotNull
    public static Material getSignMaterial() {
        Material signMaterial = Material.matchMaterial((String)Objects.requireNonNull(plugin.getConfig().getString("shop.sign-material")));
        if (signMaterial != null) {
            return signMaterial;
        }
        signMaterial = Material.matchMaterial((String)"OAK_WALL_SIGN");
        if (signMaterial != null) {
            return signMaterial;
        }
        signMaterial = Material.matchMaterial((String)"WALL_SIGN");
        if (signMaterial != null) {
            return signMaterial;
        }
        plugin.getLogger().warning("QuickShop can't found any usable sign material, we will use default Sign Material.");
        try {
            return Material.OAK_WALL_SIGN;
        }
        catch (Exception e) {
            return Material.matchMaterial((String)"WALL_SIGN");
        }
    }

    @NotNull
    public static Double getTPS() {
        if (serverInstance == null || tpsField == null) {
            try {
                serverInstance = Util.getNMSClass("MinecraftServer").getMethod("getServer", new Class[0]).invoke(null, new Object[0]);
                tpsField = serverInstance.getClass().getField("recentTps");
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                plugin.getLogger().log(Level.WARNING, "Failed to getting server TPS, please report to QuickShop.", e);
                serverInstance = null;
                tpsField = null;
                Util.debugLog("Failed to get TPS " + e.getMessage());
                return 20.0;
            }
        }
        try {
            double[] tps = (double[])tpsField.get(serverInstance);
            return tps[0];
        }
        catch (IllegalAccessException ignored) {
            return 20.0;
        }
    }

    public static void makeExportBackup(@Nullable String backupName) {
        File file = StringUtils.isEmpty((String)backupName) ? new File(plugin.getDataFolder(), "export.txt") : new File(plugin.getDataFolder(), backupName + ".txt");
        if (file.exists()) {
            Files.move(file.toPath(), new File(file.getParentFile(), file.getName() + UUID.randomUUID().toString().replace("-", "")).toPath(), new CopyOption[0]);
        }
        file.createNewFile();
        plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            StringBuilder finalReport = new StringBuilder();
            plugin.getShopLoader().getOriginShopsInDatabase().forEach(shop -> finalReport.append(shop).append("\n"));
            try (BufferedWriter outputStream = new BufferedWriter(new FileWriter(file, false));){
                outputStream.write(finalReport.toString());
            }
            catch (IOException exception) {
                plugin.getLogger().log(Level.WARNING, "Backup failed", exception);
            }
        });
    }

    @NotNull
    public static Class<?> getNMSClass(@Nullable String className) {
        if (cachedNMSClass != null) {
            return cachedNMSClass;
        }
        if (className == null) {
            className = "MinecraftServer";
        }
        String name = Bukkit.getServer().getClass().getPackage().getName();
        String version = name.substring(name.lastIndexOf(46) + 1);
        try {
            cachedNMSClass = Class.forName("net.minecraft.server." + version + "." + className);
            return cachedNMSClass;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isDevEdition() {
        return !"release".equalsIgnoreCase(QuickShop.getInstance().getBuildInfo().getGitBranch());
    }

    public static List<String> getStartupFlags() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments();
    }

    public static boolean isDevMode() {
        return devMode;
    }

    public static boolean isDyes(@NotNull Material material) {
        return material.name().toUpperCase().endsWith("_DYE");
    }

    public static boolean fireCancellableEvent(@NotNull Cancellable event) {
        if (!(event instanceof Event)) {
            throw new IllegalArgumentException("Cancellable must is event implement");
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        return event.isCancelled();
    }

    public static File getCacheFolder() {
        File cache = new File(QuickShop.getInstance().getDataFolder(), "cache");
        if (!cache.exists()) {
            cache.mkdirs();
        }
        return cache;
    }

    @NotNull
    public static List<String> getPlayerList() {
        ArrayList<String> tabList = new ArrayList<String>();
        if (plugin.getConfig().getBoolean("include-offlineplayer-list")) {
            for (OfflinePlayer offlinePlayer : plugin.getServer().getOfflinePlayers()) {
                tabList.add(offlinePlayer.getName());
            }
        } else {
            for (OfflinePlayer offlinePlayer : plugin.getServer().getOnlinePlayers()) {
                tabList.add(offlinePlayer.getName());
            }
        }
        return tabList;
    }

    @NotNull
    public static String mergeArgs(@NotNull String[] args) {
        StringBuilder builder = new StringBuilder();
        for (String arg : args) {
            builder.append(arg).append(" ");
        }
        return builder.toString().trim();
    }

    public static void ensureThread(boolean async) {
        boolean isMainThread = Bukkit.isPrimaryThread();
        if (async) {
            if (isMainThread) {
                throw new IllegalStateException("#[Illegal Access] This method require runs on async thread.");
            }
        } else if (!isMainThread) {
            throw new IllegalStateException("#[Illegal Access] This method require runs on server main thread.");
        }
    }

    public static void mainThreadRun(@NotNull Runnable runnable) {
        if (Bukkit.isPrimaryThread()) {
            runnable.run();
        } else {
            Bukkit.getScheduler().runTask((Plugin)QuickShop.getInstance(), runnable);
        }
    }

    public static Map<String, String> getCurrency2Symbol() {
        return currency2Symbol;
    }

    public static boolean isDisableDebugLogger() {
        return disableDebugLogger;
    }

    @Nullable
    public static DyeColor getDyeColor() {
        return dyeColor;
    }

    static {
        worldBlacklist = new ArrayList<String>(5);
        disableDebugLogger = false;
        dyeColor = null;
        cachedNMSClass = null;
    }
}

