/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.util.collector;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.util.collector.CollectResolver;
import org.maxgamer.quickshop.util.collector.CollectType;
import org.maxgamer.quickshop.util.collector.adapter.CollectorAdapter;

public class Collector {
    private CollectorAdapter adapter = new CollectorAdapter();
    private Map<CollectType, Map<?, ?>> collectInformation = new LinkedHashMap();

    public Collector(@NotNull QuickShop plugin) {
        for (CollectType value : CollectType.values()) {
            this.collectInformation.put(value, this.bake(value, plugin));
        }
    }

    @NotNull
    private Map<?, ?> bake(@NotNull CollectType field, @NotNull QuickShop plugin) {
        for (Method declaredMethod : this.adapter.getClass().getDeclaredMethods()) {
            CollectResolver resolver = declaredMethod.getAnnotation(CollectResolver.class);
            if (resolver == null || !resolver.field().equals((Object)field)) continue;
            try {
                HashMap map = (HashMap)declaredMethod.invoke((Object)this.adapter, new Object[]{plugin});
                if (map == null) {
                    map = new HashMap();
                }
                return map;
            }
            catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                plugin.getLogger().log(Level.WARNING, "Failed to resolve the field " + (Object)((Object)field) + " when collecting data. Please report to author.", e);
            }
        }
        return new HashMap();
    }

    public CollectorAdapter getAdapter() {
        return this.adapter;
    }

    public Map<CollectType, Map<?, ?>> getCollectInformation() {
        return this.collectInformation;
    }

    public void setAdapter(CollectorAdapter adapter) {
        this.adapter = adapter;
    }

    public void setCollectInformation(Map<CollectType, Map<?, ?>> collectInformation) {
        this.collectInformation = collectInformation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Collector)) {
            return false;
        }
        Collector other = (Collector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CollectorAdapter this$adapter = this.getAdapter();
        CollectorAdapter other$adapter = other.getAdapter();
        if (this$adapter == null ? other$adapter != null : !this$adapter.equals(other$adapter)) {
            return false;
        }
        Map<CollectType, Map<?, ?>> this$collectInformation = this.getCollectInformation();
        Map<CollectType, Map<?, ?>> other$collectInformation = other.getCollectInformation();
        return !(this$collectInformation == null ? other$collectInformation != null : !((Object)this$collectInformation).equals(other$collectInformation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Collector;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CollectorAdapter $adapter = this.getAdapter();
        result = result * 59 + ($adapter == null ? 43 : $adapter.hashCode());
        Map<CollectType, Map<?, ?>> $collectInformation = this.getCollectInformation();
        result = result * 59 + ($collectInformation == null ? 43 : ((Object)$collectInformation).hashCode());
        return result;
    }

    public String toString() {
        return "Collector(adapter=" + this.getAdapter() + ", collectInformation=" + this.getCollectInformation() + ")";
    }
}

