/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.util.collector.adapter;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Item;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.economy.Economy;
import org.maxgamer.quickshop.economy.EconomyCore;
import org.maxgamer.quickshop.economy.Economy_Vault;
import org.maxgamer.quickshop.shop.ShopLoader;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;
import org.maxgamer.quickshop.util.collector.CollectResolver;
import org.maxgamer.quickshop.util.collector.CollectType;

public class CollectorAdapter {
    @CollectResolver(field=CollectType.QUICKSHOP)
    public Map<?, ?> collectQuickShop(@NotNull QuickShop plugin) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("version", QuickShop.getVersion());
        data.put("fork", QuickShop.getFork());
        data.put("build_info", plugin.getBuildInfo());
        data.put("server_id", plugin.getServerUniqueID());
        data.put("openinv_hook", plugin.getOpenInvPlugin() == null ? "Disabled" : "Enabled");
        HashMap<String, String> economy = new HashMap<String, String>();
        try {
            EconomyCore economyCore = plugin.getEconomy().getCore();
            switch (Economy.getNowUsing()) {
                case VAULT: {
                    economy.put("core", "Vault");
                    economy.put("provider", ((Economy_Vault)economyCore).getProviderName());
                    break;
                }
                default: {
                    economy.put("core", economyCore.getName());
                    economy.put("provider", economyCore.getPlugin().getName());
                    break;
                }
            }
        }
        catch (Exception e) {
            economy.put("core", "Unknown");
            economy.put("provider", "Error to getting data: " + e.getMessage());
        }
        data.put("economy", economy);
        return data;
    }

    @CollectResolver(field=CollectType.SYSTEM)
    public Map<?, ?> collectSystem(@NotNull QuickShop plugin) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("os_name", System.getProperty("os.name"));
        data.put("os_arch", System.getProperty("os.arch"));
        data.put("os_version", System.getProperty("os.version"));
        data.put("os_cores", Runtime.getRuntime().availableProcessors());
        data.put("vm_version", System.getProperty("java.version"));
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        data.put("vm_name", runtimeMxBean.getName());
        List<String> arguments = runtimeMxBean.getInputArguments();
        data.put("vm_arguments", Util.list2String(arguments));
        data.put("vm_classpath", runtimeMxBean.getClassPath());
        data.put("vm_uptime", runtimeMxBean.getUptime());
        return data;
    }

    @CollectResolver(field=CollectType.PLATFORM)
    public Map<?, ?> collectPlatform(@NotNull QuickShop plugin) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("name", plugin.getServer().getName());
        data.put("software", plugin.getServer().getVersion());
        data.put("version", plugin.getServer().getVersion());
        data.put("version_internal", Util.getNMSVersion());
        data.put("version_data", plugin.getServer().getUnsafe().getDataVersion());
        data.put("online_mode", plugin.getServer().getOnlineMode());
        data.put("view_distance", plugin.getServer().getViewDistance());
        data.put("primary_thread_call", plugin.getServer().isPrimaryThread());
        data.put("online", plugin.getServer().getOnlinePlayers().size());
        data.put("total", plugin.getServer().getOfflinePlayers().length);
        return data;
    }

    @CollectResolver(field=CollectType.MODULES)
    public Map<?, ?> collectModules(@NotNull QuickShop plugin) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("item_matcher", plugin.getItemMatcher().getName() + "@" + plugin.getItemMatcher().getPlugin().getName());
        if (plugin.getEconomy() == null) {
            data.put("economy_core", "Not loaded@Unknown");
        } else {
            data.put("economy_core", plugin.getEconomy().getCore().getName() + "@" + plugin.getEconomy().getCore().getPlugin().getName());
        }
        data.put("database_core", plugin.getDatabaseManager().getDatabase().getName() + "@" + plugin.getDatabaseManager().getDatabase().getPlugin().getName());
        data.put("gamelanguage_processor", MsgUtil.gameLanguage.getName() + "@" + MsgUtil.gameLanguage.getPlugin().getName());
        return data;
    }

    @CollectResolver(field=CollectType.SERVICES)
    public Map<?, ?> collectServices(@NotNull QuickShop plugin) {
        HashMap data = new HashMap();
        ArrayList content = new ArrayList();
        plugin.getServer().getServicesManager().getRegistrations((Plugin)plugin).forEach(service -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("plugin", service.getPlugin().getName());
            map.put("priority", (String)service.getPriority());
            map.put("provider", service.getProvider().getClass().getCanonicalName());
            map.put("service", service.getService().getCanonicalName());
            content.add(map);
        });
        data.put("enabled", content);
        return data;
    }

    @CollectResolver(field=CollectType.SHOPS_IN_WORLD)
    public Map<?, ?> collectShopsInWorld(@NotNull QuickShop plugin) {
        HashMap data = new HashMap();
        plugin.getServer().getWorlds().forEach(world -> {
            HashMap<String, Object> perWorld = new HashMap<String, Object>();
            perWorld.put("uid", world.getUID());
            perWorld.put("players", world.getPlayers().size());
            perWorld.put("shops", Util.getShopsInWorld(world.getName()));
            perWorld.put("environment", world.getEnvironment());
            perWorld.put("entities", world.getEntities());
            perWorld.put("view_distance", world.getViewDistance());
            perWorld.put("items", world.getEntities().stream().filter(entity -> entity instanceof Item).count());
            perWorld.put("armor_stands", world.getEntities().stream().filter(entity -> entity instanceof ArmorStand).toArray().length);
            perWorld.put("force_loaded_chunks", world.getForceLoadedChunks().size());
            perWorld.put("shops_in_force_loaded_chunks", plugin.getShopManager().getShopsInWorld((World)world).stream().filter(shop -> world.getForceLoadedChunks().contains(shop.getLocation().getChunk())).toArray().length);
            perWorld.put("max_height", world.getMaxHeight());
            perWorld.put("sea_level", world.getSeaLevel());
            data.put(world.getName(), perWorld);
        });
        return data;
    }

    @CollectResolver(field=CollectType.PLUGINS)
    public Map<?, ?> collectPlugins(@NotNull QuickShop plugin) {
        HashMap data = new HashMap();
        Arrays.stream(plugin.getServer().getPluginManager().getPlugins()).forEach(pl -> {
            HashMap<String, Object> perPlugin = new HashMap<String, Object>();
            perPlugin.put("data_folder", pl.getDataFolder());
            perPlugin.put("api_version", pl.getDescription().getAPIVersion());
            perPlugin.put("authors", Util.list2String(pl.getDescription().getAuthors()));
            perPlugin.put("contributors", Util.list2String(pl.getDescription().getContributors()));
            perPlugin.put("depend", Util.list2String(pl.getDescription().getDepend()));
            perPlugin.put("soft_depend", Util.list2String(pl.getDescription().getSoftDepend()));
            perPlugin.put("is_addon", pl.getDescription().getDepend().contains("QuickShop") || pl.getDescription().getSoftDepend().contains("QuickShop"));
            perPlugin.put("description", pl.getDescription().getDescription());
            perPlugin.put("full_name", pl.getDescription().getFullName());
            perPlugin.put("load", pl.getDescription().getLoad().name());
            perPlugin.put("load_before", pl.getDescription().getLoadBefore());
            perPlugin.put("main", pl.getDescription().getMain());
            perPlugin.put("version", pl.getDescription().getVersion());
            perPlugin.put("website", pl.getDescription().getWebsite());
            data.put(pl.getName(), perPlugin);
        });
        return data;
    }

    @CollectResolver(field=CollectType.CONFIG)
    public Map<?, ?> collectConfig(@NotNull QuickShop plugin) {
        return null;
    }

    @CollectResolver(field=CollectType.SERVER_CONFIG)
    public Map<?, ?> collectServerConfig(@NotNull QuickShop plugin) {
        return null;
    }

    @CollectResolver(field=CollectType.LANGUAGE)
    public Map<?, ?> collectI18n(@NotNull QuickShop plugin) {
        return null;
    }

    @CollectResolver(field=CollectType.LOGS)
    public Map<?, ?> collectLogs(@NotNull QuickShop plugin) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qs_debug", Util.list2String(Util.getDebugLogs()));
        return map;
    }

    @CollectResolver(field=CollectType.SHOPS)
    public Map<?, ?> collectShops(@NotNull QuickShop plugin) {
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        map.put("database", plugin.getShopLoader().getOriginShopsInDatabase().stream().map(ShopLoader.ShopRawDatabaseInfo::toString).toArray());
        map.put("memory", plugin.getShopManager().getAllShops().stream().map(Object::toString).toArray());
        return map;
    }
}

