/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.util.mojangapi;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LoadingCache;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.util.HttpCacheLoader;
import org.maxgamer.quickshop.util.JsonUtil;

public class MojangAPI {
    @NotNull
    public AssetsAPI getAssetsAPI(@NotNull String serverVersion) {
        return new AssetsAPI(serverVersion);
    }

    @NotNull
    public GameInfoAPI getGameInfoAPI(@NotNull String gameVersionJson) {
        return new GameInfoAPI(gameVersionJson);
    }

    @NotNull
    public MetaAPI getMetaAPI(@NotNull String serverVersion) {
        return new MetaAPI(serverVersion);
    }

    public ResourcesAPI getResourcesAPI() {
        return new ResourcesAPI();
    }

    public static class AssetsAPI {
        private final LoadingCache<URL, Optional<String>> request = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build(new HttpCacheLoader());
        private final MetaAPI metaAPI;

        AssetsAPI(@NotNull String version) {
            this.metaAPI = new MetaAPI(version);
        }

        public boolean isAvailable() {
            return this.metaAPI.get().isPresent();
        }

        public Optional<AssetsFileData> getGameAssetsFile() {
            Optional<GameInfoAPI.DataBean> bean = this.getAssetsJson();
            if (!bean.isPresent()) {
                return Optional.empty();
            }
            GameInfoAPI.DataBean.AssetIndexBean assetIndexBean = bean.get().getAssetIndex();
            if (assetIndexBean == null || assetIndexBean.getUrl() == null || assetIndexBean.getId() == null) {
                return Optional.empty();
            }
            try {
                Optional<String> fileContent = this.request.get(new URL(assetIndexBean.getUrl()));
                return fileContent.map(s -> new AssetsFileData((String)s, assetIndexBean.getSha1(), assetIndexBean.getId()));
            }
            catch (MalformedURLException | ExecutionException e) {
                return Optional.empty();
            }
        }

        private Optional<GameInfoAPI.DataBean> getAssetsJson() {
            if (!this.isAvailable()) {
                return Optional.empty();
            }
            Optional<String> content = this.metaAPI.get();
            if (!content.isPresent()) {
                return Optional.empty();
            }
            GameInfoAPI gameInfoAPI = new GameInfoAPI(content.get());
            return Optional.of(gameInfoAPI.get());
        }
    }

    public static class GameInfoAPI {
        private final String json;
        private final Gson gson = JsonUtil.getGson();

        public GameInfoAPI(@NotNull String json) {
            this.json = json;
        }

        @NotNull
        public DataBean get() {
            return (DataBean)this.gson.fromJson(this.json, DataBean.class);
        }

        public String getJson() {
            return this.json;
        }

        public Gson getGson() {
            return this.gson;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GameInfoAPI)) {
                return false;
            }
            GameInfoAPI other = (GameInfoAPI)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$json = this.getJson();
            String other$json = other.getJson();
            if (this$json == null ? other$json != null : !this$json.equals(other$json)) {
                return false;
            }
            Gson this$gson = this.getGson();
            Gson other$gson = other.getGson();
            return !(this$gson == null ? other$gson != null : !this$gson.equals(other$gson));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GameInfoAPI;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $json = this.getJson();
            result = result * 59 + ($json == null ? 43 : $json.hashCode());
            Gson $gson = this.getGson();
            result = result * 59 + ($gson == null ? 43 : $gson.hashCode());
            return result;
        }

        public String toString() {
            return "MojangAPI.GameInfoAPI(json=" + this.getJson() + ", gson=" + this.getGson() + ")";
        }

        static class DataBean {
            @Nullable
            private AssetIndexBean assetIndex;
            @Nullable
            private String assets;

            @Nullable
            public AssetIndexBean getAssetIndex() {
                return this.assetIndex;
            }

            @Nullable
            public String getAssets() {
                return this.assets;
            }

            public void setAssetIndex(@Nullable AssetIndexBean assetIndex) {
                this.assetIndex = assetIndex;
            }

            public void setAssets(@Nullable String assets) {
                this.assets = assets;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DataBean)) {
                    return false;
                }
                DataBean other = (DataBean)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                AssetIndexBean this$assetIndex = this.getAssetIndex();
                AssetIndexBean other$assetIndex = other.getAssetIndex();
                if (this$assetIndex == null ? other$assetIndex != null : !((Object)this$assetIndex).equals(other$assetIndex)) {
                    return false;
                }
                String this$assets = this.getAssets();
                String other$assets = other.getAssets();
                return !(this$assets == null ? other$assets != null : !this$assets.equals(other$assets));
            }

            protected boolean canEqual(Object other) {
                return other instanceof DataBean;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                AssetIndexBean $assetIndex = this.getAssetIndex();
                result = result * 59 + ($assetIndex == null ? 43 : ((Object)$assetIndex).hashCode());
                String $assets = this.getAssets();
                result = result * 59 + ($assets == null ? 43 : $assets.hashCode());
                return result;
            }

            public String toString() {
                return "MojangAPI.GameInfoAPI.DataBean(assetIndex=" + this.getAssetIndex() + ", assets=" + this.getAssets() + ")";
            }

            public static class AssetIndexBean {
                @Nullable
                private String id;
                @Nullable
                private String sha1;
                @Nullable
                private String url;

                @Nullable
                public String getId() {
                    return this.id;
                }

                @Nullable
                public String getSha1() {
                    return this.sha1;
                }

                @Nullable
                public String getUrl() {
                    return this.url;
                }

                public void setId(@Nullable String id) {
                    this.id = id;
                }

                public void setSha1(@Nullable String sha1) {
                    this.sha1 = sha1;
                }

                public void setUrl(@Nullable String url) {
                    this.url = url;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof AssetIndexBean)) {
                        return false;
                    }
                    AssetIndexBean other = (AssetIndexBean)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$id = this.getId();
                    String other$id = other.getId();
                    if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                        return false;
                    }
                    String this$sha1 = this.getSha1();
                    String other$sha1 = other.getSha1();
                    if (this$sha1 == null ? other$sha1 != null : !this$sha1.equals(other$sha1)) {
                        return false;
                    }
                    String this$url = this.getUrl();
                    String other$url = other.getUrl();
                    return !(this$url == null ? other$url != null : !this$url.equals(other$url));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof AssetIndexBean;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : $id.hashCode());
                    String $sha1 = this.getSha1();
                    result = result * 59 + ($sha1 == null ? 43 : $sha1.hashCode());
                    String $url = this.getUrl();
                    result = result * 59 + ($url == null ? 43 : $url.hashCode());
                    return result;
                }

                public String toString() {
                    return "MojangAPI.GameInfoAPI.DataBean.AssetIndexBean(id=" + this.getId() + ", sha1=" + this.getSha1() + ", url=" + this.getUrl() + ")";
                }
            }
        }
    }

    public static class MetaAPI {
        private final LoadingCache<URL, Optional<String>> request = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build(new HttpCacheLoader());
        private final URL metaEndpoint;
        private final String version;

        public MetaAPI(@NotNull String version) {
            this.version = version;
            this.metaEndpoint = new URL("https://launchermeta.mojang.com/mc/game/version_manifest.json");
        }

        public Optional<String> get() {
            Optional<String> result = this.request.get(this.metaEndpoint);
            if (!result.isPresent()) {
                return Optional.empty();
            }
            try {
                JsonElement index = new JsonParser().parse(result.get());
                if (!index.isJsonObject()) {
                    return Optional.empty();
                }
                JsonElement availableVersions = index.getAsJsonObject().get("versions");
                if (!availableVersions.isJsonArray()) {
                    return Optional.empty();
                }
                for (JsonElement gameVersionData : availableVersions.getAsJsonArray()) {
                    if (!gameVersionData.isJsonObject()) continue;
                    JsonElement gameId = gameVersionData.getAsJsonObject().get("id");
                    JsonElement gameIndexUrl = gameVersionData.getAsJsonObject().get("url");
                    if (!Objects.equals(gameId.getAsString(), this.version)) continue;
                    return this.request.get(new URL(gameIndexUrl.getAsString()));
                }
                return Optional.empty();
            }
            catch (RuntimeException exception) {
                return Optional.empty();
            }
        }
    }

    public static class ResourcesAPI {
        private final LoadingCache<URL, Optional<String>> request = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build(new HttpCacheLoader());

        public Optional<String> get(@NotNull String hash) {
            try {
                return this.request.get(new URL("https://resources.download.minecraft.net/" + hash.substring(0, 2) + "/" + hash));
            }
            catch (MalformedURLException | ExecutionException e) {
                return Optional.empty();
            }
        }

        public LoadingCache<URL, Optional<String>> getRequest() {
            return this.request;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResourcesAPI)) {
                return false;
            }
            ResourcesAPI other = (ResourcesAPI)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LoadingCache<URL, Optional<String>> this$request = this.getRequest();
            LoadingCache<URL, Optional<String>> other$request = other.getRequest();
            return !(this$request == null ? other$request != null : !this$request.equals(other$request));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResourcesAPI;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LoadingCache<URL, Optional<String>> $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : $request.hashCode());
            return result;
        }

        public String toString() {
            return "MojangAPI.ResourcesAPI(request=" + this.getRequest() + ")";
        }
    }

    public static class AssetsFileData {
        private String content;
        private String sha1;
        private String id;

        public String getContent() {
            return this.content;
        }

        public String getSha1() {
            return this.sha1;
        }

        public String getId() {
            return this.id;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public void setSha1(String sha1) {
            this.sha1 = sha1;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssetsFileData)) {
                return false;
            }
            AssetsFileData other = (AssetsFileData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
                return false;
            }
            String this$sha1 = this.getSha1();
            String other$sha1 = other.getSha1();
            if (this$sha1 == null ? other$sha1 != null : !this$sha1.equals(other$sha1)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AssetsFileData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            String $sha1 = this.getSha1();
            result = result * 59 + ($sha1 == null ? 43 : $sha1.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        public String toString() {
            return "MojangAPI.AssetsFileData(content=" + this.getContent() + ", sha1=" + this.getSha1() + ", id=" + this.getId() + ")";
        }

        public AssetsFileData(String content, String sha1, String id) {
            this.content = content;
            this.sha1 = sha1;
            this.id = id;
        }
    }
}

