/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.util.reporter.error;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.bukkit.Bukkit;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.shade.com.rollbar.notifier.Rollbar;
import org.maxgamer.quickshop.shade.com.rollbar.notifier.config.Config;
import org.maxgamer.quickshop.shade.com.rollbar.notifier.config.ConfigBuilder;
import org.maxgamer.quickshop.util.GameVersion;
import org.maxgamer.quickshop.util.ReflectFactory;
import org.maxgamer.quickshop.util.Util;
import org.maxgamer.quickshop.util.paste.Paste;

public class RollbarErrorReporter {
    private final Rollbar rollbar;
    private final List<String> reported = new ArrayList<String>(5);
    private final List<Class<?>> ignoredException = Lists.newArrayList(IOException.class, OutOfMemoryError.class, ProtocolException.class, InvalidPluginException.class, UnsupportedClassVersionError.class, LinkageError.class);
    private final QuickShop plugin;
    private final QuickShopExceptionFilter quickShopExceptionFilter;
    private final GlobalExceptionFilter serverExceptionFilter;
    private boolean disable;
    private boolean tempDisable;
    private String lastPaste = null;
    private volatile boolean enabled;

    public RollbarErrorReporter(@NotNull QuickShop plugin) {
        this.plugin = plugin;
        Config config = ConfigBuilder.withAccessToken("4846d9b99e5d4d238f9135ea9c744c28").environment(Util.isDevEdition() ? "development" : "production").platform(plugin.getServer().getVersion()).codeVersion(QuickShop.getVersion()).handleUncaughtErrors(false).build();
        this.rollbar = Rollbar.init(config);
        this.quickShopExceptionFilter = new QuickShopExceptionFilter(plugin.getLogger().getFilter());
        plugin.getLogger().setFilter(this.quickShopExceptionFilter);
        this.serverExceptionFilter = new GlobalExceptionFilter(plugin.getLogger().getFilter());
        plugin.getServer().getLogger().setFilter(this.serverExceptionFilter);
        Util.debugLog("Rollbar error reporter success loaded.");
        this.enabled = true;
    }

    public void unregister() {
        this.enabled = false;
        this.plugin.getLogger().setFilter(this.quickShopExceptionFilter.preFilter);
        this.plugin.getServer().getLogger().setFilter(this.serverExceptionFilter.preFilter);
    }

    private Map<String, Object> makeMapping() {
        LinkedHashMap<String, Object> dataMapping = new LinkedHashMap<String, Object>();
        dataMapping.put("paste", this.lastPaste);
        dataMapping.put("system_os", System.getProperty("os.name"));
        dataMapping.put("system_arch", System.getProperty("os.arch"));
        dataMapping.put("system_version", System.getProperty("os.version"));
        dataMapping.put("system_cores", String.valueOf(Runtime.getRuntime().availableProcessors()));
        dataMapping.put("server_build", this.plugin.getServer().getVersion());
        dataMapping.put("server_java", String.valueOf(System.getProperty("java.version")));
        dataMapping.put("server_players", this.plugin.getServer().getOnlinePlayers().size() + "/" + this.plugin.getServer().getMaxPlayers());
        dataMapping.put("server_onlinemode", String.valueOf(this.plugin.getServer().getOnlineMode()));
        dataMapping.put("server_bukkitversion", this.plugin.getServer().getVersion());
        dataMapping.put("user", QuickShop.getInstance().getServerUniqueID().toString());
        return dataMapping;
    }

    private void sendError0(@NotNull Throwable throwable, String ... context) {
        try {
            if (this.plugin.getBootError() != null) {
                return;
            }
            if (this.tempDisable) {
                this.tempDisable = false;
                return;
            }
            if (this.disable) {
                return;
            }
            if (!this.enabled) {
                return;
            }
            if (!this.canReport(throwable)) {
                return;
            }
            if (this.ignoredException.contains(throwable.getClass())) {
                return;
            }
            if (throwable.getCause() != null && this.ignoredException.contains(throwable.getCause())) {
                return;
            }
            if (this.lastPaste == null) {
                try {
                    Paste paste = new Paste(this.plugin);
                    String pasteURL = paste.paste(paste.genNewPaste(), Paste.PasteType.UBUNTU);
                    this.lastPaste = pasteURL != null && !pasteURL.isEmpty() ? pasteURL : paste.paste(paste.genNewPaste());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.rollbar.error(throwable, this.makeMapping(), throwable.getMessage());
            this.plugin.getLogger().warning("A exception was thrown, QuickShop already caught this exception and reported it. This error will only shown once before next restart.");
            this.plugin.getLogger().warning("====QuickShop Error Report BEGIN===");
            this.plugin.getLogger().warning("Description: " + throwable.getMessage());
            this.plugin.getLogger().warning("Server   ID: " + this.plugin.getServerUniqueID());
            this.plugin.getLogger().warning("Exception  : ");
            this.ignoreThrows();
            throwable.printStackTrace();
            this.resetIgnores();
            this.plugin.getLogger().warning("====QuickShop Error Report E N D===");
            Util.debugLog(throwable.getMessage());
            Arrays.stream(throwable.getStackTrace()).forEach(a -> Util.debugLog(a.getClassName() + "." + a.getMethodName() + ":" + a.getLineNumber()));
            if (Util.isDevMode()) {
                throwable.printStackTrace();
            }
        }
        catch (Exception th) {
            this.ignoreThrow();
            this.plugin.getLogger().log(Level.WARNING, "Something going wrong when automatic report errors, please submit this error on Issue Tracker", th);
        }
    }

    public void sendError(@NotNull Throwable throwable, String ... context) {
        if (Bukkit.isPrimaryThread()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.sendError0(throwable, context));
        } else {
            this.sendError0(throwable, context);
        }
    }

    public boolean canReport(@NotNull Throwable throwable) {
        if (!this.enabled) {
            return false;
        }
        if (this.plugin.getUpdateWatcher() == null) {
            return false;
        }
        if (!this.plugin.getUpdateWatcher().getUpdater().isLatest(this.plugin.getUpdateWatcher().getUpdater().getCurrentRunning())) {
            return false;
        }
        if (!GameVersion.get(ReflectFactory.getServerVersion()).isCoreSupports()) {
            return false;
        }
        PossiblyLevel possiblyLevel = this.checkWasCauseByQS(throwable);
        if (possiblyLevel != PossiblyLevel.CONFIRM) {
            return false;
        }
        if (throwable.getMessage().startsWith("#")) {
            return false;
        }
        StackTraceElement stackTraceElement = throwable.getStackTrace().length < 3 ? throwable.getStackTrace()[1] : throwable.getStackTrace()[2];
        if (stackTraceElement.getClassName().contains("org.maxgamer.quickshop.util.reporter.error")) {
            this.ignoreThrows();
            this.plugin.getLogger().log(Level.WARNING, "Uncaught exception in ErrorRollbar", throwable);
            this.resetIgnores();
            return false;
        }
        String text = stackTraceElement.getClassName() + "#" + stackTraceElement.getMethodName() + "#" + stackTraceElement.getLineNumber();
        if (!this.reported.contains(text)) {
            this.reported.add(text);
            return true;
        }
        return false;
    }

    public PossiblyLevel checkWasCauseByQS(@Nullable Throwable throwable) {
        if (throwable == null) {
            return PossiblyLevel.IMPOSSIBLE;
        }
        if (throwable.getMessage() == null) {
            return PossiblyLevel.IMPOSSIBLE;
        }
        if (throwable.getMessage().contains("Could not pass event")) {
            if (throwable.getMessage().contains("QuickShop")) {
                return PossiblyLevel.CONFIRM;
            }
            return PossiblyLevel.IMPOSSIBLE;
        }
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        StackTraceElement[] stackTraceElements = throwable.getStackTrace();
        if (stackTraceElements.length == 0) {
            return PossiblyLevel.IMPOSSIBLE;
        }
        if (stackTraceElements[0].getClassName().contains("org.maxgamer.quickshop")) {
            return PossiblyLevel.CONFIRM;
        }
        long errorCount = Arrays.stream(stackTraceElements).limit(3L).filter(stackTraceElement -> stackTraceElement.getClassName().contains("org.maxgamer.quickshop")).count();
        if (errorCount > 0L) {
            return PossiblyLevel.MAYBE;
        }
        if (throwable.getCause() != null) {
            return this.checkWasCauseByQS(throwable.getCause());
        }
        return PossiblyLevel.IMPOSSIBLE;
    }

    public void ignoreThrow() {
        this.tempDisable = true;
    }

    public void ignoreThrows() {
        this.disable = true;
    }

    public void resetIgnores() {
        this.tempDisable = false;
        this.disable = false;
    }

    private String getPluginInfo() {
        StringBuilder buffer = new StringBuilder();
        for (Plugin bPlugin : this.plugin.getServer().getPluginManager().getPlugins()) {
            buffer.append("\t").append(bPlugin.getName()).append("@").append(bPlugin.isEnabled() ? "Enabled" : "Disabled").append("\n");
        }
        return buffer.toString();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    class QuickShopExceptionFilter
    implements Filter {
        @Nullable
        private final Filter preFilter;

        QuickShopExceptionFilter(Filter preFilter) {
            this.preFilter = preFilter;
        }

        private boolean defaultValue(LogRecord record) {
            return this.preFilter == null || this.preFilter.isLoggable(record);
        }

        @Override
        public boolean isLoggable(@NotNull LogRecord record) {
            if (!RollbarErrorReporter.this.enabled) {
                return this.defaultValue(record);
            }
            Level level = record.getLevel();
            if (level != Level.WARNING && level != Level.SEVERE) {
                return this.defaultValue(record);
            }
            if (record.getThrown() == null) {
                return this.defaultValue(record);
            }
            if (Util.isDevMode()) {
                RollbarErrorReporter.this.sendError(record.getThrown(), record.getMessage());
                return this.defaultValue(record);
            }
            RollbarErrorReporter.this.sendError(record.getThrown(), record.getMessage());
            PossiblyLevel possiblyLevel = RollbarErrorReporter.this.checkWasCauseByQS(record.getThrown());
            if (possiblyLevel == PossiblyLevel.IMPOSSIBLE) {
                return true;
            }
            if (possiblyLevel == PossiblyLevel.MAYBE) {
                RollbarErrorReporter.this.plugin.getLogger().warning("This seems not a QuickShop error. If you have any question, you may can ask QuickShop developer but don't except any solution.");
                return true;
            }
            return false;
        }

        @Nullable
        public Filter getPreFilter() {
            return this.preFilter;
        }
    }

    class GlobalExceptionFilter
    implements Filter {
        @Nullable
        private final Filter preFilter;

        GlobalExceptionFilter(Filter preFilter) {
            this.preFilter = preFilter;
        }

        private boolean defaultValue(LogRecord record) {
            return this.preFilter == null || this.preFilter.isLoggable(record);
        }

        @Override
        public boolean isLoggable(@NotNull LogRecord record) {
            if (!RollbarErrorReporter.this.enabled) {
                return this.defaultValue(record);
            }
            Level level = record.getLevel();
            if (level != Level.WARNING && level != Level.SEVERE) {
                return this.defaultValue(record);
            }
            if (record.getThrown() == null) {
                return this.defaultValue(record);
            }
            if (Util.isDevMode()) {
                RollbarErrorReporter.this.sendError(record.getThrown(), record.getMessage());
                return this.defaultValue(record);
            }
            RollbarErrorReporter.this.sendError(record.getThrown(), record.getMessage());
            PossiblyLevel possiblyLevel = RollbarErrorReporter.this.checkWasCauseByQS(record.getThrown());
            if (possiblyLevel == PossiblyLevel.IMPOSSIBLE) {
                return true;
            }
            if (possiblyLevel == PossiblyLevel.MAYBE) {
                RollbarErrorReporter.this.plugin.getLogger().warning("This seems not a QuickShop. If you have any question, you should ask QuickShop developer.");
                return true;
            }
            return false;
        }

        @Nullable
        public Filter getPreFilter() {
            return this.preFilter;
        }
    }

    static enum PossiblyLevel {
        CONFIRM,
        MAYBE,
        IMPOSSIBLE;

    }
}

