/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.util.updater.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.BuildInfo;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.nonquickshopstuff.com.sk89q.worldedit.util.net.HttpRequest;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;
import org.maxgamer.quickshop.util.updater.QuickUpdater;
import org.maxgamer.quickshop.util.updater.VersionType;

public class JenkinsUpdater
implements QuickUpdater {
    private final BuildInfo pluginBuildInfo;
    private final String jobUrl;
    private BuildInfo lastRemoteBuildInfo;
    private File updatedJar;

    public JenkinsUpdater(BuildInfo pluginBuildInfo) {
        this.pluginBuildInfo = pluginBuildInfo;
        this.jobUrl = pluginBuildInfo.getJobUrl();
    }

    @Override
    @NotNull
    public VersionType getCurrentRunning() {
        switch (this.pluginBuildInfo.getGitBranch()) {
            case "release": {
                return VersionType.STABLE;
            }
            case "rc": {
                return VersionType.RC;
            }
            case "beta": {
                return VersionType.BETA;
            }
            case "lts": {
                return VersionType.LTS;
            }
        }
        return VersionType.SNAPSHOT;
    }

    @Override
    public int getRemoteServerBuildId() {
        if (this.lastRemoteBuildInfo == null) {
            this.isLatest(this.getCurrentRunning());
        }
        if (this.lastRemoteBuildInfo == null) {
            return -1;
        }
        return this.lastRemoteBuildInfo.getBuildId();
    }

    @Override
    @NotNull
    public String getRemoteServerVersion() {
        if (this.lastRemoteBuildInfo == null) {
            this.isLatest(this.getCurrentRunning());
        }
        if (this.lastRemoteBuildInfo == null) {
            return "Error";
        }
        return this.lastRemoteBuildInfo.getBuildTag();
    }

    @Override
    public boolean isLatest(@NotNull VersionType versionType) {
        boolean bl;
        block8: {
            InputStream inputStream = HttpRequest.get(new URL(this.jobUrl + "lastSuccessfulBuild/artifact/target/BUILDINFO")).header("User-Agent", "QuickShop-" + QuickShop.getFork() + " " + QuickShop.getVersion()).execute().expectResponseCode(200).getInputStream();
            try {
                this.lastRemoteBuildInfo = new BuildInfo(inputStream);
                boolean bl2 = bl = this.lastRemoteBuildInfo.getBuildId() <= this.pluginBuildInfo.getBuildId() || this.lastRemoteBuildInfo.getGitCommit().equalsIgnoreCase(this.pluginBuildInfo.getGitCommit());
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioException) {
                    MsgUtil.sendDirectMessage((CommandSender)Bukkit.getConsoleSender(), ChatColor.RED + "[QuickShop] Failed to check for an update on build server! It might be an internet issue or the build server host is down. If you want disable the update checker, you can disable in config.yml, but we still high-recommend check for updates on SpigotMC.org often, Error: " + ioException.getMessage());
                    return true;
                }
            }
            inputStream.close();
        }
        return bl;
    }

    @Override
    public byte[] update(@NotNull VersionType versionType) throws IOException {
        try (InputStream is = HttpRequest.get(new URL(this.jobUrl + "lastSuccessfulBuild/artifact/target/QuickShop.jar")).header("User-Agent", "QuickShop-" + QuickShop.getFork() + " " + QuickShop.getVersion()).execute().getInputStream();){
            byte[] byArray;
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                int len;
                byte[] buff = new byte[1024];
                long downloaded = 0L;
                if (is == null) {
                    throw new IOException("Failed downloading: Cannot open connection with remote server.");
                }
                while ((len = is.read(buff)) != -1) {
                    os.write(buff, 0, len);
                    Util.debugLog("File Downloader: " + (downloaded += (long)len) + " bytes.");
                }
                is.close();
                byte[] file = os.toByteArray();
                os.close();
                byArray = file;
            }
            return byArray;
        }
    }

    @Override
    public void install(byte[] bytes) throws IOException {
        File pluginFolder = new File("plugins");
        if (!pluginFolder.exists()) {
            throw new IOException("Can't find the plugins folder.");
        }
        if (!pluginFolder.isDirectory()) {
            throw new IOException("Plugins not a folder.");
        }
        File[] plugins = pluginFolder.listFiles();
        if (plugins == null) {
            throw new IOException("Can't get the files in plugins folder");
        }
        File newJar = new File(pluginFolder, "QuickShop" + UUID.randomUUID().toString().replace("-", "") + ".jar");
        for (File pluginJar : plugins) {
            try {
                FileOutputStream outputStream;
                PluginDescriptionFile desc = QuickShop.getInstance().getPluginLoader().getPluginDescription(pluginJar);
                if (!desc.getName().equals(QuickShop.getInstance().getDescription().getName())) continue;
                Util.debugLog("Deleting: " + pluginJar.getPath());
                if (!pluginJar.delete()) {
                    Util.debugLog("Delete failed, using replacing method");
                    outputStream = new FileOutputStream(pluginJar, false);
                    try {
                        ((OutputStream)outputStream).write(bytes);
                        outputStream.flush();
                        this.updatedJar = pluginJar;
                        continue;
                    }
                    finally {
                        ((OutputStream)outputStream).close();
                    }
                }
                outputStream = new FileOutputStream(newJar, false);
                try {
                    ((OutputStream)outputStream).write(bytes);
                    outputStream.flush();
                    this.updatedJar = newJar;
                }
                finally {
                    ((OutputStream)outputStream).close();
                }
            }
            catch (InvalidDescriptionException invalidDescriptionException) {
                // empty catch block
            }
        }
    }

    @Override
    @Nullable
    public File getUpdatedJar() {
        return this.updatedJar;
    }
}

