/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.watcher;

import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.util.Util;

public class DisplayAutoDespawnWatcher
extends BukkitRunnable {
    private final QuickShop plugin;
    private final int range;

    public DisplayAutoDespawnWatcher(@NotNull QuickShop plugin) {
        this.plugin = plugin;
        this.range = plugin.getConfig().getInt("shop.display-despawn-range");
    }

    public void run() {
        for (Shop shop : this.plugin.getShopManager().getLoadedShops()) {
            if (shop.isDeleted() || !shop.isLoaded()) continue;
            World world = shop.getLocation().getWorld();
            if (shop.getDisplay() == null) continue;
            boolean anyPlayerInRegion = false;
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (player.getWorld() != world || !(player.getLocation().distance(shop.getLocation()) < (double)this.range)) continue;
                anyPlayerInRegion = true;
                break;
            }
            if (anyPlayerInRegion) {
                if (shop.getDisplay().isSpawned()) continue;
                Util.debugLog("Respawning the shop " + shop + " the display, cause it was despawned and a player close to it");
                Util.mainThreadRun(() -> shop.getDisplay().spawn());
                continue;
            }
            if (!shop.getDisplay().isSpawned()) continue;
            this.removeDisplayItemDelayed(shop);
        }
    }

    public boolean removeDisplayItemDelayed(Shop shop) {
        if (shop.getDisplay() != null) {
            if (shop.getDisplay().isPendingRemoval()) {
                Util.debugLog("Removing the shop " + shop + " the display, cause nobody can see it");
                Util.mainThreadRun(() -> shop.getDisplay().remove());
                return true;
            }
            Util.debugLog("Pending to remove the shop " + shop + " the display, cause nobody can see it");
            shop.getDisplay().pendingRemoval();
            return false;
        }
        return false;
    }

    public DisplayAutoDespawnWatcher(QuickShop plugin, int range) {
        this.plugin = plugin;
        this.range = range;
    }
}

