/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.api;

import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.api.objects.BuyPrice;
import me.gypopo.economyshopgui.api.objects.SellPrice;
import me.gypopo.economyshopgui.api.objects.SellPrices;
import me.gypopo.economyshopgui.api.prices.AdvancedBuyPrice;
import me.gypopo.economyshopgui.api.prices.AdvancedSellPrice;
import me.gypopo.economyshopgui.objects.ShopItem;
import me.gypopo.economyshopgui.objects.ShopSection;
import me.gypopo.economyshopgui.providers.EconomyProvider;
import me.gypopo.economyshopgui.util.EcoType;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class EconomyShopGUIHook {
    private static EconomyShopGUI plugin;

    public EconomyShopGUIHook(EconomyShopGUI plugin) {
        EconomyShopGUIHook.plugin = plugin;
    }

    public static boolean isSellAble(ShopItem shopItem) {
        return shopItem.getSellPrice() >= 0.0;
    }

    @Nullable
    @Deprecated
    public static Double getItemSellPrice(ItemStack item) {
        ShopItem shopItem = EconomyShopGUIHook.plugin.createItem.matchShopItem(item);
        if (shopItem == null) {
            return null;
        }
        return shopItem.getSellPrice(item);
    }

    @Nullable
    @Deprecated
    public static Double getItemSellPrice(Player player, ItemStack item) {
        ShopItem shopItem = EconomyShopGUIHook.plugin.createItem.matchShopItem(player, item);
        if (shopItem == null) {
            return null;
        }
        return shopItem.getSellPrice(player, item);
    }

    @Nullable
    @Deprecated
    public static Double getItemBuyPrice(ItemStack item) {
        ShopItem shopItem = EconomyShopGUIHook.plugin.createItem.matchShopItem(item);
        if (shopItem == null) {
            return null;
        }
        return shopItem.getBuyPrice() * (double)item.getAmount();
    }

    @Nullable
    @Deprecated
    public static Double getItemBuyPrice(Player player, ItemStack item) {
        ShopItem shopItem = EconomyShopGUIHook.plugin.createItem.matchShopItem(player, item);
        if (shopItem == null) {
            return null;
        }
        return shopItem.getBuyPrice(player) * (double)item.getAmount();
    }

    public static Double getItemSellPrice(ShopItem shopItem, ItemStack item) {
        return shopItem.getSellPrice(item);
    }

    public static Double getItemSellPrice(ShopItem shopItem, ItemStack item, int amount, int sold) {
        return shopItem.getSellPrice(item);
    }

    public static Double getItemSellPrice(ShopItem shopItem, ItemStack item, Player player) {
        return shopItem.getSellPrice(player, item);
    }

    public static Double getItemSellPrice(ShopItem shopItem, ItemStack item, Player player, int amount, int sold) {
        return shopItem.getSellPrice(player, item, amount);
    }

    public static Optional<SellPrice> getSellPrice(OfflinePlayer player, ItemStack item) {
        ShopItem shopItem;
        Objects.requireNonNull(item, "Item cannot be null");
        Objects.requireNonNull(player, "Player cannot be null");
        boolean online = player.isOnline();
        int amount = item.getAmount();
        ShopItem shopItem2 = shopItem = !online ? EconomyShopGUIHook.getShopItem(item) : EconomyShopGUIHook.getShopItem((Player)player, item);
        if (shopItem == null || !EconomyShopGUIHook.isSellAble(shopItem)) {
            return Optional.empty();
        }
        if (shopItem.isMaxSell(amount)) {
            return Optional.empty();
        }
        double sellPrice = !online ? EconomyShopGUIHook.getItemSellPrice(shopItem, item, item.getAmount(), 0) : EconomyShopGUIHook.getItemSellPrice(shopItem, item, (Player)player, item.getAmount(), 0);
        SellPrice price = new SellPrice(player, amount, shopItem, shopItem.getEcoType(), sellPrice);
        return Optional.of(price);
    }

    public static SellPrices getSellPrices(OfflinePlayer player, ItemStack ... items) {
        Objects.requireNonNull(player, "Player cannot be null");
        Objects.requireNonNull(items, "Items cannot be null");
        boolean online = player.isOnline();
        HashMap<EcoType, Double> prices = new HashMap<EcoType, Double>();
        HashMap<ShopItem, Integer> shopItems = new HashMap<ShopItem, Integer>();
        for (ItemStack item : items) {
            ShopItem shopItem;
            if (item == null || item.getType() == Material.AIR) continue;
            ShopItem shopItem2 = shopItem = !online ? EconomyShopGUIHook.getShopItem(item) : EconomyShopGUIHook.getShopItem((Player)player, item);
            if (shopItem == null || !EconomyShopGUIHook.isSellAble(shopItem)) continue;
            int alreadySold = shopItems.getOrDefault(shopItem, 0);
            if (shopItem.isMaxSell(item.getAmount() + alreadySold)) continue;
            double sellPrice = !online ? EconomyShopGUIHook.getItemSellPrice(shopItem, item, item.getAmount(), alreadySold) : EconomyShopGUIHook.getItemSellPrice(shopItem, item, (Player)player, item.getAmount(), alreadySold);
            prices.put(shopItem.getEcoType(), prices.getOrDefault(shopItem.getEcoType(), 0.0) + sellPrice);
            shopItems.put(shopItem, alreadySold + item.getAmount());
        }
        return new SellPrices(player, shopItems, prices);
    }

    public static SellPrices getCutSellPrices(OfflinePlayer player, ItemStack[] items, boolean allowModify) {
        Objects.requireNonNull(player, "Player cannot be null");
        Objects.requireNonNull(items, "Items cannot be null");
        boolean online = player.isOnline();
        HashMap<EcoType, Double> prices = new HashMap<EcoType, Double>();
        HashMap<ShopItem, Integer> shopItems = new HashMap<ShopItem, Integer>();
        for (int i = 0; i < items.length; ++i) {
            ShopItem shopItem;
            ItemStack item = items[i];
            if (item == null || item.getType() == Material.AIR) continue;
            ShopItem shopItem2 = shopItem = !online ? EconomyShopGUIHook.getShopItem(item) : EconomyShopGUIHook.getShopItem((Player)player, item);
            if (shopItem == null || !EconomyShopGUIHook.isSellAble(shopItem)) continue;
            int alreadySold = shopItems.getOrDefault(shopItem, 0);
            int limit = EconomyShopGUIHook.getMaxSell(shopItem, item.getAmount(), alreadySold);
            if (limit == -1) continue;
            double sellPrice = !online ? EconomyShopGUIHook.getItemSellPrice(shopItem, item, limit, alreadySold) : EconomyShopGUIHook.getItemSellPrice(shopItem, item, (Player)player, limit, alreadySold);
            prices.put(shopItem.getEcoType(), prices.getOrDefault(shopItem.getEcoType(), 0.0) + sellPrice);
            if (allowModify) {
                if (limit < item.getAmount()) {
                    item.setAmount(item.getAmount() - limit);
                } else {
                    items[i] = null;
                }
            }
            shopItems.put(shopItem, alreadySold + limit);
        }
        return new SellPrices(player, shopItems, prices);
    }

    public static boolean isBuyAble(ShopItem shopItem) {
        return shopItem.getBuyPrice() >= 0.0;
    }

    @Deprecated
    public static Double getItemBuyPrice(ShopItem shopItem, ItemStack item) {
        return shopItem.getBuyPrice() * (double)item.getAmount();
    }

    @Deprecated
    public static Double getItemBuyPrice(ShopItem shopItem, ItemStack item, Player player) {
        return shopItem.getBuyPrice(player) * (double)item.getAmount();
    }

    public static double getItemBuyPrice(ShopItem shopItem, int amount) {
        return shopItem.getBuyPrice() * (double)amount;
    }

    public static double getItemBuyPrice(ShopItem shopItem, Player player, int amount) {
        return shopItem.getBuyPrice(player) * (double)amount;
    }

    public static Optional<BuyPrice> getBuyPrice(OfflinePlayer player, ItemStack item) {
        int stock;
        ShopItem shopItem;
        Objects.requireNonNull(item, "Item cannot be null");
        Objects.requireNonNull(player, "Player cannot be null");
        boolean online = player.isOnline();
        int amount = item.getAmount();
        ShopItem shopItem2 = shopItem = !online ? EconomyShopGUIHook.getShopItem(item) : EconomyShopGUIHook.getShopItem((Player)player, item);
        if (shopItem == null || !EconomyShopGUIHook.isBuyAble(shopItem)) {
            return Optional.empty();
        }
        if (shopItem.isMaxBuy(item.getAmount())) {
            return Optional.empty();
        }
        if (shopItem.getLimitedStockMode() != 0 && amount > (stock = EconomyShopGUIHook.getItemStock(shopItem, player.getUniqueId()))) {
            return Optional.empty();
        }
        double buyPrice = !online ? shopItem.getBuyPrice() * (double)amount : shopItem.getBuyPrice((Player)player) * (double)amount;
        BuyPrice price = new BuyPrice(player, amount, shopItem, shopItem.getEcoType(), buyPrice);
        return Optional.of(price);
    }

    public static boolean hasMultipleBuyPrices(ShopItem shopItem) {
        return false;
    }

    public static AdvancedBuyPrice getMultipleBuyPrices(ShopItem shopItem) {
        return new AdvancedBuyPrice(shopItem);
    }

    public static boolean hasMultipleSellPrices(ShopItem shopItem) {
        return false;
    }

    public static AdvancedSellPrice getMultipleSellPrices(ShopItem shopItem) {
        return new AdvancedSellPrice(shopItem);
    }

    public static EconomyProvider getEcon(@Nullable EcoType ecoType) {
        return plugin.getEcoHandler().getEcon(ecoType);
    }

    @Deprecated
    public static void buyItem(ItemStack item, int amount) {
    }

    @Deprecated
    public static void sellItem(ItemStack item, int amount) {
    }

    public static void buyItem(ShopItem shopItem, int amount) {
    }

    public static void sellItem(ShopItem shopItem, int amount) {
    }

    @Nullable
    public static ShopItem getShopItem(ItemStack item) {
        return EconomyShopGUIHook.plugin.createItem.matchShopItem(item);
    }

    @Nullable
    public static ShopItem getShopItem(Player player, ItemStack item) {
        return EconomyShopGUIHook.plugin.createItem.matchShopItem(player, item);
    }

    @Nullable
    public static ShopItem getShopItem(String itemPath) {
        try {
            ShopSection section = plugin.getSection(itemPath.split("\\.")[0]);
            return section.getShopItem(itemPath);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getItemStock(ShopItem shopItem, @Nullable UUID uuid) {
        return Integer.MAX_VALUE;
    }

    public static Long getItemStockRestockTime(ShopItem shopItem, @Nullable UUID uuid) {
        return null;
    }

    public static int buyItemStock(ShopItem shopItem, @Nullable UUID uuid, int amount) {
        return 0;
    }

    public static void sellItemStock(ShopItem shopItem, @Nullable UUID uuid, int amount) {
    }

    public static int getSellLimit(ShopItem shopItem, @Nullable UUID uuid) {
        return Integer.MAX_VALUE;
    }

    public static Long getSellLimitRestockTime(ShopItem shopItem, @Nullable UUID uuid) {
        return null;
    }

    public static int sellItemLimit(ShopItem shopItem, @Nullable UUID uuid, int amount) {
        return 0;
    }

    public static boolean hasPermissions(ShopItem shopItem, Player player) {
        return true;
    }

    public static boolean hasPermissions(ShopItem shopItem, Player player, String root) {
        return true;
    }

    private static int getMaxSell(ShopItem shopItem, int qty, int alreadySold) {
        if (shopItem.isMaxSell(alreadySold + qty)) {
            if (alreadySold >= shopItem.getMaxSell()) {
                return -1;
            }
            qty = shopItem.getMaxSell() - alreadySold;
        }
        return qty;
    }
}

