/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.commands.editshop;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.commands.editshop.Methods;
import me.gypopo.economyshopgui.commands.editshop.SubCommad;
import me.gypopo.economyshopgui.commands.editshop.subcommands.AddHandItem;
import me.gypopo.economyshopgui.commands.editshop.subcommands.AddItem;
import me.gypopo.economyshopgui.commands.editshop.subcommands.AddSection;
import me.gypopo.economyshopgui.commands.editshop.subcommands.DeleteItem;
import me.gypopo.economyshopgui.commands.editshop.subcommands.DeleteSection;
import me.gypopo.economyshopgui.commands.editshop.subcommands.EditItem;
import me.gypopo.economyshopgui.commands.editshop.subcommands.EditSection;
import me.gypopo.economyshopgui.commands.editshop.subcommands.Import;
import me.gypopo.economyshopgui.commands.editshop.subcommands.InstallLayout;
import me.gypopo.economyshopgui.commands.editshop.subcommands.Migrate;
import me.gypopo.economyshopgui.commands.editshop.subcommands.UploadLayout;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.util.PermissionsCache;
import org.bukkit.ChatColor;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class CommandManager
extends BukkitCommand {
    private ArrayList<SubCommad> subCommads = new ArrayList();
    private final Methods methods;
    private final List<String> disabledWorlds;
    private final EconomyShopGUI plugin;

    public CommandManager(EconomyShopGUI plugin, List<String> disabledWorlds) {
        super("editshop");
        this.description = "Allows to edit the shop with ingame commands";
        this.usageMessage = "/editshop <subCommand> ...";
        this.setPermission("EconomyShopGUI.eshop");
        this.setAliases(Collections.singletonList("eshop"));
        this.methods = new Methods(plugin);
        this.subCommads.add(new AddItem(plugin, this.methods));
        this.subCommads.add(new EditItem(plugin, this.methods));
        this.subCommads.add(new DeleteItem(plugin, this.methods));
        this.subCommads.add(new AddHandItem(plugin, this.methods));
        this.subCommads.add(new Import(plugin, this.methods));
        this.subCommads.add(new AddSection(plugin, this.methods));
        this.subCommads.add(new EditSection(plugin, this.methods));
        this.subCommads.add(new DeleteSection(plugin, this.methods));
        this.subCommads.add(new Migrate(plugin, this.methods));
        this.subCommads.add(new UploadLayout());
        this.subCommads.add(new InstallLayout());
        this.plugin = plugin;
        this.disabledWorlds = disabledWorlds;
    }

    public boolean execute(CommandSender sender, String label, String[] args) {
        if (this.plugin.badYMLParse != null) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&4This command cannot be executed now, please fix the configuration formatting first!"));
            return true;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (this.hasAccesInWorld(player)) {
                if (args.length > 0) {
                    for (SubCommad subCommad : this.subCommads) {
                        if (!args[0].toLowerCase().equalsIgnoreCase(subCommad.getName())) continue;
                        if (PermissionsCache.hasPermission(player, "EconomyShopGUI.eshop." + subCommad.getName())) {
                            subCommad.perform(sender, args);
                        } else {
                            SendMessage.chatToPlayer(player, Lang.NO_PERMISSIONS.get());
                        }
                        return true;
                    }
                }
                if (this.hasPermission((CommandSender)player)) {
                    this.sendAllSyntaxes(sender);
                } else {
                    SendMessage.chatToPlayer(player, Lang.NO_PERMISSIONS.get());
                }
            }
        } else if (sender instanceof ConsoleCommandSender || sender instanceof BlockCommandSender || sender instanceof RemoteConsoleCommandSender) {
            if (args.length > 0) {
                if (args[0].equalsIgnoreCase("addhanditem")) {
                    SendMessage.sendMessage(sender, ChatColor.RED + "This command cannot be executed as the console");
                    return true;
                }
                for (SubCommad subCommad : this.getSubCommads()) {
                    if (!args[0].toLowerCase().equalsIgnoreCase(subCommad.getName())) continue;
                    subCommad.perform(sender, args);
                    return true;
                }
            }
            this.sendAllSyntaxes(sender);
        }
        return true;
    }

    private boolean hasPermission(CommandSender sender) {
        return PermissionsCache.hasPermission(sender, "EconomyShopGUI.eshop.addhanditem") || PermissionsCache.hasPermission(sender, "EconomyShopGUI.eshop.additem") || PermissionsCache.hasPermission(sender, "EconomyShopGUI.eshop.edititem") || PermissionsCache.hasPermission(sender, "EconomyShopGUI.eshop.deleteitem") || PermissionsCache.hasPermission(sender, "EconomyShopGUI.eshop.import") || PermissionsCache.hasPermission(sender, "EconomyShopGUI.eshop.addsection") || PermissionsCache.hasPermission(sender, "EconomyShopGUI.eshop.editsection") || PermissionsCache.hasPermission(sender, "EconomyShopGUI.eshop.deletesection");
    }

    private boolean hasAccesInWorld(Player player) {
        if (!this.disabledWorlds.contains(player.getWorld().getName())) {
            return true;
        }
        SendMessage.chatToPlayer(player, Lang.COMMAND_DISABLED_IN_WORLD.get());
        return false;
    }

    public ArrayList<SubCommad> getSubCommads() {
        return this.subCommads;
    }

    public List<String> tabComplete(CommandSender commandSender, String s, String[] args) {
        if (!this.hasPermission(commandSender)) {
            return Collections.emptyList();
        }
        ArrayList<String> tabCompletions = new ArrayList<String>();
        if (args.length == 1) {
            for (SubCommad subCommad : this.subCommads) {
                if (!PermissionsCache.hasPermission(commandSender, "EconomyShopGUI.eshop." + subCommad.getName())) continue;
                tabCompletions.add(subCommad.getName());
            }
            if (!args[0].isEmpty()) {
                ArrayList<String> completions = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args[0], tabCompletions, completions);
                Collections.sort(completions);
                return completions;
            }
            return tabCompletions;
        }
        if (args.length >= 2) {
            for (SubCommad subCommad : this.subCommads) {
                if (!args[0].equalsIgnoreCase(subCommad.getName())) continue;
                return subCommad.getTabCompletion(args);
            }
        }
        return null;
    }

    private void sendAllSyntaxes(Object logger) {
        SendMessage.sendMessage(logger, ChatColor.DARK_GREEN + "----------------------------------------");
        for (SubCommad subCommad : this.subCommads) {
            if (logger instanceof ConsoleCommandSender && subCommad.getName().equals("addhanditem")) continue;
            SendMessage.sendMessage(logger, " ");
            SendMessage.sendMessage(logger, ChatColor.DARK_GREEN + "- " + ChatColor.GREEN + subCommad.getSyntax() + " - " + subCommad.getDescription());
            SendMessage.sendMessage(logger, " ");
        }
        SendMessage.sendMessage(logger, ChatColor.DARK_GREEN + "----------------------------------------");
    }
}

