/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.methodes;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.objects.inventorys.AuthRequest;
import me.gypopo.economyshopgui.objects.inventorys.CustomizeLayout;
import me.gypopo.economyshopgui.objects.inventorys.FileUploader;
import me.gypopo.economyshopgui.objects.layouts.SimpleCard;
import me.gypopo.economyshopgui.objects.layouts.SimpleLayout;
import me.gypopo.economyshopgui.util.ConfirmRequest;
import me.gypopo.economyshopgui.util.SimplePair;
import me.gypopo.economyshopgui.util.exceptions.LayoutNotFoundException;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitTask;

public class MarketplaceIntegration {
    private BukkitTask validation;
    private final EconomyShopGUI plugin = EconomyShopGUI.getInstance();
    private static long token = new SecureRandom().nextLong();
    private final File dir = new File(this.plugin.getDataFolder() + "/layouts");
    public static String s;
    public static String i;
    public static String data;

    public MarketplaceIntegration() {
        if (!this.dir.exists()) {
            this.dir.mkdirs();
        }
    }

    public void startUpload(Player p) {
        new CustomizeLayout(p, card -> {
            card.setToken(token);
            new FileUploader(p, files -> {
                if (files == null) {
                    p.sendMessage(ChatColor.RED + "Cancelled upload process");
                } else {
                    new AuthRequest(p, method -> {
                        card.setAuthMethod((AuthRequest.AuthMethod)((Object)((Object)((Object)method))));
                        this.requestCard(p, (SimpleCard)card, s -> this.plugin.scheduleSyncDelayedTask(() -> {
                            Runnable onComplete = () -> this.startUpload(p, (ArrayList<String>)files, (String)s, (SimpleCard)card);
                            switch (method) {
                                case TEMP: {
                                    onComplete.run();
                                    break;
                                }
                                case DISCORD: {
                                    p.closeInventory();
                                    p.sendTitle("\u00a71\u00a7lLogin required", "\u00a76\u00a7lClick the link in chat to authorize", 1, 80, 1);
                                    TextComponent message = new TextComponent(TextComponent.fromLegacyText((String)"\u00a7cValidation is required to continue, click here to validate via discord."));
                                    message.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, this.getAuthorizeURL((String)s)));
                                    SendMessage.chatToPlayer(p, message);
                                    this.checkVerification(p, (String)s, 6000L, onComplete);
                                    break;
                                }
                                default: {
                                    SendMessage.chatToPlayer(p, ChatColor.RED + "Cancelled upload process");
                                }
                            }
                        }, 0L));
                    });
                }
            });
        });
    }

    private void requestCard(Player p, SimpleCard card, Consumer<String> onComplete) {
        this.plugin.runTaskAsync(() -> {
            String s;
            try {
                s = this.sendRequest(s + "/createLayout?token=" + token, card.toString());
            }
            catch (Exception e) {
                SendMessage.chatToPlayer(p, ChatColor.RED + "Unable to reach API server at this point, see console for more details.");
                e.printStackTrace();
                return;
            }
            try {
                UUID.fromString(s);
            }
            catch (IllegalArgumentException e) {
                SendMessage.chatToPlayer(p, ChatColor.RED + "Failed to authorize with server, see console for details.");
                e.printStackTrace();
                return;
            }
            onComplete.accept(s);
        });
    }

    private void startUpload(Player p, ArrayList<String> files, String s, SimpleCard card) {
        if (card.getAuthMethod() == AuthRequest.AuthMethod.DISCORD) {
            SendMessage.chatToPlayer(p, ChatColor.GREEN + "Validation success, started upload process, zipping files...");
        } else {
            SendMessage.chatToPlayer(p, ChatColor.GREEN + "Started upload process, zipping files...");
        }
        this.plugin.runTaskAsync(() -> {
            Path cDir;
            try {
                cDir = this.createZipFile();
                FileOutputStream outputStream = new FileOutputStream(cDir.toString());
                ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
                this.zipLayout(files, zipOutputStream);
                zipOutputStream.close();
                outputStream.close();
            }
            catch (IOException e) {
                SendMessage.chatToPlayer(p, ChatColor.RED + "Failed to create a copy of the current shop layout, see console for details.");
                e.printStackTrace();
                return;
            }
            SendMessage.chatToPlayer(p, ChatColor.GREEN + "Successfully compressed layout, uploading to server...");
            SendMessage.chatToPlayer(p, ChatColor.GREEN + "This may take some time, you can continue other things while this process runs in the background...");
            try {
                int status = this.upload(cDir, s);
                switch (status) {
                    case 202: {
                        this.checkStatus(p, s, 6000L, () -> {
                            SendMessage.chatToPlayer(p, ChatColor.GREEN + "Your shop layout was uploaded successfully, you may visit your layout on our website here: " + ChatColor.WHITE + "https://layouts.gpplugins.com/?layout=" + s);
                            token = new SecureRandom().nextLong();
                        });
                        break;
                    }
                    case 406: 
                    case 415: {
                        SendMessage.chatToPlayer(p, ChatColor.RED + "The shop layout was denied by the server, please make sure the files contain no extra content as needed.");
                        SendMessage.errorMessage("Server responded with status code '" + status + "'");
                        token = new SecureRandom().nextLong();
                        break;
                    }
                    default: {
                        SendMessage.chatToPlayer(p, ChatColor.RED + "The server failed to process your request at this time, see console for details.");
                        SendMessage.errorMessage("Server responded with status code '" + status + "'");
                        token = new SecureRandom().nextLong();
                        break;
                    }
                }
            }
            catch (IOException e) {
                SendMessage.chatToPlayer(p, ChatColor.RED + "Error occurred while uploading layout, see console for details.");
                token = new SecureRandom().nextLong();
                e.printStackTrace();
            }
        });
    }

    public void downloadLayout(Player p, String id) {
        SendMessage.chatToPlayer(p, ChatColor.GREEN + "Started install process, retrieving layout from server...");
        this.plugin.runTaskAsync(() -> {
            SimplePair<SimpleLayout, String> layout;
            try {
                layout = this.getLayout(id);
            }
            catch (LayoutNotFoundException e) {
                SendMessage.chatToPlayer(p, ChatColor.RED + "Failed to find a layout with ID " + id + ", make sure the ID is spelled correct and the layout still exists. Keep in mind that temporary layouts are removed after 14 days.");
                return;
            }
            catch (NullPointerException e) {
                SendMessage.chatToPlayer(p, ChatColor.RED + "Failed to fetch layout from server at this time, please try again soon or see console for more details.");
                SendMessage.warnMessage(e.getMessage());
                e.printStackTrace();
                return;
            }
            catch (Exception e) {
                SendMessage.chatToPlayer(p, ChatColor.RED + "Failed to fetch layout from server, see console for more details.");
                e.printStackTrace();
                return;
            }
            SendMessage.chatToPlayer(p, ChatColor.translateAlternateColorCodes((char)'&', (String)"&aYou are about to install layout &c%layoutID% &awith data: \n&6Title: &e%title% \n&6Description: &e%description% \n&6Tags: \n&8- &e%tags% \n&6Compatible MC version(s): &e%mcVer% \n&6Created for plugin version: &e%plVer% \n&6Created at: &e%creationDate% \n&6Downloads: &e%downloads% \n&6Shop files: \n&8- &e%files%".replace("%layoutID%", id).replace("%title%", ((SimpleLayout)layout.key).title).replace("%description%", ((SimpleLayout)layout.key).description).replace("%tags%", String.join((CharSequence)"\n&8- &e", ((SimpleLayout)layout.key).tags)).replace("%files%", String.join((CharSequence)"\n&8- &e", ((SimpleLayout)layout.key).files)).replace("%creationDate%", new SimpleDateFormat("E, dd MMM yyyy").format(((SimpleLayout)layout.key).creation)).replace("%downloads%", ((SimpleLayout)layout.key).downloads + "").replace("%mcVer%", ((SimpleLayout)layout.key).mcVer + "").replace("%plVer%", ((SimpleLayout)layout.key).plVer + "")));
            new ConfirmRequest(this.plugin, ChatColor.RED + "Are you sure you want to continue? This will override the current shop layout.\n" + ChatColor.GREEN + "Enter 'yes' or 'no' in chat.", p, input -> this.plugin.runTaskAsync(() -> {
                if (input.booleanValue()) {
                    File file = this.createLayout(id);
                    Runnable onDownload = () -> {
                        if (!file.exists()) {
                            SendMessage.chatToPlayer(p, ChatColor.RED + "Failed to download layout from server, see console for more details.");
                            return;
                        }
                        this.installLayout(p, (SimpleLayout)layout.key, file);
                    };
                    if (((SimpleLayout)layout.key).requiresAuthorization) {
                        p.sendTitle("\u00a7c\u00a7lValidation required", "\u00a76\u00a7lClick the link in chat to authorize", 1, 80, 1);
                        TextComponent message = new TextComponent(TextComponent.fromLegacyText((String)(ChatColor.RED + "Validation is required to continue, click here to validate via discord.")));
                        message.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, this.getAuthorizeURL((String)layout.value)));
                        SendMessage.chatToPlayer(p, message);
                        this.checkVerification(p, id, 6000L, () -> {
                            SendMessage.chatToPlayer(p, ChatColor.GREEN + "Verification success, downloading layout...");
                            this.downloadFile(id, (String)layout.value, file, onDownload);
                        });
                    } else {
                        SendMessage.chatToPlayer(p, ChatColor.GREEN + "Downloading layout...");
                        this.downloadFile(id, (String)layout.value, file, onDownload);
                    }
                } else {
                    SendMessage.chatToPlayer(p, ChatColor.RED + "Cancelled install process");
                }
            }));
        });
    }

    private void installLayout(Player p, SimpleLayout layout, File file) {
        SendMessage.chatToPlayer(p, ChatColor.GREEN + "Successfully downloaded layout, extracting files...");
        this.backupCurrentLayout(p, layout.files.contains("config.yml"));
        try {
            boolean requiresRestart = false;
            ZipInputStream zis = new ZipInputStream(new FileInputStream(file));
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                int len;
                if (zipEntry.getName().equals("config.yml")) {
                    requiresRestart = true;
                }
                File f = new File(this.plugin.getDataFolder(), zipEntry.getName().replace("/", File.separator));
                FileOutputStream fos = new FileOutputStream(f);
                byte[] buffer = new byte[1024];
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
            if (requiresRestart) {
                SendMessage.chatToPlayer(p, ChatColor.GREEN + "Successfully installed shop layout, a server restart is recommended to load all changes.");
            } else {
                SendMessage.chatToPlayer(p, ChatColor.GREEN + "Successfully installed shop layout, use command /sreload to reload all changes.");
            }
            token = new SecureRandom().nextLong();
        }
        catch (IOException e) {
            SendMessage.chatToPlayer(p, ChatColor.RED + "A unknown error occurred while extracting the downloaded file, see console for details.");
            SendMessage.warnMessage("A unknown error occurred while extracting shop layout from " + file.getAbsolutePath());
            e.printStackTrace();
        }
    }

    private void backupCurrentLayout(Player p, boolean config) {
        File sectionsFolder;
        ArrayList<String> files = new ArrayList<String>(Arrays.asList("config.yml"));
        File shopFolder = new File(this.plugin.getDataFolder() + File.separator + "shops");
        if (shopFolder.exists() && shopFolder.isDirectory()) {
            Arrays.stream(shopFolder.listFiles()).forEach(f -> files.add("shops/" + f.getName()));
        }
        if ((sectionsFolder = new File(this.plugin.getDataFolder() + File.separator + "sections")).exists() && sectionsFolder.isDirectory()) {
            Arrays.stream(sectionsFolder.listFiles()).forEach(f -> files.add("sections/" + f.getName()));
        }
        try {
            Path cDir = this.createZipFile();
            SendMessage.chatToPlayer(p, ChatColor.GREEN + "Saving backup from current layout as layouts/" + cDir.getFileName());
            FileOutputStream outputStream = new FileOutputStream(cDir.toString());
            ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
            this.zipLayout(files, zipOutputStream);
            zipOutputStream.close();
            outputStream.close();
        }
        catch (IOException e) {
            SendMessage.chatToPlayer(p, ChatColor.RED + "Failed to create a backup of the current shop layout, see console for details.");
            e.printStackTrace();
        }
        if (!config) {
            files.remove("config.yml");
        }
        files.forEach(s -> {
            File f = new File(this.plugin.getDataFolder(), s.replace("/", File.separator));
            try {
                Files.delete(f.toPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    private File createLayout(String layoutID) {
        String path = this.plugin.getDataFolder() + File.separator + "layouts" + File.separator + "downloads" + File.separator + layoutID;
        File folder = new File(path).getParentFile();
        if (!folder.exists() || folder.isFile()) {
            folder.mkdirs();
        }
        int i = 0;
        while (new File(path + (i > 0 ? "(" + i + ")" : "")).exists()) {
            ++i;
        }
        return Paths.get(path + (i > 0 ? "(" + i + ")" : "") + ".zip", new String[0]).toFile();
    }

    private String sendRequest(String url, String body) throws Exception {
        HttpURLConnection request = (HttpURLConnection)new URL(url).openConnection();
        request.setConnectTimeout(5000);
        request.setDoOutput(true);
        request.setRequestProperty("token", String.valueOf(token));
        request.setRequestProperty("Content-Type", "application/json");
        OutputStream os = request.getOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
        osw.write(body);
        osw.flush();
        osw.close();
        os.close();
        request.connect();
        return new BufferedReader(new InputStreamReader(request.getInputStream())).readLine();
    }

    private SimplePair<SimpleLayout, String> getLayout(String layoutID) throws Exception {
        HttpURLConnection request = (HttpURLConnection)new URL(s + "/getLayout?layout=" + layoutID).openConnection();
        request.setConnectTimeout(5000);
        request.setRequestProperty("token", String.valueOf(token));
        request.connect();
        String response = new BufferedReader(new InputStreamReader(request.getInputStream())).readLine();
        switch (request.getResponseCode()) {
            case 200: {
                SimpleLayout layout = new SimpleLayout(response);
                return new SimplePair<SimpleLayout, String>(layout, request.getHeaderField("token"));
            }
            case 400: {
                throw new LayoutNotFoundException();
            }
        }
        throw new NullPointerException("Server responded with " + request.getResponseCode() + ": " + response);
    }

    private String getAuthorizeURL(String layout) {
        return s + "/authorize?token=" + token + "&layout=" + layout;
    }

    private void checkVerification(Player p, String layoutID, long timeOut, Runnable onComplete) {
        long ticks = timeOut -= 100L;
        this.validation = this.plugin.runTaskLaterAsync(() -> {
            try {
                if (((HttpURLConnection)new URL(s + "/check?token=" + token + "&layout=" + layoutID).openConnection()).getResponseCode() == 202) {
                    onComplete.run();
                } else if (ticks != 0L) {
                    this.checkVerification(p, layoutID, ticks, onComplete);
                } else {
                    SendMessage.chatToPlayer(p, ChatColor.RED + "Validation process expired");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }, 100L);
    }

    private void checkStatus(Player p, String layoutID, long timeOut, Runnable onComplete) {
        long ticks = timeOut -= 100L;
        this.validation = this.plugin.runTaskLaterAsync(() -> {
            try {
                if (((HttpURLConnection)new URL(s + "/getStatus?token=" + token + "&layout=" + layoutID).openConnection()).getResponseCode() == 200) {
                    onComplete.run();
                } else if (ticks != 0L) {
                    this.checkStatus(p, layoutID, ticks, onComplete);
                } else {
                    SendMessage.chatToPlayer(p, ChatColor.RED + "A timeout occurred while upload layout " + layoutID + ", please try again soon.");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }, 100L);
    }

    private Path createZipFile() throws IOException {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("MM-dd-yyyy");
        LocalDateTime now = LocalDateTime.now();
        String path = this.plugin.getDataFolder() + File.separator + "layouts" + File.separator + "layout - " + dtf.format(now);
        int i = 0;
        while (new File(path + (i > 0 ? "(" + i + ")" : "")).exists()) {
            ++i;
        }
        return Paths.get(path + (i > 0 ? "(" + i + ")" : "") + ".zip", new String[0]);
    }

    private void zipLayout(ArrayList<String> files, ZipOutputStream zipOutputStream) throws IOException {
        for (String file : files) {
            int length;
            String path = this.plugin.getDataFolder().getPath() + File.separator + file;
            FileInputStream fis = new FileInputStream(new File(this.plugin.getDataFolder(), file.replace("/", File.separator)));
            zipOutputStream.putNextEntry(new ZipEntry(file));
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) >= 0) {
                zipOutputStream.write(bytes, 0, length);
            }
            fis.close();
        }
    }

    private void zipFiles(ZipOutputStream zipOutputStream, String dir) throws IOException {
        File directory = new File(this.plugin.getDataFolder() + File.separator + dir);
        if (directory.exists() && directory.isDirectory()) {
            for (File file : directory.listFiles()) {
                int length;
                if (file.isDirectory()) continue;
                String path = file.getPath();
                FileInputStream fis = new FileInputStream(path);
                zipOutputStream.putNextEntry(new ZipEntry(dir + "/" + file.toPath().getFileName().toString()));
                byte[] bytes = new byte[1024];
                while ((length = fis.read(bytes)) >= 0) {
                    zipOutputStream.write(bytes, 0, length);
                }
                fis.close();
            }
        }
    }

    private int upload(Path path, String id) throws IOException {
        URL url = new URL(s + "/uploadLayout?layout=" + id);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("token", String.valueOf(token));
        connection.setRequestProperty("Content-Type", "application/zip");
        try (OutputStream output = connection.getOutputStream();
             FileInputStream fileInputStream = new FileInputStream(new File(path.toUri()));){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = fileInputStream.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
            output.flush();
        }
        int response = connection.getResponseCode();
        connection.disconnect();
        return response;
    }

    private void downloadFile(String id, String s, File output, Runnable onComplete) {
        try {
            int count;
            HttpURLConnection request = (HttpURLConnection)new URL(MarketplaceIntegration.s + "/installLayout?layout=" + id + "&token=" + token).openConnection();
            request.setConnectTimeout(5000);
            request.setRequestProperty("token", s);
            request.connect();
            BufferedInputStream bis = new BufferedInputStream(request.getInputStream());
            FileOutputStream fis = new FileOutputStream(output);
            byte[] buffer = new byte[1024];
            while ((count = bis.read(buffer, 0, 1024)) != -1) {
                fis.write(buffer, 0, count);
            }
            fis.close();
            bis.close();
            onComplete.run();
        }
        catch (IOException e) {
            SendMessage.warnMessage("Failed to download layout from server");
            e.printStackTrace();
        }
    }

    private void disableCache(HttpURLConnection connection) {
        connection.setRequestProperty("Cache-Control", "no-cache, no-store, must-revalidate");
        connection.setRequestProperty("Pragma", "no-cache");
        connection.setRequestProperty("Expires", "0");
    }

    static {
        data = "%%__POLYMART__%%".equals("1") ? "p/?download_token=%%__VERIFY_TOKEN__%%&user_id=%%__USER__%%&resource_id=%%__RESOURCE__%%&nonce=%%__NONCE__%%&inject_version=%%__INJECT_VER__%%&download_agent=%%__AGENT__%%&download_time=%%__TIMESTAMP__%%&key=" + token : ("%%__SONGODA__%%".equals("true") ? "s/?resource=%%__RESOURCE__%%&user_id=%%__USER__%%&version=%%__VERSION__%%&nonce=%%__NONCE__%%&file_hash=%%__FILEHASH__%%&node=%%__SONGODA_NODE__%%&download_time=%%__TIMESTAMP__%%&key=" + token : "i/?resource=%%__RESOURCE__%%&user_id=%%__USER__%%&nonce=%%__NONCE__%%&key=" + token);
    }
}

