/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.methodes;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.VersionHandler;
import me.gypopo.economyshopgui.api.events.ShopItemsLoadEvent;
import me.gypopo.economyshopgui.files.ConfigManager;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.CalculateAmount;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.objects.LoreFormatter;
import me.gypopo.economyshopgui.objects.ShopItem;
import me.gypopo.economyshopgui.objects.ShopSection;
import me.gypopo.economyshopgui.objects.TransactionMenus;
import me.gypopo.economyshopgui.util.XMaterial;
import me.gypopo.economyshopgui.util.exceptions.ItemLoadException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class StartupReload {
    private EconomyShopGUI plugin;

    public StartupReload(EconomyShopGUI plugin) {
        this.plugin = plugin;
    }

    public void loadInventoryTitles() {
        this.plugin.getSectionTitles().clear();
        HashMap<String, String> newSectionTitles = new HashMap<String, String>();
        for (String section : this.plugin.getShopSections()) {
            String title = ConfigManager.getSection(section).getString("title");
            if (title == null || title.isEmpty()) {
                title = ConfigManager.getSection(section).getString("item.name");
            }
            if (title != null && !title.isEmpty()) {
                newSectionTitles.put(section, this.plugin.getInvTitle(this.plugin.formatColors(title)));
                continue;
            }
            newSectionTitles.put(section, Lang.DISPLAYNAME_NULL.get());
        }
        this.plugin.setSectionTitles(newSectionTitles);
    }

    public void checkIfLanguageFilesExist() {
        for (String fileName : new String[]{"lang-en.yml", "lang-fr.yml", "lang-hu.yml", "lang-nl.yml", "lang-es.yml", "lang-pt.yml", "lang-de.yml", "lang-cz.yml", "lang-tr.yml", "lang-ru.yml", "lang-pl.yml", "lang-ko.yml", "lang-sk.yml", "lang-jp.yml", "lang-it.yml", "lang-vi.yml", "lang-zh.yml"}) {
            if (new File(this.plugin.getDataFolder() + File.separator + "LanguageFiles", fileName).exists()) continue;
            this.plugin.saveResource("LanguageFiles" + File.separator + fileName, false);
        }
    }

    public void loadItems() {
        SendMessage.infoMessage(Lang.LOADING_ITEMS.get());
        this.plugin.loadCurrencyFormat();
        this.plugin.boughtItemsLore = ConfigManager.getConfig().getBoolean("bought-items-lore");
        this.plugin.allowUnsafeEnchants = ConfigManager.getConfig().getBoolean("allow-unsafe-enchants");
        this.plugin.discountsActive = ConfigManager.getConfig().getBoolean("enable-discounts");
        this.plugin.multipliers = ConfigManager.getConfig().getBoolean("enable-sell-multipliers");
        this.plugin.ignoredNBTData = ConfigManager.getConfig().getStringList("sold-items-ignored-NBTtags");
        if (ConfigManager.getConfig().getBoolean("allow-renamed-items")) {
            this.plugin.ignoredNBTData.add("display::Name");
        }
        if (ConfigManager.getConfig().getBoolean("allow-lore-items")) {
            this.plugin.ignoredNBTData.add("display::Lore");
        }
        this.plugin.dropItemsOnGround = ConfigManager.getConfig().getBoolean("drop-remaining-items-on-ground");
        this.plugin.prioritizeItemLore = ConfigManager.getConfig().getBoolean("prioritize-item-lore");
        this.plugin.MMB = ConfigManager.getConfig().getBoolean("shift-right-click-sell-all", true);
        this.plugin.maxShopSize = ConfigManager.getConfig().getInt("max-shop-pages", 50);
        this.plugin.allowIllegalStacks = ConfigManager.getConfig().getBoolean("allow-illegal-stacks");
        this.plugin.useItemName = ConfigManager.getConfig().getBoolean("use-item-name", true);
        this.plugin.navBar.createMainMenuNavBar();
        this.plugin.navBar.createShopsNavBar();
        this.plugin.navBar.createTransactionNavBar();
        this.plugin.navBar.createSellGUINavBar();
        this.plugin.mainMenuSize = CalculateAmount.getInvSlots(ConfigManager.getConfig().getInt("main-menu.gui-rows", 6));
        this.plugin.setMainMenuItemSlots(this.plugin.calculateAmount.getMainMenuItemSlots());
        this.plugin.seasonalLore = ConfigManager.getConfig().getBoolean("seasonal-lore.enabled");
        this.plugin.getTransactionLog().save();
        SendMessage.init();
        this.plugin.bedrock = this.plugin.getServer().getPluginManager().getPlugin("floodgate") != null;
        this.plugin.resizeGUI = ConfigManager.getConfig().getBoolean("resize-gui-for-bedrock", true);
        this.plugin.bannedGamemodes = ConfigManager.getConfig().getStringList("banned-gamemodes").stream().filter(s -> {
            try {
                GameMode.valueOf((String)s);
                return true;
            }
            catch (IllegalArgumentException ignored) {
                SendMessage.warnMessage("Failed to load banned gamemode like '" + s + "'");
                return false;
            }
        }).map(GameMode::valueOf).collect(Collectors.toList());
        if (this.plugin.getServer().getPluginManager().isPluginEnabled("Vault")) {
            this.plugin.loadChat();
        }
        if (this.plugin.getServer().getPluginManager().isPluginEnabled("Essentials") && this.plugin.getServer().getPluginManager().getPlugin("Essentials").getConfig().getBoolean("change-displayname") && this.plugin.getServer().getPluginManager().getPlugin("Essentials").getConfig().getBoolean("add-prefix-suffix", this.plugin.getServer().getPluginManager().isPluginEnabled("EssentialsChat"))) {
            this.plugin.prefixSuffix = false;
        }
        this.plugin.sellShulkers = ConfigManager.getConfig().getBoolean("sell-shulker-boxes", true);
        this.plugin.setLoreFormatter(new LoreFormatter(this.plugin));
        HashMap<Integer, ItemStack> newSectionItems = new HashMap<Integer, ItemStack>();
        Iterator<Object> iterator = this.plugin.getMainMenuItemSlots().keySet().iterator();
        while (iterator.hasNext()) {
            ItemStack item;
            int slot = iterator.next();
            String section = this.plugin.getMainMenuSectionForSlot(slot);
            try {
                item = this.plugin.createItem.loadSectionItem(section, "item");
            }
            catch (ItemLoadException e) {
                item = this.plugin.createItem.createItem(XMaterial.BARRIER.parseItem(), ChatColor.RED + e.getMessage(), new String[0]);
                SendMessage.logDebugMessage(e.getMessage());
                SendMessage.logDebugMessage(Lang.ITEMS_PATH_IN_SECTIONS_CONFIG.get().replace("%location%", section));
            }
            newSectionItems.put(slot, item);
            if (!ConfigManager.getSection(section).getBoolean("display-item")) continue;
            this.plugin.removeShopSection(section);
        }
        this.plugin.setSectionItems(newSectionItems);
        for (String section : this.plugin.getShopSections()) {
            this.plugin.addSection(section, new ShopSection(this.plugin, section));
        }
        TransactionMenus.load(this.plugin);
        if (ConfigManager.getConfig().getBoolean("main-menu.fill-item.enable", true)) {
            ItemStack fillitem = this.plugin.createItem.createFillItem(null, ConfigManager.getConfig().getConfigurationSection("main-menu.fill-item"));
            if (fillitem != null) {
                this.plugin.createItem.fillItem = fillitem;
            } else {
                SendMessage.warnMessage("Failed to find fill item inside config.yml");
                SendMessage.logDebugMessage(Lang.ITEMS_PATH_IN_CONFIG.get().replace("%location%", "main-menu.fill-item"));
            }
        } else {
            this.plugin.createItem.fillItem = null;
        }
        if (this.plugin.discountsActive) {
            this.setupDiscounts();
        }
        if (this.plugin.multipliers) {
            this.loadSellMultipliers();
        }
        this.plugin.shopItemsByMaterialName = this.getShopItemsByMaterialName();
        Bukkit.getPluginManager().callEvent((Event)new ShopItemsLoadEvent());
    }

    private void setupDiscounts() {
        HashMap<String, HashMap<String, Double>> sectionDiscounts = new HashMap<String, HashMap<String, Double>>();
        for (String section : ConfigManager.getConfig().getConfigurationSection("discounts").getKeys(false)) {
            if (section.equals("*") || section.equals("all")) {
                for (String s : this.plugin.getShopSections()) {
                    HashMap<String, Double> discounts = new HashMap<String, Double>();
                    for (String group : ConfigManager.getConfig().getConfigurationSection("discounts." + section).getKeys(false)) {
                        double discount = ConfigManager.getConfig().getDouble("discounts." + section + "." + group);
                        if (discount == 0.0) continue;
                        discounts.put(group, discount);
                    }
                    if (discounts.isEmpty()) continue;
                    sectionDiscounts.put(s, discounts);
                }
                continue;
            }
            if (this.plugin.getShopSections().contains(section)) {
                HashMap<String, Double> discounts = new HashMap<String, Double>();
                for (String group : ConfigManager.getConfig().getConfigurationSection("discounts." + section).getKeys(false)) {
                    double discount = ConfigManager.getConfig().getDouble("discounts." + section + "." + group);
                    if (discount == 0.0) continue;
                    discounts.put(group, discount);
                }
                if (discounts.isEmpty()) continue;
                sectionDiscounts.put(section, discounts);
                continue;
            }
            SendMessage.warnMessage(Lang.CANNOT_FIND_DISCOUNTED_SECTION.get().replace("%section%", section));
        }
        if (!sectionDiscounts.isEmpty()) {
            this.plugin.setDiscounts(sectionDiscounts);
        }
    }

    private void loadSellMultipliers() {
        HashMap<String, HashMap<String, Double>> sectionMultipliers = new HashMap<String, HashMap<String, Double>>();
        for (String section : ConfigManager.getConfig().getConfigurationSection("sell-multipliers").getKeys(false)) {
            if (section.equals("*") || section.equals("all")) {
                for (String s : this.plugin.getShopSections()) {
                    HashMap<String, Double> multipliers = new HashMap<String, Double>();
                    for (String group : ConfigManager.getConfig().getConfigurationSection("sell-multipliers." + section).getKeys(false)) {
                        double multiplier = ConfigManager.getConfig().getDouble("sell-multipliers." + section + "." + group);
                        if (multiplier == 0.0) continue;
                        multipliers.put(group, multiplier);
                    }
                    if (multipliers.isEmpty()) continue;
                    sectionMultipliers.put(s, multipliers);
                }
                continue;
            }
            if (this.plugin.getShopSections().contains(section)) {
                HashMap<String, Double> multipliers = new HashMap<String, Double>();
                for (String group : ConfigManager.getConfig().getConfigurationSection("sell-multipliers." + section).getKeys(false)) {
                    double multiplier = ConfigManager.getConfig().getDouble("sell-multipliers." + section + "." + group);
                    if (multiplier == 0.0) continue;
                    multipliers.put(group, multiplier);
                }
                if (multipliers.isEmpty()) continue;
                sectionMultipliers.put(section, multipliers);
                continue;
            }
            SendMessage.warnMessage("Cannot add sell multipliers for section '%section%', either the shop section is disabled or not found.".replace("%section%", section));
        }
        if (!sectionMultipliers.isEmpty()) {
            this.plugin.setSellMultipliers(sectionMultipliers);
        }
    }

    private Map<String, List<ShopItem>> getShopItemsByMaterialName() {
        HashMap<String, List<ShopItem>> mats = new HashMap<String, List<ShopItem>>();
        for (String s : this.plugin.getShopSections()) {
            ShopSection section = this.plugin.getSection(s);
            for (ShopItem shopItem : section.getShopItems()) {
                if (shopItem.hasItemError() || shopItem.isDisplayItem()) continue;
                String mat = shopItem.getShopItem().getType().name();
                List<ShopItem> items = mats.containsKey(mat) ? (List)mats.get(mat) : new ArrayList();
                items.add(shopItem);
                mats.put(mat, items);
            }
        }
        return mats;
    }

    public void updateAvailable() {
        if (this.plugin.updateChecker != null) {
            this.plugin.updateChecker.checkForUpdates();
        }
    }

    public void setupPluginVersion() {
        try {
            String packageName = EconomyShopGUI.class.getPackage().getName() + ".versions";
            String versionName = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
            this.plugin.versionHandler = (VersionHandler)Class.forName(packageName + "." + versionName + "." + versionName).newInstance();
            SendMessage.infoMessage(Lang.MINECRAFT_VERSION_USING.get().replace("%version%", Bukkit.getBukkitVersion().split("-")[0]));
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException exception) {
            SendMessage.warnMessage(Lang.COULD_NOT_FIND_VALID_VERSION.get());
            System.out.println(exception);
        }
    }

    public void checkDebugMode() {
        if (ConfigManager.getConfig().getBoolean("debug", true)) {
            SendMessage.infoMessage(Lang.DEBUG_MODE_ENABLED.get());
        }
    }
}

