/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.objects;

import java.util.HashMap;
import java.util.Map;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.api.events.PostTransactionEvent;
import me.gypopo.economyshopgui.api.events.PreTransactionEvent;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.objects.ShopInventory;
import me.gypopo.economyshopgui.objects.ShopItem;
import me.gypopo.economyshopgui.util.EcoType;
import me.gypopo.economyshopgui.util.SmartStack;
import me.gypopo.economyshopgui.util.Transaction;
import me.gypopo.economyshopgui.util.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class SellGUI
extends ShopInventory {
    private Inventory inv;

    public void open(Player p) {
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)EconomyShopGUI.getInstance().getInvTitle(Lang.INVENTORY_SELLGUI_TITLE.get()));
        EconomyShopGUI.getInstance().navBar.addSellGUINavBar(this.inv, p);
        p.openInventory(this.inv);
    }

    public void sellItems(Player player) {
        int i;
        Transaction.Result result = Transaction.Result.SUCCESS;
        HashMap<Integer, SmartStack> toRemove = new HashMap<Integer, SmartStack>();
        HashMap<ShopItem, Integer> items = new HashMap<ShopItem, Integer>();
        Map<EcoType, Double> prices = new HashMap<EcoType, Double>();
        int amount = 0;
        for (i = 0; i <= this.inv.getSize() - 10; ++i) {
            Integer sold;
            ItemStack item = this.inv.getItem(i);
            if (item == null || item.getType() == Material.AIR) continue;
            ShopItem shopItem = EconomyShopGUI.getInstance().createItem.matchShopItem(item, player, "sellgui");
            if (shopItem != null && shopItem.getSellPrice() >= 0.0) {
                int qty = item.getAmount();
                if (shopItem.isMaxSell(items.getOrDefault(shopItem, 0) + qty)) {
                    if (items.getOrDefault(shopItem, 0) >= shopItem.getMaxSell()) continue;
                    qty = shopItem.getMaxSell() - items.getOrDefault(shopItem, 0);
                }
                prices.put(shopItem.getEcoType(), prices.getOrDefault(shopItem.getEcoType(), 0.0) + shopItem.getSellPrice(player, item, qty));
                items.put(shopItem, items.getOrDefault(shopItem, 0) + qty);
                amount += qty;
                ItemStack itemStack = new ItemStack(item);
                itemStack.setAmount(item.getAmount() - qty);
                toRemove.put(i, new SmartStack(itemStack));
                continue;
            }
            if (!XMaterial.isShulker(item.getType()) || (sold = this.sellShulker(items, prices, toRemove, player, item, "sellgui", i)) == null) continue;
            amount += sold.intValue();
        }
        if (amount > 0) {
            if ((prices = this.callPreTransactionEvent(items, prices, player, amount)) != null) {
                this.removeItems(this.inv, toRemove);
                prices.forEach((type, price) -> EconomyShopGUI.getInstance().getEcoHandler().getEcon((EcoType)type).depositBalance((OfflinePlayer)player, (double)price));
                SendMessage.sendTransactionMessage(player, amount, prices, items, Transaction.Type.SELL_GUI_SCREEN);
            } else {
                result = Transaction.Result.TRANSACTION_CANCELLED;
            }
        } else {
            result = Transaction.Result.NO_ITEMS_FOUND;
            SendMessage.chatToPlayer(player, Lang.NO_ITEM_FOUND.get());
        }
        for (i = 0; i <= this.inv.getSize() - 10; ++i) {
            if (this.inv.getItem(i) == null || this.inv.getItem(i).getType() == Material.AIR) continue;
            player.getInventory().addItem(new ItemStack[]{this.inv.getItem(i)});
        }
        Bukkit.getPluginManager().callEvent((Event)new PostTransactionEvent(items, prices, player, amount, Transaction.Type.SELL_ALL_COMMAND, result));
    }

    private Integer sellShulker(Map<ShopItem, Integer> history, Map<EcoType, Double> prices, Map<Integer, SmartStack> toRemove, Player p, ItemStack box, String perm, int slot) {
        BlockStateMeta bm;
        HashMap<ShopItem, Integer> bItems = new HashMap<ShopItem, Integer>();
        HashMap<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
        HashMap<EcoType, Double> bPrices = new HashMap<EcoType, Double>();
        int removed = 0;
        if (box.getItemMeta() instanceof BlockStateMeta && (bm = (BlockStateMeta)box.getItemMeta()).getBlockState() instanceof ShulkerBox) {
            Inventory inv = ((ShulkerBox)bm.getBlockState()).getInventory();
            if (inv.isEmpty()) {
                return null;
            }
            for (int i = 0; i < 27; ++i) {
                ShopItem shopItem;
                ItemStack is = inv.getItem(i);
                if (is == null || is.getType().equals((Object)Material.AIR) || (shopItem = EconomyShopGUI.getInstance().createItem.matchShopItem(is, p, perm)) == null || !(shopItem.getSellPrice() >= 0.0)) continue;
                int qty = is.getAmount();
                if (shopItem.isMaxSell(bItems.getOrDefault(shopItem, 0) + history.getOrDefault(shopItem, 0) + qty)) {
                    if (history.getOrDefault(shopItem, 0) >= shopItem.getMaxSell()) continue;
                    qty = shopItem.getMaxSell() - history.getOrDefault(shopItem, 0);
                }
                bItems.put(shopItem, bItems.getOrDefault(shopItem, 0) + qty);
                bPrices.put(shopItem.getEcoType(), bPrices.getOrDefault(shopItem.getEcoType(), 0.0) + shopItem.getSellPrice(p, is, qty));
                removed += qty;
                ItemStack stack = new ItemStack(is);
                stack.setAmount(is.getAmount() - qty);
                items.put(i, stack);
            }
            if (!bItems.isEmpty()) {
                bPrices.forEach((k, v) -> prices.put((EcoType)k, prices.getOrDefault(k, 0.0) + v));
                ItemStack sBox = new ItemStack(box);
                this.emptyShulker(new SmartStack.Shulker(sBox, items));
                ShopItem shopItem = EconomyShopGUI.getInstance().createItem.matchShopItem(sBox);
                if (shopItem != null) {
                    prices.put(shopItem.getEcoType(), prices.getOrDefault(shopItem.getEcoType(), 0.0) + shopItem.getSellPrice(p));
                    ++removed;
                    toRemove.put(slot, new SmartStack(box));
                    history.put(new ShopItem.Shulker(shopItem, sBox, bItems), history.getOrDefault(shopItem, 0) + 1);
                } else {
                    toRemove.put(slot, new SmartStack.Shulker(box, items));
                    bItems.forEach((k, v) -> history.put((ShopItem)k, history.getOrDefault(k, 0) + v));
                }
                return removed;
            }
        }
        return null;
    }

    private void removeItems(Inventory inv, Map<Integer, SmartStack> items) {
        items.forEach((i, stack) -> {
            if (stack instanceof SmartStack.Shulker) {
                this.emptyShulker((SmartStack.Shulker)stack);
            } else if (stack.getItem().getAmount() != 0) {
                inv.setItem(i.intValue(), stack.getItem());
            } else {
                inv.clear(i.intValue());
            }
        });
    }

    private void emptyShulker(SmartStack.Shulker shulker) {
        ItemStack sBox = shulker.getItem();
        BlockStateMeta sbm = (BlockStateMeta)sBox.getItemMeta();
        ShulkerBox s = (ShulkerBox)sbm.getBlockState();
        shulker.getItems().forEach((i, item) -> {
            if (item.getAmount() != 0) {
                s.getInventory().setItem(i.intValue(), item);
            } else {
                s.getInventory().clear(i.intValue());
            }
        });
        sbm.setBlockState((BlockState)s);
        sBox.setItemMeta((ItemMeta)sbm);
    }

    private Map<EcoType, Double> callPreTransactionEvent(Map<ShopItem, Integer> items, Map<EcoType, Double> prices, Player player, int amount) {
        PreTransactionEvent preTransactionEvent = new PreTransactionEvent(items, prices, player, amount, Transaction.Type.SELL_GUI_SCREEN);
        Bukkit.getPluginManager().callEvent((Event)preTransactionEvent);
        return preTransactionEvent.isCancelled() ? null : preTransactionEvent.getPrices();
    }

    @Override
    public Inventory getInventory() {
        return this.inv;
    }
}

