/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.CalculateAmount;
import me.gypopo.economyshopgui.methodes.CreateItem;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.objects.ShopInventory;
import me.gypopo.economyshopgui.objects.ShopItem;
import me.gypopo.economyshopgui.objects.TransactionItem;
import me.gypopo.economyshopgui.objects.TransactionMenus;
import me.gypopo.economyshopgui.providers.UserManager;
import me.gypopo.economyshopgui.util.Transaction;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TransactionMenu
extends ShopInventory {
    private final List<ItemStack> CACHE = new ArrayList<ItemStack>();
    private final ShopItem shopItem;
    private final boolean disabledBackButton;
    private final ItemStack selectedItem;
    private final Transaction.Mode transactionMode;
    private final Transaction.Type transactionType;
    private final Inventory inv;
    private final Player player;
    private int amount;

    public TransactionMenu(Player p, ShopItem shopItem, boolean disabledBackButton, Transaction.Mode transactionMode, Transaction.Type transactionType, int amount) {
        this.shopItem = shopItem;
        this.player = p;
        this.amount = this.shopItem.getStackSize();
        this.selectedItem = new ItemStack(this.shopItem.getShopItem());
        this.disabledBackButton = disabledBackButton;
        this.transactionMode = transactionMode;
        this.transactionType = transactionType;
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)CalculateAmount.getInvSlotsDef(UserManager.getUser(p), TransactionMenus.getSize(transactionType)), (String)this.getInvTitle());
        this.init();
    }

    public boolean isDisabledBackButton() {
        return this.disabledBackButton;
    }

    public Transaction.Mode getTransactionMode() {
        return this.transactionMode;
    }

    public Transaction.Type getTransactionType() {
        return this.transactionType;
    }

    public String getItemPath() {
        return this.shopItem.getItemPath();
    }

    public ItemStack getSelectedItem() {
        return this.selectedItem;
    }

    public ShopItem getShopItem() {
        return this.shopItem;
    }

    public int getAmount() {
        return this.amount;
    }

    public void emptyCache() {
        for (ItemStack i : this.CACHE) {
            this.player.getInventory().removeItem(new ItemStack[]{i});
        }
        this.CACHE.clear();
    }

    public int getTotalAmount() {
        return this.transactionType == Transaction.Type.BUY_STACKS_SCREEN ? this.amount * this.selectedItem.getMaxStackSize() : this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public void addItemStacks() {
        int maxStackSize = this.shopItem.getItemToGive().getMaxStackSize();
        double div = (double)this.getTotalAmount() / (double)maxStackSize;
        int fullStacks = (int)Math.floor(div);
        int stacks = div == Math.floor(div) ? fullStacks : (int)Math.ceil(div);
        int amountLeft = this.getTotalAmount();
        ItemStack[] items = new ItemStack[stacks];
        if (fullStacks >= 1) {
            for (int i = 0; i < fullStacks; ++i) {
                ItemStack item = new ItemStack(this.shopItem.getItemToGive());
                item.setAmount(maxStackSize);
                items[i] = item;
                amountLeft -= maxStackSize;
            }
        }
        if (amountLeft >= 1) {
            ItemStack item = new ItemStack(this.shopItem.getItemToGive());
            item.setAmount(amountLeft);
            items[stacks - 1] = item;
        }
        this.addItems(items);
    }

    private void addItems(ItemStack[] items) {
        HashMap leftItems = this.player.getInventory().addItem(items);
        if (!leftItems.isEmpty()) {
            if (EconomyShopGUI.getInstance().dropItemsOnGround) {
                Location loc = this.player.getLocation();
                World world = this.player.getWorld();
                for (ItemStack item : leftItems.values()) {
                    world.dropItem(loc, item);
                }
                SendMessage.chatToPlayer(this.player, Lang.NOT_ENOUGH_SPACE_INSIDE_INVENTORY.get());
            } else {
                int itemsLeft = 0;
                for (ItemStack item : leftItems.values()) {
                    itemsLeft += item.getAmount();
                }
                SendMessage.chatToPlayer(this.player, Lang.COULD_NOT_STORE_ALL_ITEMS.get().replace("%amount%", Integer.toString(itemsLeft)));
            }
        }
        this.player.updateInventory();
    }

    public Double sellAllItems(int limit) {
        double sellPrice = 0.0;
        int amount = 0;
        if (this.shopItem.isMaxSell(limit)) {
            limit = this.shopItem.getMaxSell();
        }
        for (int i = 0; i < 36; ++i) {
            ItemStack itemInInv = this.player.getInventory().getItem(i);
            if (itemInInv == null || itemInInv.getType().equals((Object)Material.AIR) || !this.shopItem.match(itemInInv)) continue;
            if (limit < itemInInv.getAmount()) {
                ItemStack item = new ItemStack(itemInInv);
                item.setAmount(limit);
                this.CACHE.add(item);
                amount += limit;
                sellPrice += this.shopItem.getSellPrice(this.player, itemInInv, limit);
                break;
            }
            this.CACHE.add(itemInInv);
            amount += itemInInv.getAmount();
            sellPrice += this.shopItem.getSellPrice(this.player, itemInInv, itemInInv.getAmount());
            limit -= itemInInv.getAmount();
        }
        this.amount = amount;
        return amount == 0 ? null : Double.valueOf(sellPrice);
    }

    public int getFreeSpace() {
        int freespace = 0;
        int maxStackSize = this.shopItem.getItemToGive().getMaxStackSize();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(Arrays.asList(this.player.getInventory().getContents()));
        for (int i = 0; i < 36; ++i) {
            ItemStack item = (ItemStack)items.get(i);
            if (item == null || item.getType().equals((Object)Material.AIR)) {
                freespace += maxStackSize;
                continue;
            }
            if (!item.isSimilar(this.shopItem.getItemToGive()) || item.getAmount() >= maxStackSize) continue;
            freespace += maxStackSize - item.getAmount();
        }
        return freespace;
    }

    public int getAmountToSell(int freeSpace) {
        int totalAmount = this.getTotalAmount();
        if (totalAmount > freeSpace && !EconomyShopGUI.getInstance().dropItemsOnGround) {
            return freeSpace;
        }
        if (this.shopItem.isMaxBuy(totalAmount)) {
            totalAmount = this.shopItem.getMaxBuy();
        }
        return totalAmount;
    }

    public void sendTransactionCompleteMessage(double price) {
        SendMessage.sendTransactionMessage(this.player, this.getTotalAmount(), price, this.shopItem, this.transactionMode, this.transactionType);
    }

    private String getTransactionScreenType() {
        return this.transactionType.getName();
    }

    private String getInvTitle() {
        String title = "";
        switch (this.transactionType) {
            case SELL_SCREEN: {
                title = EconomyShopGUI.getInstance().getInvTitle(Lang.INVENTORY_HOWMUCHSELL_TITLE.get());
                break;
            }
            case BUY_SCREEN: {
                title = EconomyShopGUI.getInstance().getInvTitle(Lang.INVENTORY_HOWMUCHBUY_TITLE.get());
                break;
            }
            case BUY_STACKS_SCREEN: {
                title = EconomyShopGUI.getInstance().getInvTitle(Lang.INVENTORY_BUYSTACKS_TITLE.get());
            }
        }
        return title.replace("%item%", this.shopItem.getDisplayname()).replace("%material%", EconomyShopGUI.getInstance().getMaterialName(this.selectedItem.getType().name()));
    }

    public double getBasePrice() {
        return this.transactionMode == Transaction.Mode.BUY ? this.shopItem.getBuyPrice() : this.shopItem.getSellPrice();
    }

    public double getPrice(int itemsToSell) {
        return this.shopItem.getBuyPrice(this.player) * (double)itemsToSell;
    }

    public void setConfirmTransactionItem() {
        TransactionItem item = TransactionMenus.getItemByType(this.transactionType, CreateItem.TransactionItemType.CONFIRM);
        if (item == null) {
            return;
        }
        String formatted = EconomyShopGUI.getInstance().formatPrice(this.shopItem.getEcoType(), (this.transactionMode == Transaction.Mode.BUY ? this.shopItem.getBuyPrice(this.player) : this.shopItem.getSellPrice(this.player)) * (double)this.getTotalAmount());
        ItemStack stack = new ItemStack(item.getItem());
        if (stack.hasItemMeta()) {
            ItemMeta meta = stack.getItemMeta();
            meta.setDisplayName(meta.getDisplayName().replace("%price%", formatted));
            if (meta.hasLore()) {
                meta.setLore(stack.getItemMeta().getLore().stream().map(s -> s.replace("%price%", formatted)).collect(Collectors.toList()));
            }
            stack.setItemMeta(meta);
        }
        this.setItem(item.getSlots(), stack);
    }

    public void setSelectedItem() {
        TransactionItem item = TransactionMenus.getItemByType(this.transactionType, CreateItem.TransactionItemType.SELECTED_ITEM);
        if (item != null) {
            this.setItem(item.getSlots(), this.getSelectedItem(this.amount));
        }
    }

    private void init() {
        TransactionMenus.getItems(this.transactionType).forEach(item -> {
            switch (item.getType()) {
                case NORMAL: 
                case DECREASE_AMOUNT: {
                    this.setItem(item.getSlots(), item.getItem());
                    break;
                }
                case INCREASE_AMOUNT: {
                    ItemStack stack = new ItemStack(item.getItem());
                    if (this.isMaxAmount(this.amount + 1)) {
                        ItemMeta meta = item.getItem().getItemMeta();
                        meta.setDisplayName(Lang.MAX_AMOUNT_REACHED.get());
                        stack.setItemMeta(meta);
                    }
                    this.setItem(item.getSlots(), stack);
                }
            }
        });
    }

    public ItemStack getSelectedItem(int amount) {
        ItemMeta meta = this.selectedItem.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(Lang.TRANSACTION_SCREEN_TOTAL_AMOUNT.get().replace("%amount%", String.valueOf(this.getTotalAmount())));
        meta.setLore(lore);
        this.selectedItem.setItemMeta(meta);
        this.selectedItem.setAmount(amount);
        return this.selectedItem;
    }

    private boolean isMaxAmount(int amount) {
        return this.transactionMode == Transaction.Mode.BUY ? (this.transactionType == Transaction.Type.BUY_STACKS_SCREEN ? this.shopItem.isMaxBuy(amount * this.selectedItem.getMaxStackSize()) : this.shopItem.isMaxBuy(amount)) : this.shopItem.isMaxSell(amount);
    }

    private int getMaxAmount() {
        return this.transactionMode == Transaction.Mode.BUY ? (this.transactionType == Transaction.Type.BUY_STACKS_SCREEN ? this.shopItem.getMaxBuy() / this.selectedItem.getMaxStackSize() : this.shopItem.getMaxBuy()) : this.shopItem.getMaxSell();
    }

    public void updateAmount(CreateItem.TransactionItemAction action) {
        int maxSize;
        int current = this.amount;
        switch (action) {
            case ADD1: {
                ++current;
                break;
            }
            case ADD16: {
                current += 16;
                break;
            }
            case ADD32: {
                current += 32;
                break;
            }
            case REMOVE1: {
                --current;
                break;
            }
            case REMOVE16: {
                current -= 16;
                break;
            }
            case REMOVE32: {
                current -= 32;
            }
        }
        if (current < 1) {
            current = 1;
        } else if (current > 64) {
            current = 64;
        }
        if (this.isMaxAmount(current)) {
            current = this.getMaxAmount();
        }
        this.update(current > (maxSize = this.selectedItem.getMaxStackSize()) ? (EconomyShopGUI.getInstance().allowIllegalStacks ? current : maxSize) : current);
    }

    public void update(int amount) {
        TransactionMenus.getItemsByType(this.transactionType, CreateItem.TransactionItemType.INCREASE_AMOUNT).forEach(item -> {
            if (this.isMaxAmount(amount + 1)) {
                ItemStack stack = new ItemStack(item.getItem());
                ItemMeta meta = item.getItem().getItemMeta();
                meta.setDisplayName(ChatColor.RED + "Max amount reached");
                stack.setItemMeta(meta);
                this.setItem(item.getSlots(), stack);
            } else if (this.isMaxAmount(this.amount + 1)) {
                this.setItem(item.getSlots(), item.getItem());
            }
        });
        this.amount = amount;
        this.setSelectedItem();
        this.setConfirmTransactionItem();
    }

    private void setItem(List<Integer> slots, ItemStack stack) {
        slots.forEach(i -> this.inv.setItem(i.intValue(), stack));
    }

    public void open() {
        this.setSelectedItem();
        this.setConfirmTransactionItem();
        EconomyShopGUI.getInstance().navBar.addTransactionNavBar(this.inv, this.player, this.shopItem.getEcoType());
        this.player.openInventory(this.inv);
    }

    @Override
    public Inventory getInventory() {
        return null;
    }
}

