/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.providers;

import com.bgsoftware.wildstacker.api.WildStacker;
import com.bgsoftware.wildstacker.api.WildStackerAPI;
import de.dustplanet.util.SilkUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import jline.internal.Nullable;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.events.SpawnerBreakEvent;
import me.gypopo.economyshopgui.events.SpawnerInteractEvent;
import me.gypopo.economyshopgui.events.SpawnerPlaceEvent;
import me.gypopo.economyshopgui.files.ConfigManager;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.providers.SpawnerProvider;
import me.gypopo.economyshopgui.providers.spawners.DefaultSpawnerProvider;
import me.gypopo.economyshopgui.providers.spawners.MineableSpawnersHook;
import me.gypopo.economyshopgui.providers.spawners.RoseStackerHook;
import me.gypopo.economyshopgui.providers.spawners.SilkSpawnersHook;
import me.gypopo.economyshopgui.providers.spawners.SilkSpawnersV2Hook;
import me.gypopo.economyshopgui.providers.spawners.UltimateStackerHook;
import me.gypopo.economyshopgui.providers.spawners.WildStackerHook;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class SpawnerManager {
    private SpawnerInteractEvent interactEvent;
    private SpawnerBreakEvent breakEvent;
    private SpawnerPlaceEvent placeEvent;
    private final EconomyShopGUI plugin;
    private SpawnerProvider provider;

    public SpawnerManager(EconomyShopGUI plugin) {
        this.plugin = plugin;
    }

    public void init() {
        Provider providerName;
        SpawnerProvider provider;
        if (this.breakEvent != null) {
            BlockBreakEvent.getHandlerList().unregister((Listener)this.breakEvent);
        }
        if (this.placeEvent != null) {
            BlockPlaceEvent.getHandlerList().unregister((Listener)this.placeEvent);
        }
        if (this.interactEvent != null) {
            PlayerInteractEvent.getHandlerList().unregister((Listener)this.interactEvent);
        }
        if ((provider = this.setup(providerName = Provider.getFromString(ConfigManager.getConfig().getString("spawner-provider", "DEFAULT")), false)) == null) {
            this.provider = this.initProvider(Provider.DEFAULT, null);
            SendMessage.infoMessage(Lang.USING_DEFAULT_SPAWNERS.get());
        }
    }

    private SpawnerProvider setup(Provider providerName, boolean silent) {
        switch (providerName) {
            case ULTIMATESTACKER: 
            case ROSESTACKER: 
            case SILKSPAWNERSV2: 
            case MINEABLESPAWNERS: {
                if (this.plugin.getServer().getPluginManager().getPlugin(providerName.getPluginName()) != null) {
                    SendMessage.infoMessage(SpawnerManager.getLog(Lang.SPAWNER_PROVIDER_FOUND.get(), providerName.getName()));
                    if (this.plugin.getServer().getPluginManager().getPlugin(providerName.getPluginName()).isEnabled()) {
                        this.provider = this.initProvider(providerName, null);
                        SendMessage.infoMessage(SpawnerManager.getLog(Lang.USING_EXTERNAL_SPAWNERS.get(), providerName.getName()));
                        break;
                    }
                    SendMessage.warnMessage(SpawnerManager.getLog(Lang.FAILED_SPAWNER_PROVIDER_INTEGRATION.get(), providerName.getName()));
                    break;
                }
                if (silent) break;
                SendMessage.warnMessage(SpawnerManager.getLog(Lang.SPAWNER_PROVIDER_NOT_FOUND.get(), providerName.getName()));
                break;
            }
            case WILDSTACKER: {
                if (this.plugin.getServer().getPluginManager().getPlugin(providerName.getPluginName()) != null) {
                    SendMessage.infoMessage(SpawnerManager.getLog(Lang.SPAWNER_PROVIDER_FOUND.get(), providerName.getName()));
                    WildStacker ws = WildStackerAPI.getWildStacker();
                    if (ws != null && this.plugin.getServer().getPluginManager().getPlugin(providerName.getPluginName()).isEnabled()) {
                        this.provider = this.initProvider(providerName, ws);
                        SendMessage.infoMessage(SpawnerManager.getLog(Lang.USING_EXTERNAL_SPAWNERS.get(), providerName.getName()));
                        break;
                    }
                    SendMessage.warnMessage(SpawnerManager.getLog(Lang.FAILED_SPAWNER_PROVIDER_INTEGRATION.get(), providerName.getName()));
                    break;
                }
                if (silent) break;
                SendMessage.warnMessage(SpawnerManager.getLog(Lang.SPAWNER_PROVIDER_NOT_FOUND.get(), providerName.getName()));
                break;
            }
            case SILKSPAWNERS: {
                if (this.plugin.getServer().getPluginManager().getPlugin(providerName.getPluginName()) != null) {
                    SendMessage.infoMessage(SpawnerManager.getLog(Lang.SPAWNER_PROVIDER_FOUND.get(), providerName.getName()));
                    try {
                        SilkUtil su = SilkUtil.hookIntoSilkSpanwers();
                        if (su != null && this.plugin.getServer().getPluginManager().getPlugin(providerName.getPluginName()).isEnabled()) {
                            this.provider = this.initProvider(providerName, su);
                            SendMessage.infoMessage(SpawnerManager.getLog(Lang.USING_EXTERNAL_SPAWNERS.get(), providerName.getName()));
                            break;
                        }
                        SendMessage.warnMessage(SpawnerManager.getLog(Lang.FAILED_SPAWNER_PROVIDER_INTEGRATION.get(), providerName.getName()));
                    }
                    catch (NoClassDefFoundError e) {
                        try {
                            Class.forName("de.corneliusmay.silkspawners.plugin.SilkSpawners");
                            SendMessage.warnMessage("SilkSpawners_V1 not found but instead found SilkSpawners_V2, updating config setting to use SilkSpawnersV2...");
                            if (this.plugin.getServer().getPluginManager().getPlugin(Provider.SILKSPAWNERSV2.getPluginName()).isEnabled()) {
                                this.provider = this.initProvider(Provider.SILKSPAWNERSV2, null);
                            } else {
                                SendMessage.warnMessage(SpawnerManager.getLog(Lang.FAILED_SPAWNER_PROVIDER_INTEGRATION.get(), Provider.SILKSPAWNERSV2.getName()));
                            }
                            ConfigManager.getConfig().set("spawner-provider", Provider.SILKSPAWNERSV2.name());
                            ConfigManager.saveConfig();
                        }
                        catch (ClassNotFoundException exception) {
                            SendMessage.warnMessage(SpawnerManager.getLog(Lang.FAILED_SPAWNER_PROVIDER_INTEGRATION.get(), providerName.getName()));
                        }
                    }
                    break;
                }
                if (silent) break;
                SendMessage.warnMessage(SpawnerManager.getLog(Lang.SPAWNER_PROVIDER_NOT_FOUND.get(), providerName.getName()));
                break;
            }
            case DISABLED: {
                this.provider = this.initProvider(providerName, null);
                SendMessage.infoMessage(Lang.SPAWNER_PROVIDER_DISABLED.get());
                break;
            }
            case DEFAULT: {
                this.provider = this.initProvider(providerName, null);
                SendMessage.infoMessage(Lang.USING_DEFAULT_SPAWNERS.get());
                break;
            }
            case AUTO: {
                Provider provider;
                SpawnerProvider spawnerProvider;
                SendMessage.infoMessage("Automatically searching for compatible spawner provider....");
                Iterator<Provider> iterator = Arrays.asList(Provider.WILDSTACKER, Provider.ROSESTACKER, Provider.ULTIMATESTACKER, Provider.SILKSPAWNERSV2, Provider.SILKSPAWNERS, Provider.MINEABLESPAWNERS).iterator();
                while (iterator.hasNext() && (spawnerProvider = this.setup(provider = iterator.next(), true)) == null) {
                }
                if (this.provider != null) break;
                SendMessage.infoMessage("Failed to automatically find compatible spawner provider, using default...");
                this.provider = this.initProvider(Provider.DEFAULT, null);
            }
        }
        return this.provider;
    }

    public SpawnerProvider getProvider() {
        return this.provider;
    }

    private static String getLog(String message, String provider) {
        return message.replace("%provider%", provider);
    }

    private SpawnerProvider initProvider(Provider provider, @Nullable Object api) {
        switch (provider) {
            case ULTIMATESTACKER: {
                return new UltimateStackerHook();
            }
            case WILDSTACKER: {
                return new WildStackerHook((WildStacker)api);
            }
            case SILKSPAWNERS: {
                return new SilkSpawnersHook((SilkUtil)api);
            }
            case ROSESTACKER: {
                return new RoseStackerHook();
            }
            case MINEABLESPAWNERS: {
                return new MineableSpawnersHook();
            }
            case SILKSPAWNERSV2: {
                return new SilkSpawnersV2Hook();
            }
            case DISABLED: {
                return new DefaultSpawnerProvider(this.plugin, null, null, null);
            }
            case DEFAULT: {
                return new DefaultSpawnerProvider(this.plugin, !ConfigManager.getConfig().getBoolean("allow-spawner-type-change") ? (this.interactEvent = new SpawnerInteractEvent()) : null, ConfigManager.getConfig().getBoolean("enable-spawnerplace") ? (this.placeEvent = new SpawnerPlaceEvent(this.plugin)) : null, ConfigManager.getConfig().getBoolean("enable-spawnerbreak") ? (this.breakEvent = new SpawnerBreakEvent(this.plugin)) : null);
            }
        }
        return new DefaultSpawnerProvider(this.plugin, !ConfigManager.getConfig().getBoolean("allow-spawner-type-change") ? (this.interactEvent = new SpawnerInteractEvent()) : null, ConfigManager.getConfig().getBoolean("enable-spawnerplace") ? (this.placeEvent = new SpawnerPlaceEvent(this.plugin)) : null, ConfigManager.getConfig().getBoolean("enable-spawnerbreak") ? (this.breakEvent = new SpawnerBreakEvent(this.plugin)) : null);
    }

    private static enum Provider {
        ULTIMATESTACKER("UltimateStacker"),
        WILDSTACKER("WildStacker"),
        SILKSPAWNERS("SilkSpawners"),
        SILKSPAWNERSV2("SilkSpawners_v2"),
        ROSESTACKER("RoseStacker"),
        MINEABLESPAWNERS("MineableSpawners"),
        DISABLED("DISABLED"),
        DEFAULT("DEFAULT"),
        AUTO("AUTO");

        private final String name;

        private Provider(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getPluginName() {
            return this.name;
        }

        public static Provider getFromString(String rawName) {
            try {
                SendMessage.infoMessage(SpawnerManager.getLog(Lang.SPAWNER_COMPATIBILITY_ENABLED.get(), rawName));
                return Provider.valueOf(rawName.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                SendMessage.warnMessage("Failed to find a spawner provider using name '" + rawName + "'");
                return AUTO;
            }
        }
    }
}

