/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.providers.economys;

import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.files.ConfigManager;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.providers.EconomyProvider;
import me.gypopo.economyshopgui.util.EcoType;
import me.gypopo.economyshopgui.util.EconomyType;
import me.gypopo.economyshopgui.util.exceptions.EconomyLoadException;
import me.xanium.gemseconomy.api.GemsEconomyAPI;
import me.xanium.gemseconomy.currency.Currency;
import org.bukkit.OfflinePlayer;

public class GemsEconomy
implements EconomyProvider {
    private GemsEconomyAPI gems;
    private final String currency;
    private Currency cur;
    private String friendly;
    private String singular;
    private String plural;
    private boolean decimal;

    public GemsEconomy(String currency) {
        this.currency = currency;
    }

    @Override
    public void setup(EconomyShopGUI plugin) throws EconomyLoadException {
        if (plugin.getServer().getPluginManager().isPluginEnabled("GemsEconomy")) {
            this.gems = new GemsEconomyAPI();
            if (this.gems == null) {
                throw new EconomyLoadException("Failed to hook into GemsEconomy");
            }
        } else {
            throw new EconomyLoadException("Could not find GemsEconomy");
        }
        this.registerCurrency();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerCurrency() throws EconomyLoadException {
        if (this.currency == null || this.currency.isEmpty()) {
            this.cur = this.gems.plugin.getCurrencyManager().getDefaultCurrency();
            if (this.cur == null) throw new EconomyLoadException("Failed to find default currency from GemsEconomy");
            SendMessage.infoMessage("Successfully hooked into GemsEconomy and using default currency: " + this.cur.getPlural());
        } else {
            this.cur = this.gems.getCurrency(this.currency);
            if (this.cur == null) throw new EconomyLoadException("Failed to register a GemsEconomy currency named as '" + this.currency + "'");
            SendMessage.infoMessage("Successfully registered currency '" + this.currency + "' from GemsEconomy");
        }
        this.formatSingular();
        this.formatPlural();
        this.decimal = this.cur.isDecimalSupported();
    }

    @Override
    public double getBalance(OfflinePlayer p) {
        return this.gems.getBalance(p.getUniqueId(), this.cur);
    }

    @Override
    public void depositBalance(OfflinePlayer p, double amount) {
        this.gems.deposit(p.getUniqueId(), !this.decimal ? (double)Math.round(amount) : amount, this.cur);
    }

    @Override
    public void withdrawBalance(OfflinePlayer p, double amount) {
        this.gems.withdraw(p.getUniqueId(), !this.decimal ? (double)Math.round(amount) : amount, this.cur);
    }

    @Override
    public EcoType getType() {
        return new EcoType(EconomyType.GEMS_ECONOMY, this.currency);
    }

    @Override
    public String getPlural() {
        return this.plural;
    }

    @Override
    public String getSingular() {
        return this.singular;
    }

    @Override
    public String getFriendly() {
        return this.friendly;
    }

    @Override
    public boolean isDecimal() {
        return this.decimal;
    }

    private void formatSingular() {
        String singular = ConfigManager.getConfig().getString("currency-formats.gems-economy:" + this.currency + ".singular", ConfigManager.getConfig().getString("currency-formats.gems-economy.singular", this.cur.getSingular()));
        this.singular = this.isSymbol(singular) ? Lang.SYMBOL_PRICING_FORMAT.get().replace("%symbol%", singular) : Lang.NAMED_PRICING_FORMAT.get().replace("%currency-format%", singular);
    }

    private void formatPlural() {
        String plural = ConfigManager.getConfig().getString("currency-formats.gems-economy:" + this.currency + ".plural", ConfigManager.getConfig().getString("currency-formats.gems-economy.plural", this.cur.getPlural()));
        this.friendly = ConfigManager.getConfig().getString("currency-formats.gems-economy:" + this.currency + ".friendly", ConfigManager.getConfig().getString("currency-formats.gems-economy.friendly", this.cur.getPlural()));
        this.plural = this.isSymbol(plural) ? Lang.SYMBOL_PRICING_FORMAT.get().replace("%symbol%", plural) : Lang.NAMED_PRICING_FORMAT.get().replace("%currency-format%", plural);
    }

    private boolean isSymbol(String format) {
        return format.chars().count() == 1L;
    }
}

