/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.providers.economys;

import java.util.Optional;
import me.TechsCode.UltraEconomy.UltraEconomyAPI;
import me.TechsCode.UltraEconomy.objects.Account;
import me.TechsCode.UltraEconomy.objects.Currency;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.files.ConfigManager;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.providers.EconomyProvider;
import me.gypopo.economyshopgui.util.EcoType;
import me.gypopo.economyshopgui.util.EconomyType;
import me.gypopo.economyshopgui.util.exceptions.EconomyLoadException;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;

public class UltraEconomy
implements EconomyProvider {
    private UltraEconomyAPI ue;
    private Currency cur;
    private final String currency;
    private String friendly;
    private String singular;
    private String plural;
    private final boolean decimal = true;

    public UltraEconomy(String currency) {
        this.currency = currency;
    }

    @Override
    public void setup(EconomyShopGUI plugin) throws EconomyLoadException {
        if (plugin.getServer().getPluginManager().isPluginEnabled("UltraEconomy")) {
            this.ue = me.TechsCode.UltraEconomy.UltraEconomy.getAPI();
            if (this.ue == null) {
                throw new EconomyLoadException("Failed to hook into UltraEconomy");
            }
        } else {
            throw new EconomyLoadException("Could not find UltraEconomy");
        }
        this.registerCurrency();
    }

    private void registerCurrency() throws EconomyLoadException {
        if (this.currency == null || this.currency.isEmpty()) {
            try {
                this.cur = (Currency)this.ue.getCurrencies().get(0);
                SendMessage.infoMessage("Successfully hooked into UltraEconomy and using default currency: " + this.cur.getName());
            }
            catch (IndexOutOfBoundsException e) {
                throw new EconomyLoadException("Failed to find a currency in UltraEconomy");
            }
        } else {
            Optional cur = this.ue.getCurrencies().name(this.currency);
            if (cur.isPresent()) {
                this.cur = (Currency)cur.get();
                SendMessage.infoMessage("Successfully registered currency '" + this.currency + "' from UltraEconomy");
            } else {
                throw new EconomyLoadException("Failed to register a UltraEconomy currency named as '" + this.currency + "'");
            }
        }
        this.formatSingular();
        this.formatPlural();
    }

    @Override
    public double getBalance(OfflinePlayer p) {
        Optional acc = this.ue.getAccounts().uuid(p.getUniqueId());
        if (acc.isPresent()) {
            return ((Account)acc.get()).getBalance(this.cur).getOnHand();
        }
        SendMessage.warnMessage("UltraEconomy Failed to retrieve the account from player '" + p.getName() + "'");
        return 0.0;
    }

    @Override
    public void depositBalance(OfflinePlayer p, double amount) {
        Optional acc = this.ue.getAccounts().uuid(p.getUniqueId());
        if (acc.isPresent()) {
            ((Account)acc.get()).getBalance(this.cur).addHand((double)((float)amount));
        } else {
            SendMessage.warnMessage("UltraEconomy Failed to retrieve the account from player '" + p.getName() + "'");
        }
    }

    @Override
    public void withdrawBalance(OfflinePlayer p, double amount) {
        Optional acc = this.ue.getAccounts().uuid(p.getUniqueId());
        if (acc.isPresent()) {
            ((Account)acc.get()).getBalance(this.cur).removeHand((double)((float)amount));
        } else {
            SendMessage.warnMessage("UltraEconomy Failed to retrieve the account from player '" + p.getName() + "'");
        }
    }

    @Override
    public EcoType getType() {
        return new EcoType(EconomyType.ULTRA_ECONOMY, this.currency);
    }

    @Override
    public String getPlural() {
        return this.plural;
    }

    @Override
    public String getSingular() {
        return this.singular;
    }

    @Override
    public String getFriendly() {
        return this.friendly;
    }

    @Override
    public boolean isDecimal() {
        return this.decimal;
    }

    private void formatSingular() {
        String singular = ConfigManager.getConfig().getString("currency-formats.ultra-economy:" + this.currency + ".singular", ConfigManager.getConfig().getString("currency-formats.ultra-economy.singular", ChatColor.stripColor((String)this.cur.getFormat().getSingularFormat().replace("{Amount} ", "").replace(" {Amount}", "").replace("{Amount}", ""))));
        this.singular = this.isSymbol(singular) ? Lang.SYMBOL_PRICING_FORMAT.get().replace("%symbol%", singular) : Lang.NAMED_PRICING_FORMAT.get().replace("%currency-format%", singular);
    }

    private void formatPlural() {
        String plural = ConfigManager.getConfig().getString("currency-formats.ultra-economy:" + this.currency + ".plural", ConfigManager.getConfig().getString("currency-formats.ultra-economy.plural", ChatColor.stripColor((String)this.cur.getFormat().getPluralFormat().replace("{Amount} ", "").replace(" {Amount}", "").replace("{Amount}", ""))));
        this.friendly = ConfigManager.getConfig().getString("currency-formats.ultra-economy:" + this.currency + ".friendly", ConfigManager.getConfig().getString("currency-formats.ultra-economy.friendly", plural));
        this.plural = this.isSymbol(plural) ? Lang.SYMBOL_PRICING_FORMAT.get().replace("%symbol%", plural) : Lang.NAMED_PRICING_FORMAT.get().replace("%currency-format%", plural);
    }

    private boolean isSymbol(String format) {
        return format.chars().count() == 1L;
    }
}

