/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.command.admin;

import com.google.common.collect.Maps;
import com.handy.playertitle.constants.BuyTypeEnum;
import com.handy.playertitle.constants.CommandChildTypeEnum;
import com.handy.playertitle.entity.TitleList;
import com.handy.playertitle.hook.PlaceholderApiUtil;
import com.handy.playertitle.lib.command.IHandyCommandEvent;
import com.handy.playertitle.lib.core.MapUtil;
import com.handy.playertitle.lib.core.SignUtil;
import com.handy.playertitle.lib.util.AssertUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.ItemStackUtil;
import com.handy.playertitle.lib.util.MessageUtil;
import com.handy.playertitle.service.TitleBuffService;
import com.handy.playertitle.service.TitleListService;
import com.handy.playertitle.util.ConfigUtil;
import com.handy.playertitle.util.TitleUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CardCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "card";
    }

    @Override
    public String permission() {
        return "playerTitle.card";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        Player player;
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        if (args.length > 5) {
            Optional<Player> onlinePlayer = BaseUtil.getOnlinePlayer(args[5]);
            AssertUtil.isTrue(onlinePlayer.isPresent(), sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
            player = onlinePlayer.get();
        } else {
            player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        }
        switch (CommandChildTypeEnum.getEnum(args[1], "card")) {
            case CARD_CREATE: {
                Integer id;
                AssertUtil.notTrue(args.length < 5, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
                Integer titleId = AssertUtil.isNumericToInt(args[2], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
                Integer createDay = AssertUtil.isNumericToInt(args[3], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
                Integer num = AssertUtil.isNumericToInt(args[4], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
                if (!SignUtil.isGenuine() && (id = TitleListService.getInstance().findOneHundredCount()) > 0 && titleId >= id) {
                    MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("currlimig"));
                    return;
                }
                Optional<TitleList> titleListOptional = TitleListService.getInstance().findById(titleId);
                AssertUtil.isTrue(titleListOptional.isPresent(), sender, ConfigUtil.LANG_CONFIG.getString("changeItem.noTitleFailMsg", "&8[&c\u2718&8] &7\u6ca1\u6709\u627e\u5230\u8be5\u79f0\u53f7"));
                TitleList titleList = titleListOptional.get();
                titleList.setTitleBuffs(TitleBuffService.getInstance().findByTitleId(titleList.getId()));
                ItemStack createItemStack = new ItemStack(Material.PAPER);
                ItemMeta createItemMeta = ItemStackUtil.getItemMeta(createItemStack);
                String titleName = PlaceholderApiUtil.set(player, titleList.getTitleName());
                createItemMeta.setDisplayName(BaseUtil.getMsgNotColor("changeItem.titleCard") + BaseUtil.replaceChatColor(titleName));
                List<String> createLoreList = ConfigUtil.LANG_CONFIG.getStringList("changeItem.titleCardLore");
                Map<String, String> replaceLoreMap = this.getReplaceLoreMap(titleList, createDay);
                createLoreList = ItemStackUtil.loreReplaceMap(createLoreList, replaceLoreMap);
                HashMap<String, List<String>> replaceBatchMap = MapUtil.of("buff", TitleUtil.getBuff(titleList.getTitleBuffs()));
                createLoreList = ItemStackUtil.loreBatchReplaceMap(createLoreList, replaceBatchMap, BaseUtil.getMsgNotColor("not"));
                createLoreList = PlaceholderApiUtil.set(player, createLoreList);
                createItemMeta.setLore(BaseUtil.replaceChatColor(createLoreList));
                TitleUtil.setCardData(createItemMeta, titleId, createDay);
                int defCustomModelDataId = ConfigUtil.MATERIAL_CONFIG.getInt("changeItem.custom-model-data");
                int createCustomModelDataId = ConfigUtil.MATERIAL_CONFIG.getInt(titleList.getId() + "_custom-model-data", defCustomModelDataId);
                ItemStackUtil.setCustomModelData(createItemMeta, createCustomModelDataId);
                createItemStack.setItemMeta(createItemMeta);
                createItemStack.setAmount(num.intValue());
                ItemStackUtil.addItem(player.getInventory(), createItemStack, createItemStack.getAmount());
                MessageUtil.sendMessage(player, ConfigUtil.LANG_CONFIG.getString("succeedMsg"));
                break;
            }
            case CARD_RANDOM: {
                AssertUtil.notTrue(args.length < 4, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
                int randomDay = AssertUtil.isNumericToInt(args[3], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
                BuyTypeEnum buyType = BuyTypeEnum.getEnum(args[2]);
                AssertUtil.notNull((Object)buyType, (CommandSender)player, BaseUtil.getMsgNotColor("buyTypeFailureMsg") + " " + args[2]);
                String buyTypeName = ": " + BaseUtil.getMsgNotColor("buyType." + buyType.getBuyType());
                Integer buyTypeId = buyType.getBuyTypeId();
                ItemStack randomItemStack = new ItemStack(Material.PAPER);
                ItemMeta randomItemMeta = ItemStackUtil.getItemMeta(randomItemStack);
                randomItemMeta.setDisplayName(BaseUtil.getMsgNotColor("randomCard.titleCard") + buyTypeName);
                ArrayList<String> randomLoreList = new ArrayList<String>();
                List titleCardLore = ConfigUtil.LANG_CONFIG.getStringList("randomCard.titleCardLore");
                for (String lore : titleCardLore) {
                    String newDay = randomDay != 0 ? randomDay + BaseUtil.getMsgNotColor("shop.day") : BaseUtil.getMsgNotColor("perpetual");
                    lore = lore.replace("${expirationTime}", newDay);
                    randomLoreList.add(lore);
                }
                randomItemMeta.setLore(BaseUtil.replaceChatColor(randomLoreList));
                TitleUtil.setCardData(randomItemMeta, buyTypeId, randomDay);
                int randomCustomModelDataId = ConfigUtil.MATERIAL_CONFIG.getInt("randomCard.custom-model-data");
                ItemStackUtil.setCustomModelData(randomItemMeta, randomCustomModelDataId);
                randomItemStack.setItemMeta(randomItemMeta);
                ItemStackUtil.addItem(player.getInventory(), randomItemStack, randomItemStack.getAmount());
                MessageUtil.sendMessage(player, ConfigUtil.LANG_CONFIG.getString("succeedMsg"));
                break;
            }
            default: {
                MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("typeFailureMsg"));
            }
        }
    }

    private Map<String, String> getReplaceLoreMap(TitleList titleList, Integer day) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        map.put("id", titleList.getId().toString());
        map.put("titleName", titleList.getTitleName());
        map.put("description", titleList.getDescription() != null ? titleList.getDescription() : "");
        map.put("expirationTime", day != 0 ? day + BaseUtil.getMsgNotColor("shop.day") : BaseUtil.getMsgNotColor("perpetual"));
        return map;
    }
}

