/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.command.admin;

import com.handy.playertitle.constants.CommandChildTypeEnum;
import com.handy.playertitle.constants.ParticleTypeEnum;
import com.handy.playertitle.constants.particle.SuperTrailsColorEnum;
import com.handy.playertitle.constants.particle.SuperTrailsProColorEnum;
import com.handy.playertitle.entity.TitleParticle;
import com.handy.playertitle.lib.command.IHandyCommandEvent;
import com.handy.playertitle.lib.core.NumberUtil;
import com.handy.playertitle.lib.util.AssertUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.MessageUtil;
import com.handy.playertitle.service.TitleParticleService;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class ParticleCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "particle";
    }

    @Override
    public String permission() {
        return "playerTitle.particle";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        AssertUtil.notTrue(args.length < 3, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Integer titleId = AssertUtil.isNumericToInt(args[2], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        switch (CommandChildTypeEnum.getEnum(args[1], "particle")) {
            case PARTICLE_ADD_PARTICLE: {
                AssertUtil.notTrue(args.length < 4, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
                ParticleTypeEnum typeEnum = ParticleTypeEnum.getEnum(args[3]);
                TitleParticle titleParticle = new TitleParticle();
                titleParticle.setTitleId(titleId);
                titleParticle.setParticleType(typeEnum.getParticleType());
                switch (typeEnum) {
                    case SUPER_TRAILS: {
                        AssertUtil.notTrue(args.length < 5, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
                        String idStr = args[4];
                        String[] split = idStr.trim().split("\\(");
                        idStr = split[0];
                        Integer id = NumberUtil.isNumericToInt(idStr);
                        titleParticle.setSuperTrailsId(id);
                        if (titleParticle.getSuperTrailsId() != 55 && titleParticle.getSuperTrailsId() != 56) break;
                        AssertUtil.notTrue(args.length < 7, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
                        SuperTrailsColorEnum wingColorEnum = SuperTrailsColorEnum.getEnum(args[5]);
                        AssertUtil.notNull((Object)wingColorEnum, sender, BaseUtil.getMsgNotColor("typeFailureMsg"));
                        SuperTrailsColorEnum wingColorEnum1 = SuperTrailsColorEnum.getEnum(args[6]);
                        AssertUtil.notNull((Object)wingColorEnum1, sender, BaseUtil.getMsgNotColor("typeFailureMsg"));
                        SuperTrailsColorEnum wingColorEnum2 = SuperTrailsColorEnum.getEnum(args[7]);
                        AssertUtil.notNull((Object)wingColorEnum2, sender, BaseUtil.getMsgNotColor("typeFailureMsg"));
                        titleParticle.setWingColor(args[5]);
                        titleParticle.setWingContour(args[6]);
                        titleParticle.setWingThirdColor(args[7]);
                        break;
                    }
                    case SUPER_TRAILS_PRO: {
                        AssertUtil.notTrue(args.length < 5, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
                        String idStrPro = args[4];
                        String[] splitPro = idStrPro.trim().split("\\(");
                        idStrPro = splitPro[0];
                        Integer idPro = NumberUtil.isNumericToInt(idStrPro);
                        titleParticle.setSuperTrailsId(idPro);
                        if (titleParticle.getSuperTrailsId() < 300 || titleParticle.getSuperTrailsId() > 353) break;
                        AssertUtil.notTrue(args.length < 7, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
                        SuperTrailsProColorEnum superTrailsProColorEnum = SuperTrailsProColorEnum.getEnum(args[5]);
                        AssertUtil.notNull((Object)superTrailsProColorEnum, sender, BaseUtil.getMsgNotColor("typeFailureMsg"));
                        SuperTrailsProColorEnum superTrailsProColorEnum1 = SuperTrailsProColorEnum.getEnum(args[6]);
                        AssertUtil.notNull((Object)superTrailsProColorEnum1, sender, BaseUtil.getMsgNotColor("typeFailureMsg"));
                        SuperTrailsProColorEnum superTrailsProColorEnum2 = SuperTrailsProColorEnum.getEnum(args[7]);
                        AssertUtil.notNull((Object)superTrailsProColorEnum2, sender, BaseUtil.getMsgNotColor("typeFailureMsg"));
                        titleParticle.setWingColor(args[5]);
                        titleParticle.setWingContour(args[6]);
                        titleParticle.setWingThirdColor(args[7]);
                        break;
                    }
                    case PLAYER_PARTICLES: {
                        AssertUtil.notTrue(args.length < 6, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
                        titleParticle.setWingColor(args[4]);
                        titleParticle.setWingContour(args[5]);
                        if (args.length < 7) break;
                        titleParticle.setWingThirdColor(args[6]);
                        break;
                    }
                }
                boolean rst = TitleParticleService.getInstance().add(titleParticle);
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst ? "succeedMsg" : "failureMsg"));
                break;
            }
            case PARTICLE_DELETE_PARTICLE: {
                boolean rst = TitleParticleService.getInstance().removeByTitleId(titleId);
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst ? "succeedMsg" : "failureMsg"));
                break;
            }
            default: {
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("typeFailureMsg"));
            }
        }
    }
}

