/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.constants;

import com.handy.playertitle.PlayerTitle;
import com.handy.playertitle.constants.BuffTypeEnum;
import com.handy.playertitle.lib.util.MessageUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BuffType {
    private static final Map<String, BuffType> BUFF_TYPE_LIST = new LinkedHashMap<String, BuffType>();
    private String buffType;
    private String buffTypeName;
    private String pluginName;

    public static List<String> getBuffTypeList() {
        return new ArrayList<String>(BUFF_TYPE_LIST.keySet());
    }

    public static Map<String, BuffType> getBuffTypeMap() {
        return BUFF_TYPE_LIST;
    }

    public static void put(String buffType, String buffTypeName, String pluginName) {
        BuffType type = BuffType.builder().buffType(buffType).buffTypeName(buffTypeName).pluginName(pluginName).build();
        BUFF_TYPE_LIST.put(buffType, type);
    }

    public static String getTypeName(String buffType) {
        BuffType type = BUFF_TYPE_LIST.get(buffType);
        return type != null ? type.getBuffTypeName() : "&a\u65e0";
    }

    public static BuffType getType(String buffTypeStr) {
        for (String buffType : BUFF_TYPE_LIST.keySet()) {
            BuffType type = BUFF_TYPE_LIST.get(buffType);
            if (!type.getBuffType().equals(buffTypeStr)) continue;
            return type;
        }
        MessageUtil.sendConsoleMessage("\u83b7\u53d6\u79f0\u53f7buff\u7c7b\u578b\u53d1\u751f\u5f02\u5e38\uff0c\u5165\u53c2:" + buffTypeStr);
        return BuffType.builder().buffType(buffTypeStr).buffTypeName(buffTypeStr).pluginName("error").build();
    }

    public static void remove(String buffType) {
        BUFF_TYPE_LIST.remove(buffType);
    }

    BuffType(String buffType, String buffTypeName, String pluginName) {
        this.buffType = buffType;
        this.buffTypeName = buffTypeName;
        this.pluginName = pluginName;
    }

    public static BuffTypeBuilder builder() {
        return new BuffTypeBuilder();
    }

    public String getBuffType() {
        return this.buffType;
    }

    public String getBuffTypeName() {
        return this.buffTypeName;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    static {
        String pluginName = PlayerTitle.getInstance().getName();
        for (BuffTypeEnum buffTypeEnum : BuffTypeEnum.values()) {
            BUFF_TYPE_LIST.put(buffTypeEnum.getBuffType(), BuffType.builder().buffType(buffTypeEnum.getBuffType()).buffTypeName(buffTypeEnum.getBuffTypeName()).pluginName(pluginName).build());
        }
    }

    public static class BuffTypeBuilder {
        private String buffType;
        private String buffTypeName;
        private String pluginName;

        BuffTypeBuilder() {
        }

        public BuffTypeBuilder buffType(String buffType) {
            this.buffType = buffType;
            return this;
        }

        public BuffTypeBuilder buffTypeName(String buffTypeName) {
            this.buffTypeName = buffTypeName;
            return this;
        }

        public BuffTypeBuilder pluginName(String pluginName) {
            this.pluginName = pluginName;
            return this;
        }

        public BuffType build() {
            return new BuffType(this.buffType, this.buffTypeName, this.pluginName);
        }

        public String toString() {
            return "BuffType.BuffTypeBuilder(buffType=" + this.buffType + ", buffTypeName=" + this.buffTypeName + ", pluginName=" + this.pluginName + ")";
        }
    }
}

