/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.constants;

import com.handy.playertitle.lib.exception.HandyException;
import java.util.ArrayList;
import java.util.List;

public enum BuyTypeEnum {
    ALL("all", 0),
    NOT("not", 1),
    VAULT("vault", 2),
    PLAYER_POINTS("playerPoints", 3),
    COIN("coin", 4),
    ITEM_STACK("itemStack", 5),
    PERMISSION("permission", 6),
    ACTIVITY("activity", 7);

    private final String buyType;
    private final Integer buyTypeId;

    public static List<String> getBuyTypeList() {
        ArrayList<String> list = new ArrayList<String>();
        for (BuyTypeEnum buyTypeEnum : BuyTypeEnum.values()) {
            list.add(buyTypeEnum.buyType);
        }
        list.removeIf(type -> ALL.getBuyType().equals(type));
        return list;
    }

    public static List<String> getEnumListNotPermission() {
        List<String> buyTypeList = BuyTypeEnum.getBuyTypeList();
        buyTypeList.removeIf(type -> PERMISSION.getBuyType().equals(type));
        return buyTypeList;
    }

    public static BuyTypeEnum getEnum(String buyType) {
        for (BuyTypeEnum buyTypeEnum : BuyTypeEnum.values()) {
            if (!buyTypeEnum.getBuyType().equalsIgnoreCase(buyType)) continue;
            return buyTypeEnum;
        }
        return null;
    }

    public static BuyTypeEnum getEnumThrow(String buyType) {
        for (BuyTypeEnum buyTypeEnum : BuyTypeEnum.values()) {
            if (!buyTypeEnum.getBuyType().equalsIgnoreCase(buyType)) continue;
            return buyTypeEnum;
        }
        throw new HandyException("\u9519\u8bef\u7684\u8d2d\u4e70\u7c7b\u578b" + buyType);
    }

    public static BuyTypeEnum getEnum(Integer buyTypeId) {
        for (BuyTypeEnum buyTypeEnum : BuyTypeEnum.values()) {
            if (!buyTypeEnum.getBuyTypeId().equals(buyTypeId)) continue;
            return buyTypeEnum;
        }
        return null;
    }

    public static String getNextEnum(String buyType) {
        BuyTypeEnum anEnum = BuyTypeEnum.getEnum(buyType);
        if (anEnum == null) {
            return ALL.getBuyType();
        }
        int num = anEnum.getBuyTypeId() + 1;
        if (num > 7) {
            num = 0;
        }
        for (BuyTypeEnum buyTypeEnum : BuyTypeEnum.values()) {
            if (buyTypeEnum.getBuyTypeId() != num) continue;
            return buyTypeEnum.getBuyType();
        }
        return ALL.getBuyType();
    }

    public String getBuyType() {
        return this.buyType;
    }

    public Integer getBuyTypeId() {
        return this.buyTypeId;
    }

    private BuyTypeEnum(String buyType, Integer buyTypeId) {
        this.buyType = buyType;
        this.buyTypeId = buyTypeId;
    }
}

